/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hcjf.properties.SystemProperties;

public final class Strings {
    public static final String DEFAULT_PADDING_VALUE = " ";
    public static final String START_GROUP = "(";
    public static final String END_GROUP = ")";
    public static final String START_SUB_GROUP = "[";
    public static final String END_SUB_GROUP = "]";
    public static final String START_OBJECT = "{";
    public static final String END_OBJECT = "}";
    public static final String OBJECT_FIELD_SEPARATOR = ":";
    public static final String REPLACEABLE_GROUP = "\u00bf";
    public static final String EMPTY_STRING = "";
    public static final String WHITE_SPACE = " ";
    public static final String CLASS_SEPARATOR = ".";
    public static final String CLASS_SEPARATOR_WITH_SCAPE_CHARACTER = "\\.";
    public static final String UNDERSCORE = "_";
    public static final String CASE_INSENSITIVE_REGEX_FLAG = "(?i)";
    public static final String ARGUMENT_SEPARATOR = ",";
    public static final String ARGUMENT_SEPARATOR_2 = ";";
    public static final String ASSIGNATION = "=";
    public static final String REPLACEABLE_RICH_TEXT = "\u00a1";
    public static final String RICH_TEXT_SEPARATOR = "'";
    public static final String RICH_TEXT_SKIP_CHARACTER = "\\";
    public static final String CARRIAGE_RETURN_AND_LINE_SEPARATOR = "\r\n";
    public static final String CARRIAGE_RETURN = "\r";
    public static final String LINE_SEPARATOR = "\n";
    public static final String TAB = "\t";
    public static final String SLASH = "/";
    public static final String AT = "@";
    public static final String ALL = "*";
    public static final String SPLIT_BY_LENGTH_REGEX = "(?<=\\G.{%d})";
    public static final String REPLACEABLE_EXPRESSION_REGEX = "\u00bf[0-9]{1,}";

    public static String trim(String value, String limitStrings) {
        return Strings.trim(value, limitStrings, limitStrings);
    }

    public static String trim(String value, String startingString, String endingString) {
        String result = value;
        boolean trim = false;
        int start = 0;
        int end = value.length();
        if (value.startsWith(startingString)) {
            start = startingString.length();
            trim = true;
        }
        if (value.endsWith(endingString)) {
            end -= endingString.length();
            trim = true;
        }
        if (trim) {
            result = start < end ? value.substring(start, end) : EMPTY_STRING;
        }
        return result;
    }

    public static String removeLines(String value) {
        return value.replace(CARRIAGE_RETURN_AND_LINE_SEPARATOR, " ").replace(LINE_SEPARATOR, " ");
    }

    public static String join(Collection<String> values, String separator) {
        return Strings.join(values.stream(), separator);
    }

    public static String join(Stream<String> values, String separator) {
        Builder builder = new Builder();
        values.filter(S -> !S.isEmpty()).forEach(S -> builder.append((String)S, separator));
        return builder.toString();
    }

    public static String join(Collection<String> values, String startValue, String endValue, String separator) {
        return Strings.join(values.stream(), startValue, endValue, separator);
    }

    public static String join(Stream<String> values, String startValue, String endValue, String separator) {
        Builder builder = new Builder();
        values.filter(S -> !S.isEmpty()).forEach(S -> builder.append(startValue).append((String)S).append(endValue, separator));
        return builder.toString();
    }

    public static String capitalize(String value) {
        String result = value;
        if (value != null && !value.trim().isEmpty()) {
            char[] chars = value.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            result = new String(chars);
        }
        return result;
    }

    public static String uncapitalize(String value) {
        String result = value;
        if (value != null && !value.trim().isEmpty()) {
            char[] chars = value.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            result = new String(chars);
        }
        return result;
    }

    public static String splitInWord(String value, String separator) {
        StringBuilder result = new StringBuilder();
        Character previousCharacter = null;
        for (char character : value.toCharArray()) {
            if (previousCharacter != null && Character.isLowerCase(previousCharacter.charValue()) && Character.isUpperCase(character)) {
                result.append(separator);
            }
            result.append(character);
            previousCharacter = Character.valueOf(character);
        }
        return result.toString();
    }

    public static String joinWords(String value, String separator) {
        String[] words;
        StringBuilder result = new StringBuilder();
        for (String word : words = value.split(separator)) {
            result.append(Strings.capitalize(word));
        }
        return result.toString();
    }

    public static String leftPad(String value, int paddingSize) {
        return String.format("%1$" + paddingSize + "s", value);
    }

    public static String leftPad(String value, String paddingValue, int paddingSize) {
        return Strings.leftPad(value, paddingSize).replace(" ", paddingValue);
    }

    public static String rightPad(String value, int paddingSize) {
        return String.format("%1$-" + paddingSize + "s", value);
    }

    public static String rightPad(String value, String paddingValue, int paddingSize) {
        return Strings.rightPad(value, paddingSize).replace(" ", paddingValue);
    }

    public static String wrap(String value, String wrapper) {
        return wrapper + value + wrapper;
    }

    public static Set<Integer> allIndexOf(String value, String foundedValue) {
        return Strings.allIndexOf(value, foundedValue, false);
    }

    public static Set<Integer> allIndexOf(String value, String foundedValue, boolean desc) {
        TreeSet<Integer> result = new TreeSet<Integer>((o1, o2) -> (o1 - o2) * (desc ? 1 : -1));
        int index = value.indexOf(foundedValue);
        while (index >= 0) {
            result.add(index);
            index = value.indexOf(foundedValue, index + 1);
        }
        return result;
    }

    public static List<String> groupRichText(String value) {
        ArrayList<String> result = new ArrayList<String>();
        Set<Integer> indexes = Strings.allIndexOf(value, RICH_TEXT_SEPARATOR, true);
        Integer counter = 0;
        Integer startIndex = -1;
        Integer endIndex = 0;
        StringBuilder newValue = new StringBuilder();
        for (Integer index : indexes) {
            if (index != 0 && value.charAt(index - 1) == RICH_TEXT_SKIP_CHARACTER.charAt(0)) continue;
            if (startIndex == -1) {
                startIndex = index;
                continue;
            }
            String richText = value.substring(startIndex + 1, index);
            newValue.append(value.substring(endIndex, startIndex));
            Integer n = counter;
            counter = counter + 1;
            newValue.append(RICH_TEXT_SEPARATOR).append(REPLACEABLE_RICH_TEXT).append(n).append(RICH_TEXT_SEPARATOR);
            result.add(richText);
            endIndex = index + 1;
            startIndex = -1;
        }
        if (endIndex < value.length()) {
            newValue.append(value.substring(endIndex));
        }
        if (result.isEmpty()) {
            result.add(value);
        } else {
            result.add(newValue.toString());
        }
        return result;
    }

    public static List<String> group(String value) {
        return Strings.group(value, START_GROUP, END_GROUP);
    }

    public static List<String> group(String value, String startGroupCharacter, String endGroupCharacter) {
        Set<Integer> startIndexes = Strings.allIndexOf(value, startGroupCharacter);
        Set<Integer> endIndexes = Strings.allIndexOf(value, endGroupCharacter);
        if (startIndexes.size() != endIndexes.size()) {
            throw new IllegalArgumentException("Expected the same amount of start and end group delimiter");
        }
        return Strings.group(value, startIndexes, endIndexes);
    }

    private static List<String> group(String value, Set<Integer> startIndexes, Set<Integer> endIndexes) {
        ArrayList<String> result = new ArrayList<String>();
        while (!startIndexes.isEmpty()) {
            Integer start = startIndexes.iterator().next();
            Iterator<Integer> endIterator = endIndexes.iterator();
            Integer end = Integer.MAX_VALUE;
            while (endIterator.hasNext()) {
                Integer candidate = endIterator.next();
                if (start >= candidate || candidate >= end) continue;
                end = candidate;
            }
            if (!endIndexes.remove(end)) {
                throw new IllegalArgumentException(EMPTY_STRING);
            }
            if (!startIndexes.remove(start)) {
                throw new IllegalArgumentException(EMPTY_STRING);
            }
            result.add(value.substring(start + 1, end));
        }
        return result;
    }

    public static List<String> replaceableGroup(String value) {
        List<String> groups = Strings.group(value);
        String replacedValue = value;
        for (int j = 0; j < groups.size(); ++j) {
            Integer occurrence = 0;
            String group = groups.get(j);
            String newSegment = START_GROUP + group + END_GROUP;
            replacedValue = Strings.replaceLast(replacedValue, newSegment, REPLACEABLE_GROUP + j);
            for (int k = j + 1; k < groups.size(); ++k) {
                String nextGroup = groups.get(k);
                if (nextGroup.equals(group)) {
                    occurrence = occurrence + 1;
                    continue;
                }
                if (!nextGroup.contains(START_GROUP) || occurrence >= Strings.occurrenceSize(nextGroup, newSegment)) continue;
                nextGroup = Strings.replaceLast(nextGroup, newSegment, REPLACEABLE_GROUP + j);
                groups.set(k, nextGroup);
            }
        }
        groups.add(replacedValue);
        return groups;
    }

    public static String getGroupIndex(String value, String groupIndicator) {
        char current;
        String result = null;
        Integer startIndex = value.indexOf(groupIndicator);
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = startIndex.intValue(); i < value.length() && i >= 0 && (Character.isDigit(current = value.charAt(i)) || current == groupIndicator.charAt(0)); ++i) {
            resultBuilder.append(current);
        }
        if (resultBuilder.length() > 0) {
            result = resultBuilder.toString();
        }
        return result;
    }

    public static String reverseRichTextGrouping(String value, List<String> richTextGroups) {
        String result = value;
        String groupIndex = Strings.getGroupIndex(result, REPLACEABLE_RICH_TEXT);
        while (groupIndex != null) {
            Integer index = Integer.parseInt(groupIndex.replace(REPLACEABLE_RICH_TEXT, EMPTY_STRING));
            result = result.replace(Strings.wrap(groupIndex, RICH_TEXT_SEPARATOR), Strings.wrap(richTextGroups.get(index), RICH_TEXT_SEPARATOR));
            groupIndex = Strings.getGroupIndex(result, REPLACEABLE_RICH_TEXT);
        }
        return result;
    }

    public static String reverseGrouping(String value, List<String> groups) {
        return Strings.reverseGrouping(value, groups, START_GROUP, END_GROUP);
    }

    public static String reverseGrouping(String value, List<String> groups, String startGroupCharacter, String endGroupCharacter) {
        String result = value;
        String groupIndex = Strings.getGroupIndex(result, REPLACEABLE_GROUP);
        while (groupIndex != null) {
            Integer index = Integer.parseInt(groupIndex.replace(REPLACEABLE_GROUP, EMPTY_STRING));
            result = result.replace(groupIndex, startGroupCharacter + groups.get(index) + endGroupCharacter);
            groupIndex = Strings.getGroupIndex(result, REPLACEABLE_GROUP);
        }
        return result;
    }

    public static Integer occurrenceSize(String value, String foundedSegment) {
        Integer result = 0;
        Integer index = 0;
        do {
            if ((index = Integer.valueOf(value.indexOf(foundedSegment, (int)index))) < 0) continue;
            result = result + 1;
            index = index + 1;
        } while (index >= 0);
        return result;
    }

    public static String replaceFirst(String value, String replaceSegment, String newSegment) {
        String result = value;
        int indexOf = value.indexOf(replaceSegment);
        if (indexOf >= 0) {
            String firstValue = value.substring(0, indexOf);
            String lastValue = value.substring(indexOf + replaceSegment.length());
            result = Strings.join(List.of(firstValue, newSegment, lastValue), EMPTY_STRING);
        }
        return result;
    }

    public static String replaceLast(String value, String replaceSegment, String newSegment) {
        String result = value;
        int indexOf = value.lastIndexOf(replaceSegment);
        if (indexOf >= 0) {
            String firstValue = value.substring(0, indexOf);
            String lastValue = value.substring(indexOf + replaceSegment.length());
            result = Strings.join(List.of(firstValue, newSegment, lastValue), EMPTY_STRING);
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    public static byte[] hexToBytes(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Input string must contain an even number of characters");
        }
        int len = hex.length();
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            result[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return result;
    }

    public static String[] splitByLength(String value, int length) {
        return value.split(String.format(SPLIT_BY_LENGTH_REGEX, length));
    }

    public static UUID createUUIDFromStringHash(String value) {
        return Strings.createUUIDFromStringHash(null, value);
    }

    public static UUID createUUIDFromStringHash(String value1, String value2) {
        return new UUID(value1 == null ? 0L : (long)value1.hashCode(), value2.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deductInstance(String value) {
        Object result;
        block43: {
            result = null;
            if (value != null) {
                String trimmedStringValue = value.trim();
                if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.null.reserved.word"))) {
                    result = null;
                } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.true.reserved.word"))) {
                    result = true;
                } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.false.reserved.word"))) {
                    result = false;
                } else if (trimmedStringValue.startsWith(SystemProperties.get("hcjf.query.string.delimiter.reserved.word")) && trimmedStringValue.endsWith(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"))) {
                    trimmedStringValue = trimmedStringValue.substring(1, trimmedStringValue.length() - 1);
                    try {
                        SimpleDateFormat simpleDateFormat = SystemProperties.getDateFormat("hcjf.default.date.format");
                        synchronized (simpleDateFormat) {
                            result = SystemProperties.getDateFormat("hcjf.default.date.format").parse(trimmedStringValue);
                        }
                    }
                    catch (Exception ex) {
                        result = trimmedStringValue;
                    }
                } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.uuid.regex"))) {
                    result = UUID.fromString(trimmedStringValue);
                } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.integer.number.regex"))) {
                    try {
                        long longValue = Long.parseLong(trimmedStringValue);
                        if (longValue == (long)((byte)longValue)) {
                            result = (byte)longValue;
                            break block43;
                        }
                        if (longValue == (long)((short)longValue)) {
                            result = (short)longValue;
                            break block43;
                        }
                        if (longValue == (long)((int)longValue)) {
                            result = (int)longValue;
                            break block43;
                        }
                        result = longValue;
                    }
                    catch (Exception ex) {
                        result = trimmedStringValue;
                    }
                } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.decimal.number.regex"))) {
                    try {
                        DecimalFormat ex = SystemProperties.getDecimalFormat("hcjf.default.number.format");
                        synchronized (ex) {
                            result = SystemProperties.getDecimalFormat("hcjf.default.number.format").parse(trimmedStringValue);
                            if (result instanceof Long) {
                                result = ((Long)result).doubleValue();
                            }
                        }
                    }
                    catch (ParseException e) {
                        result = trimmedStringValue;
                    }
                } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.scientific.number.regex"))) {
                    try {
                        DecimalFormat e = SystemProperties.getDecimalFormat("hcjf.default.scientific.number.format");
                        synchronized (e) {
                            result = SystemProperties.getDecimalFormat("hcjf.default.scientific.number.format").parse(trimmedStringValue);
                        }
                    }
                    catch (ParseException e) {
                        result = trimmedStringValue;
                    }
                } else {
                    try {
                        SimpleDateFormat e = SystemProperties.getDateFormat("hcjf.default.date.format");
                        synchronized (e) {
                            result = SystemProperties.getDateFormat("hcjf.default.date.format").parse(trimmedStringValue);
                        }
                    }
                    catch (Exception ex) {
                        result = trimmedStringValue;
                    }
                }
            }
        }
        return result;
    }

    public static final String createTaggedMessage(String message, String ... tags) {
        if (tags == null || tags.length == 0) {
            throw new IllegalArgumentException("Unable to create a tagged message without tags");
        }
        Builder builder = new Builder();
        for (String tag : tags) {
            if (tag.contains(START_OBJECT) || tag.contains(END_OBJECT) || tag.contains(ARGUMENT_SEPARATOR)) {
                throw new IllegalArgumentException("The tags can't contains the special characters '{', '}', ','");
            }
            builder.append(tag, ARGUMENT_SEPARATOR);
        }
        String result = String.format("$@{%s}%s", builder.toString(), message);
        return result;
    }

    public static final Map<String, String> getTagsFromMessage(String taggedMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (taggedMessage.startsWith("$@{")) {
            String tags = taggedMessage.substring(taggedMessage.indexOf("$@{") + "$@{".length(), taggedMessage.indexOf(END_OBJECT));
            String message = taggedMessage.substring(taggedMessage.indexOf(END_OBJECT) + END_OBJECT.length());
            for (String tag : tags.split(ARGUMENT_SEPARATOR)) {
                result.put(tag.trim(), message);
            }
        }
        return result;
    }

    public static final int getNoMatchPlace(Matcher matcher, String value) {
        int result = 0;
        for (int i = value.length(); i > 0; --i) {
            Matcher region = matcher.region(0, i);
            if (!region.matches() && !region.hitEnd()) continue;
            result = i;
            break;
        }
        return result;
    }

    public static final String getNearFrom(String value, int position, int length) {
        String result = null;
        if (value != null) {
            position = position < 0 ? 0 : position;
            position = position > value.length() ? value.length() : position;
            length = length == 0 ? 1 : length;
            int start = position - Math.abs(length);
            int end = position + Math.abs(length);
            start = start < 0 ? 0 : start;
            end = end > value.length() ? value.length() : end;
            result = value.substring(start, end);
        }
        return result;
    }

    public static final class Builder {
        private final StringBuilder builder = new StringBuilder();
        private String[] buffer;

        public Builder cleanBuffer() {
            this.buffer = null;
            return this;
        }

        private void checkBuffer() {
            if (this.buffer != null) {
                for (String bufferElement : this.buffer) {
                    this.builder.append(bufferElement);
                }
                this.buffer = null;
            }
        }

        public Builder append(Object obj) {
            this.checkBuffer();
            this.builder.append(obj);
            return this;
        }

        public Builder append(Object obj, String ... buffer) {
            this.checkBuffer();
            this.builder.append(obj);
            this.buffer = buffer;
            return this;
        }

        public Builder append(String str) {
            this.checkBuffer();
            this.builder.append(str);
            return this;
        }

        public Builder append(String str, String ... buffer) {
            this.checkBuffer();
            this.builder.append(str);
            this.buffer = buffer;
            return this;
        }

        public Builder append(StringBuffer sb) {
            this.checkBuffer();
            this.builder.append(sb);
            return this;
        }

        public Builder append(StringBuffer sb, String ... buffer) {
            this.checkBuffer();
            this.builder.append(sb);
            this.buffer = buffer;
            return this;
        }

        public Builder append(CharSequence s) {
            this.checkBuffer();
            this.builder.append(s);
            return this;
        }

        public Builder append(CharSequence s, String ... buffer) {
            this.checkBuffer();
            this.builder.append(s);
            this.buffer = buffer;
            return this;
        }

        public Builder append(CharSequence s, int start, int end) {
            this.checkBuffer();
            this.builder.append(s, start, end);
            return this;
        }

        public Builder append(CharSequence s, int start, int end, String ... buffer) {
            this.checkBuffer();
            this.builder.append(s, start, end);
            this.buffer = buffer;
            return this;
        }

        public Builder append(char[] str) {
            this.checkBuffer();
            this.builder.append(str);
            return this;
        }

        public Builder append(char[] str, String ... buffer) {
            this.checkBuffer();
            this.builder.append(str);
            this.buffer = buffer;
            return this;
        }

        public Builder append(char[] str, int offset, int len) {
            this.checkBuffer();
            this.builder.append(str, offset, len);
            return this;
        }

        public Builder append(char[] str, int offset, int len, String ... buffer) {
            this.checkBuffer();
            this.builder.append(str, offset, len);
            this.buffer = buffer;
            return this;
        }

        public Builder append(boolean b) {
            this.checkBuffer();
            this.builder.append(b);
            return this;
        }

        public Builder append(boolean b, String ... buffer) {
            this.checkBuffer();
            this.builder.append(b);
            this.buffer = buffer;
            return this;
        }

        public Builder append(char c) {
            this.checkBuffer();
            this.builder.append(c);
            return this;
        }

        public Builder append(char c, String ... buffer) {
            this.checkBuffer();
            this.builder.append(c);
            this.buffer = buffer;
            return this;
        }

        public Builder append(int i) {
            this.checkBuffer();
            this.builder.append(i);
            return this;
        }

        public Builder append(int i, String ... buffer) {
            this.checkBuffer();
            this.builder.append(i);
            this.buffer = buffer;
            return this;
        }

        public Builder append(long lng) {
            this.checkBuffer();
            this.builder.append(lng);
            return this;
        }

        public Builder append(long lng, String ... buffer) {
            this.checkBuffer();
            this.builder.append(lng);
            this.buffer = buffer;
            return this;
        }

        public Builder append(float f) {
            this.checkBuffer();
            this.builder.append(f);
            return this;
        }

        public Builder append(float f, String ... buffer) {
            this.checkBuffer();
            this.builder.append(f);
            this.buffer = buffer;
            return this;
        }

        public Builder append(double d) {
            this.checkBuffer();
            this.builder.append(d);
            return this;
        }

        public Builder append(double d, String ... buffer) {
            this.checkBuffer();
            this.builder.append(d);
            this.buffer = buffer;
            return this;
        }

        public Builder appendCodePoint(int codePoint) {
            this.builder.appendCodePoint(codePoint);
            return this;
        }

        public Builder delete(int start, int end) {
            this.builder.delete(start, end);
            return this;
        }

        public Builder deleteCharAt(int index) {
            this.builder.deleteCharAt(index);
            return this;
        }

        public Builder replace(int start, int end, String str) {
            this.builder.replace(start, end, str);
            return this;
        }

        public Builder insert(int index, char[] str, int offset, int len) {
            this.builder.insert(index, str, offset, len);
            return this;
        }

        public Builder insert(int offset, Object obj) {
            this.builder.insert(offset, obj);
            return this;
        }

        public Builder insert(int offset, String str) {
            this.builder.insert(offset, str);
            return this;
        }

        public Builder insert(int offset, char[] str) {
            this.builder.insert(offset, str);
            return this;
        }

        public Builder insert(int dstOffset, CharSequence s) {
            this.builder.insert(dstOffset, s);
            return this;
        }

        public Builder insert(int dstOffset, CharSequence s, int start, int end) {
            this.builder.insert(dstOffset, s, start, end);
            return this;
        }

        public Builder insert(int offset, boolean b) {
            this.builder.insert(offset, b);
            return this;
        }

        public Builder insert(int offset, char c) {
            this.builder.insert(offset, c);
            return this;
        }

        public Builder insert(int offset, int i) {
            this.builder.insert(offset, i);
            return this;
        }

        public Builder insert(int offset, long l) {
            this.builder.insert(offset, l);
            return this;
        }

        public Builder insert(int offset, float f) {
            this.builder.insert(offset, f);
            return this;
        }

        public Builder insert(int offset, double d) {
            this.builder.insert(offset, d);
            return this;
        }

        public int indexOf(String str) {
            return this.builder.indexOf(str);
        }

        public int indexOf(String str, int fromIndex) {
            return this.builder.indexOf(str, fromIndex);
        }

        public int lastIndexOf(String str) {
            return this.builder.lastIndexOf(str);
        }

        public int lastIndexOf(String str, int fromIndex) {
            return this.builder.lastIndexOf(str, fromIndex);
        }

        public Builder reverse() {
            this.builder.reverse();
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }

        public int length() {
            return this.builder.length();
        }

        public int capacity() {
            return this.builder.capacity();
        }

        public void ensureCapacity(int minimumCapacity) {
            this.builder.ensureCapacity(minimumCapacity);
        }

        public void trimToSize() {
            this.builder.trimToSize();
        }

        public void setLength(int newLength) {
            this.builder.setLength(newLength);
        }

        public char charAt(int index) {
            return this.builder.charAt(index);
        }

        public int codePointAt(int index) {
            return this.builder.codePointAt(index);
        }

        public int codePointBefore(int index) {
            return this.builder.codePointBefore(index);
        }

        public int codePointCount(int beginIndex, int endIndex) {
            return this.builder.codePointCount(beginIndex, endIndex);
        }

        public int offsetByCodePoints(int index, int codePointOffset) {
            return this.builder.offsetByCodePoints(index, codePointOffset);
        }

        public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
            this.builder.getChars(srcBegin, srcEnd, dst, dstBegin);
        }

        public void setCharAt(int index, char ch) {
            this.builder.setCharAt(index, ch);
        }

        public String substring(int start) {
            return this.builder.substring(start);
        }

        public CharSequence subSequence(int start, int end) {
            return this.builder.subSequence(start, end);
        }

        public String substring(int start, int end) {
            return this.builder.substring(start, end);
        }

        public IntStream chars() {
            return this.builder.chars();
        }

        public IntStream codePoints() {
            return this.builder.codePoints();
        }
    }

    public static final class TaggedMessages {
        public static final String START_TAGGED_MESSAGE = "$@{";
        public static final String TAGGED_MESSAGE_PATTERN = "$@{%s}%s";
    }

    public static final class StandardOutput {
        public static final String RESET = "\u001b[0m";
        public static final String CLEAN_LINES = "\u001b[1J";
        public static final String CURSOR_TO_HOME = "\u001b[H";
        public static final String BLACK = "\u001b[0;30m";
        public static final String RED = "\u001b[0;31m";
        public static final String GREEN = "\u001b[0;32m";
        public static final String YELLOW = "\u001b[0;33m";
        public static final String BLUE = "\u001b[0;34m";
        public static final String PURPLE = "\u001b[0;35m";
        public static final String CYAN = "\u001b[0;36m";
        public static final String WHITE = "\u001b[0;37m";
        public static final String BLACK_BOLD = "\u001b[1;30m";
        public static final String RED_BOLD = "\u001b[1;31m";
        public static final String GREEN_BOLD = "\u001b[1;32m";
        public static final String YELLOW_BOLD = "\u001b[1;33m";
        public static final String BLUE_BOLD = "\u001b[1;34m";
        public static final String PURPLE_BOLD = "\u001b[1;35m";
        public static final String CYAN_BOLD = "\u001b[1;36m";
        public static final String WHITE_BOLD = "\u001b[1;37m";
        public static final String BLACK_UNDERLINED = "\u001b[4;30m";
        public static final String RED_UNDERLINED = "\u001b[4;31m";
        public static final String GREEN_UNDERLINED = "\u001b[4;32m";
        public static final String YELLOW_UNDERLINED = "\u001b[4;33m";
        public static final String BLUE_UNDERLINED = "\u001b[4;34m";
        public static final String PURPLE_UNDERLINED = "\u001b[4;35m";
        public static final String CYAN_UNDERLINED = "\u001b[4;36m";
        public static final String WHITE_UNDERLINED = "\u001b[4;37m";
        public static final String BLACK_BACKGROUND = "\u001b[40m";
        public static final String RED_BACKGROUND = "\u001b[41m";
        public static final String GREEN_BACKGROUND = "\u001b[42m";
        public static final String YELLOW_BACKGROUND = "\u001b[43m";
        public static final String BLUE_BACKGROUND = "\u001b[44m";
        public static final String PURPLE_BACKGROUND = "\u001b[45m";
        public static final String CYAN_BACKGROUND = "\u001b[46m";
        public static final String WHITE_BACKGROUND = "\u001b[47m";
        public static final String BLACK_BRIGHT = "\u001b[0;90m";
        public static final String RED_BRIGHT = "\u001b[0;91m";
        public static final String GREEN_BRIGHT = "\u001b[0;92m";
        public static final String YELLOW_BRIGHT = "\u001b[0;93m";
        public static final String BLUE_BRIGHT = "\u001b[0;94m";
        public static final String PURPLE_BRIGHT = "\u001b[0;95m";
        public static final String CYAN_BRIGHT = "\u001b[0;96m";
        public static final String WHITE_BRIGHT = "\u001b[0;97m";
        public static final String BLACK_BOLD_BRIGHT = "\u001b[1;90m";
        public static final String RED_BOLD_BRIGHT = "\u001b[1;91m";
        public static final String GREEN_BOLD_BRIGHT = "\u001b[1;92m";
        public static final String YELLOW_BOLD_BRIGHT = "\u001b[1;93m";
        public static final String BLUE_BOLD_BRIGHT = "\u001b[1;94m";
        public static final String PURPLE_BOLD_BRIGHT = "\u001b[1;95m";
        public static final String CYAN_BOLD_BRIGHT = "\u001b[1;96m";
        public static final String WHITE_BOLD_BRIGHT = "\u001b[1;97m";
        public static final String BLACK_BACKGROUND_BRIGHT = "\u001b[0;100m";
        public static final String RED_BACKGROUND_BRIGHT = "\u001b[0;101m";
        public static final String GREEN_BACKGROUND_BRIGHT = "\u001b[0;102m";
        public static final String YELLOW_BACKGROUND_BRIGHT = "\u001b[0;103m";
        public static final String BLUE_BACKGROUND_BRIGHT = "\u001b[0;104m";
        public static final String PURPLE_BACKGROUND_BRIGHT = "\u001b[0;105m";
        public static final String CYAN_BACKGROUND_BRIGHT = "\u001b[0;106m";
        public static final String WHITE_BACKGROUND_BRIGHT = "\u001b[0;107m";
    }
}

