/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.util.UUID;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpServer;
import org.hcjf.io.net.http.HttpSession;
import org.hcjf.properties.SystemProperties;

public interface HttpSessionManager {
    public static final HttpSessionManager DEFAULT = new DefaultHttpSessionManager();

    public HttpSession createSession(HttpServer var1, NetPackage var2);

    public HttpSession checkSession(HttpSession var1, HttpRequest var2);

    public HttpSession destroySession(HttpSession var1);

    public static class DefaultHttpSessionManager
    implements HttpSessionManager {
        private DefaultHttpSessionManager() {
        }

        @Override
        public HttpSession createSession(HttpServer server, NetPackage netPackage) {
            HttpSession result = new HttpSession(UUID.randomUUID(), server);
            result.setSessionName(SystemProperties.get("hcjf.service.guest.session.name"));
            return result;
        }

        @Override
        public HttpSession checkSession(HttpSession session, HttpRequest request) {
            return session;
        }

        @Override
        public HttpSession destroySession(HttpSession session) {
            return session;
        }
    }
}

