/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.pipeline;

import java.nio.ByteBuffer;
import org.hcjf.io.net.http.pipeline.HttpPipelineResponse;

public abstract class MultipartHttpPipelineResponse
extends HttpPipelineResponse {
    private static final byte[] END = "--".getBytes();
    private static final byte[] MULTIPART_BOUNDARY_START = "\r\n--".getBytes();
    private static final byte[] HEADER_SEPARATOR = "\r\n".getBytes();
    private final String boundary;
    private boolean end;

    public MultipartHttpPipelineResponse(int mainBufferSize, int bufferSize, String boundary) {
        super(mainBufferSize, bufferSize);
        this.boundary = boundary;
    }

    @Override
    protected int wrap(ByteBuffer result, HttpPipelineResponse.StreamingPackage streamingPackage, int size) {
        int resultSize;
        if (size == -1 && this.end) {
            resultSize = -1;
        } else {
            result.put(MULTIPART_BOUNDARY_START);
            result.put(this.boundary.getBytes());
            result.put(HEADER_SEPARATOR);
            if (streamingPackage.contains("Content-Disposition")) {
                result.put(streamingPackage.get("Content-Disposition").toString().getBytes());
                result.put(HEADER_SEPARATOR);
            }
            if (streamingPackage.contains("Content-Type")) {
                result.put(streamingPackage.get("Content-Type").toString().getBytes());
                result.put(HEADER_SEPARATOR);
            }
            if (size == -1) {
                this.end = true;
                result.put(END);
            } else {
                result.put(streamingPackage.getBuffer(), 0, size);
            }
            resultSize = result.position();
        }
        return resultSize;
    }
}

