/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class JsonUtils {
    private static final JsonParser jsonParser = new JsonParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat(SystemProperties.get("hcjf.default.date.format")).create();
    public static final String DATE_FORMAT_ARG = "dateFormatArgument";
    public static final String ADAPTERS_ARG = "adaptersArgument";

    public static Object createObject(String json) {
        return JsonUtils.createObject(jsonParser.parse(json));
    }

    public static Map<String, Object> createBody(JsonObject jsonObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String fieldName : jsonObject.keySet()) {
            result.put(fieldName, JsonUtils.createObject(jsonObject.get(fieldName)));
        }
        return result;
    }

    public static List<Object> createList(JsonArray array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonElement currentElement : array) {
            result.add(JsonUtils.createObject(currentElement));
        }
        return result;
    }

    public static Object createObject(JsonElement element) {
        Object value;
        if (element instanceof JsonObject) {
            value = JsonUtils.createBody((JsonObject)element);
        } else if (element instanceof JsonArray) {
            value = JsonUtils.createList((JsonArray)element);
        } else if (element instanceof JsonPrimitive && ((JsonPrimitive)element).isString()) {
            value = Strings.deductInstance(element.getAsString());
            if (value != null && (Number.class.isAssignableFrom(value.getClass()) || Boolean.class.isAssignableFrom(value.getClass()))) {
                value = element.getAsString();
            }
        } else {
            value = element instanceof JsonNull ? null : Strings.deductInstance(element.getAsString());
        }
        return value;
    }

    public static JsonElement toJsonTree(Object object) {
        return gson.toJsonTree(object);
    }

    public static JsonElement toJsonTree(Object object, Map<String, Object> formatOptions) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        formatOptions.forEach((key, value) -> {
            switch (key) {
                case "dateFormatArgument": {
                    gsonBuilder.setPrettyPrinting().setDateFormat(value.toString());
                    break;
                }
                case "adaptersArgument": {
                    Map adapters = (Map)value;
                    adapters.forEach((type, adapter) -> gsonBuilder.setPrettyPrinting().registerTypeAdapter(type, adapter));
                    break;
                }
            }
        });
        return gsonBuilder.create().toJsonTree(object);
    }
}

