/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hcjf.utils.Introspection;

public class MathIntrospection {
    private static final MathInvokerFilter filter = new MathInvokerFilter();
    private static final Map<String, Integer> typeWeight = new HashMap<String, Integer>();

    public static <R> R invoke(String functionName, Object ... parameter) {
        try {
            return (R)Introspection.getInvokers(Math.class, filter).get(functionName).invoke(null, parameter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getMethodsSet() {
        return Introspection.getInvokers(Math.class, filter).keySet();
    }

    static {
        typeWeight.put("byte", 1);
        typeWeight.put("short", 2);
        typeWeight.put("int", 3);
        typeWeight.put("integer", 3);
        typeWeight.put("long", 4);
        typeWeight.put("float", 5);
        typeWeight.put("double", 6);
    }

    private static class MathInvokerFilter
    implements Introspection.InvokerFilter<MathInvoker> {
        private final Map<String, Integer> weightByMethodName = new HashMap<String, Integer>();

        @Override
        public Introspection.InvokerEntry<MathInvoker> filter(Method method) {
            Introspection.InvokerEntry<MathInvoker> result = null;
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && method.getDeclaringClass().equals(Math.class)) {
                Boolean create = false;
                Integer weight = this.calculateMethodWeight(method);
                if (this.weightByMethodName.containsKey(method.getName())) {
                    if (weight > this.weightByMethodName.get(method.getName())) {
                        create = true;
                    }
                } else {
                    create = true;
                }
                if (create.booleanValue()) {
                    result = new Introspection.InvokerEntry<MathInvoker>(method.getName(), new MathInvoker(method.getDeclaringClass(), method), new String[0]);
                    this.weightByMethodName.put(method.getName(), weight);
                }
            }
            return result;
        }

        private Integer calculateMethodWeight(Method method) {
            Integer result = 0;
            for (Class<?> dataType : method.getParameterTypes()) {
                Integer weight = typeWeight.get(dataType.getSimpleName().toLowerCase());
                if (weight == null) continue;
                result = result + weight;
            }
            return result;
        }
    }

    private static class MathInvoker
    extends Introspection.Invoker {
        public MathInvoker(Class implementationClass, Method method) {
            super(implementationClass, method);
        }
    }
}

