/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.hcjf.encoding.MimeType;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.properties.SystemProperties;

public abstract class Context {
    protected static final String START_CONTEXT = "^";
    protected static final String END_CONTEXT = ".*";
    protected static final String URI_FOLDER_SEPARATOR = "/";
    private final Pattern pattern;
    private final String contextRegex;
    private long timeout;

    public Context(String contextRegex) {
        this.pattern = Pattern.compile(contextRegex);
        this.contextRegex = contextRegex;
    }

    public final String getContextRegex() {
        return this.contextRegex;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public abstract HttpResponse onContext(HttpRequest var1);

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected HttpResponse onError(HttpRequest request, Throwable throwable) {
        return Context.createDefaultErrorResponse(throwable);
    }

    public static HttpResponse createDefaultErrorResponse(Throwable throwable) {
        byte[] body;
        HttpResponse response = new HttpResponse();
        response.setResponseCode(HttpResponseCode.INTERNAL_SERVER_ERROR);
        if (SystemProperties.getBoolean("hcjf.net.http.default.error.format.show.stack").booleanValue()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printer = new PrintStream(out);
            throwable.printStackTrace(printer);
            body = out.toByteArray();
        } else {
            body = throwable.getMessage().getBytes();
        }
        response.addHeader(new HttpHeader("Content-Length", Long.toString(body.length)));
        response.addHeader(new HttpHeader("Content-Type", MimeType.TEXT_PLAIN.toString()));
        response.setBody(body);
        return response;
    }

    public static HttpResponse addDefaultResponseHeaders(HttpResponse response, byte[] body) {
        response.setBody(body);
        response.addHeader(new HttpHeader("Connection", "Closed"));
        response.addHeader(new HttpHeader("Content-Type", MimeType.TEXT_PLAIN.toString()));
        response.addHeader(new HttpHeader("Content-Length", Integer.toString(body.length)));
        return response;
    }
}

