/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.proxy;

import java.util.ArrayList;
import java.util.List;
import org.hcjf.errors.Errors;
import org.hcjf.io.net.http.Context;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpServer;
import org.hcjf.io.net.http.proxy.HttpProxyRule;
import org.hcjf.io.net.http.proxy.ProxyTask;
import org.hcjf.properties.SystemProperties;

public class HttpProxy
extends HttpServer {
    private static final String DEFAULT_CONTEXT_REGEX = ".*";
    private final List<HttpProxyRule> rules = new ArrayList<HttpProxyRule>();
    private Context defaultContext = new Context(".*"){

        @Override
        public HttpResponse onContext(HttpRequest request) {
            HttpResponse response = null;
            for (HttpProxyRule rule : HttpProxy.this.rules) {
                if (!rule.evaluate(request)) continue;
                ProxyTask task = rule.getTask();
                response = task.execute(request);
                break;
            }
            return response;
        }
    };

    public HttpProxy(Integer port) {
        super(port);
        super.addContext(this.defaultContext);
    }

    public HttpProxy() {
        this(SystemProperties.getInteger("hcjf.net.http.default.server.port"));
    }

    public final void addRule(HttpProxyRule rule) {
        if (rule == null) {
            throw new NullPointerException(Errors.getMessage("org.hcjf.io.net.http.proxy@1", new Object[0]));
        }
        this.rules.add(rule);
    }

    @Override
    public final synchronized void addContext(Context context) {
        throw new UnsupportedOperationException(Errors.getMessage("org.hcjf.io.net.http.proxy@2", new Object[0]));
    }

    @Override
    protected final HttpServer.ContextMatcher findContext(String contextName) {
        return new HttpServer.ContextMatcher(this.defaultContext, null);
    }
}

