/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hcjf.bson.BsonArray;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonElement;
import org.hcjf.layers.query.Enlarged;
import org.hcjf.layers.query.Groupable;
import org.hcjf.layers.query.Joinable;
import org.hcjf.utils.Strings;
import org.hcjf.utils.bson.BsonParcelable;

public class JoinableMap
implements Joinable,
Groupable,
Enlarged,
BsonParcelable,
Map<String, Object> {
    private static final String RESOURCES_FIELD = "__resources__";
    private static final String MAP_INSTANCE_FIELD = "__map_instance__";
    private static final String RESOURCE_FIELD_PATTERN = "%s.%s";
    private final Set<String> resources = new TreeSet<String>();
    private final Map<String, Object> mapInstance;
    private final Map<String, Map<String, Object>> mapInstanceByResource;
    private Set<String> staticFields;
    private boolean purged = false;
    private Map<String, Object> staticFieldsMap;

    public JoinableMap() {
        this.mapInstance = new LinkedTreeMap();
        this.mapInstanceByResource = new LinkedHashMap<String, Map<String, Object>>();
        this.staticFields = new LinkedHashSet<String>();
        this.staticFieldsMap = new HashMap<String, Object>();
    }

    public JoinableMap(String resourceName) {
        this.resources.add(resourceName);
        this.mapInstance = new LinkedHashMap<String, Object>();
        this.mapInstanceByResource = new LinkedHashMap<String, Map<String, Object>>();
        this.mapInstanceByResource.put(resourceName, new HashMap());
    }

    public JoinableMap(Map<String, Object> mapInstance, String ... fields) {
        this.mapInstance = new LinkedHashMap<String, Object>();
        this.mapInstanceByResource = new LinkedHashMap<String, Map<String, Object>>();
        if (fields != null && fields.length > 0) {
            this.staticFields = new LinkedHashSet<String>();
            for (String field : fields) {
                this.staticFields.add(field);
            }
            this.staticFieldsMap = new HashMap<String, Object>();
        }
        for (String key : mapInstance.keySet()) {
            if (key.contains(".")) {
                this.resources.add(key.substring(0, key.lastIndexOf(".")));
            }
            this.put(key, mapInstance.get(key));
        }
    }

    @Override
    public BsonDocument toBson() {
        this.purge();
        BsonDocument bsonDocument = BsonParcelable.super.toBson();
        bsonDocument.put((BsonElement)BsonParcelable.super.toBson(MAP_INSTANCE_FIELD, this.mapInstance));
        bsonDocument.put((BsonElement)BsonParcelable.super.toBson(RESOURCES_FIELD, this.resources));
        return bsonDocument;
    }

    @Override
    public <P extends BsonParcelable> P populate(BsonDocument document) {
        BsonParcelable.super.populate(document);
        BsonDocument bsonDocument = document.get(MAP_INSTANCE_FIELD).getAsDocument();
        this.mapInstance.putAll(this.fromBson(String.class, Object.class, bsonDocument));
        BsonArray bsonArray = document.get(RESOURCES_FIELD).getAsArray();
        this.resources.addAll(this.fromBson(Object.class, bsonArray));
        return (P)this;
    }

    @Override
    public void purge() {
        if (this.staticFieldsMap != null) {
            this.mapInstance.clear();
            this.mapInstance.putAll(this.staticFieldsMap);
            this.staticFieldsMap = null;
            this.purged = true;
        }
    }

    @Override
    public Enlarged clone(String ... fields) {
        JoinableMap result = new JoinableMap(new HashMap<String, Object>(), fields);
        result.resources.addAll(this.resources);
        result.mapInstance.putAll(this.mapInstance);
        result.mapInstanceByResource.putAll(this.mapInstanceByResource);
        return result;
    }

    @Override
    public Enlarged cloneEmpty() {
        JoinableMap clone = new JoinableMap(this, new String[0]);
        clone.clear();
        return clone;
    }

    @Override
    public Object get(String fieldName) {
        Object result;
        String resourceName = this.getResourceNameForPath(fieldName);
        if (resourceName != null) {
            String fieldWithoutResource = this.getFieldWithoutResource(resourceName, fieldName);
            result = this.mapInstanceByResource.get(resourceName).get(fieldWithoutResource);
        } else {
            result = this.mapInstance.get(fieldName);
        }
        return result;
    }

    public void setResource(String resourceName) {
        if (!this.containsResource(resourceName)) {
            this.resources.add(resourceName);
            this.mapInstanceByResource.put(resourceName, new HashMap<String, Object>(this.mapInstance));
        }
    }

    @Override
    public Joinable join(String leftResource, String rightResource, Joinable joinable) {
        JoinableMap result;
        if (joinable == null) {
            throw new NullPointerException("Try to join with null joinable.");
        }
        if (!(joinable instanceof JoinableMap)) {
            throw new IllegalArgumentException("Only support JoinableMap instance.");
        }
        if (this.mapInstanceByResource.containsKey(leftResource)) {
            result = new JoinableMap();
            result.resources.addAll(this.resources);
            result.mapInstance.putAll(this.mapInstance);
            if (this.mapInstanceByResource.size() > 1) {
                result.mapInstanceByResource.putAll(this.mapInstanceByResource);
            } else {
                HashMap<String, Object> mapInstanceCopy = new HashMap<String, Object>(this.mapInstance);
                result.mapInstanceByResource.put(leftResource, mapInstanceCopy);
            }
        } else {
            result = new JoinableMap(leftResource);
            result.mapInstance.putAll(this.mapInstance);
            result.mapInstanceByResource.get(leftResource).putAll(this.mapInstance);
        }
        result.resources.add(rightResource);
        result.mapInstanceByResource.put(rightResource, new HashMap());
        result.mapInstanceByResource.get(rightResource).putAll((JoinableMap)joinable);
        for (Map.Entry<String, Object> entry : ((JoinableMap)joinable).entrySet()) {
            if (result.mapInstance.containsKey(entry.getKey())) {
                result.mapInstance.put(String.format(RESOURCE_FIELD_PATTERN, rightResource, entry.getKey()), entry.getValue());
                continue;
            }
            result.mapInstance.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean containsResource(String resourceName) {
        return this.mapInstanceByResource.containsKey(resourceName);
    }

    public Map<String, Object> getResourceModel(String resourceName) {
        return Collections.unmodifiableMap(this.mapInstanceByResource.get(resourceName) != null ? this.mapInstanceByResource.get(resourceName) : new HashMap());
    }

    public final String getResourceNameForPath(String path) {
        String result = null;
        if (path.contains(".")) {
            for (String resource : this.resources) {
                if (!path.startsWith(resource)) continue;
                String possibleResource = resource;
                if (result == null) {
                    result = possibleResource;
                    continue;
                }
                if (result.length() >= possibleResource.length()) continue;
                result = possibleResource;
            }
        }
        return result;
    }

    public final String getFieldWithoutResource(String resourceName, String path) {
        return resourceName == null || resourceName.isBlank() ? path : path.replace(resourceName + ".", "");
    }

    public Set<String> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    @Override
    public Groupable group(Groupable groupable) {
        for (String key : groupable.keySet()) {
            String resource = this.getResourceNameForPath(key);
            String keyWithoutResource = this.getFieldWithoutResource(resource, key);
            if (resource == null) {
                for (String candidateResource : this.getResources()) {
                    if (!this.getResourceModel(candidateResource).containsKey(key)) continue;
                    resource = candidateResource;
                    break;
                }
            }
            if (resource == null && this.resources != null && !this.resources.isEmpty()) {
                resource = (String)this.getResources().stream().findFirst().get();
            }
            if (this.containsKey(key)) {
                Object instanceValue = this.get(key);
                Object groupableValue = groupable.get(key);
                if (instanceValue instanceof GroupableSet) {
                    ((GroupableSet)instanceValue).add(groupableValue);
                    if (resource == null) continue;
                    ((GroupableSet)this.mapInstanceByResource.get(resource).get(keyWithoutResource)).add(groupableValue);
                    continue;
                }
                GroupableSet groupSet = new GroupableSet();
                groupSet.add(instanceValue);
                groupSet.add(groupableValue);
                this.put(key, (Object)groupSet);
                if (resource == null) continue;
                groupSet = new GroupableSet();
                groupSet.add(instanceValue);
                groupSet.add(groupableValue);
                this.mapInstanceByResource.get(resource).put(keyWithoutResource, groupSet);
                continue;
            }
            this.put(key, groupable.get(key));
            if (resource == null) continue;
            this.mapInstanceByResource.get(resource).put(keyWithoutResource, groupable.get(key));
        }
        return this;
    }

    public final String toString() {
        Strings.Builder builder = new Strings.Builder();
        builder.append("[");
        for (String key : this.mapInstance.keySet()) {
            builder.append(key).append("=");
            builder.append(this.mapInstance.get(key), ",", " ");
        }
        return super.toString();
    }

    @Override
    public int size() {
        return this.mapInstance.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapInstance.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = false;
        String fieldName = (String)key;
        String resourceName = this.getResourceNameForPath(fieldName);
        if (resourceName != null) {
            String fieldNameWithoutResource = this.getFieldWithoutResource(resourceName, fieldName);
            result = this.mapInstanceByResource.get(resourceName).containsKey(fieldNameWithoutResource);
        } else {
            result = this.mapInstance.containsKey(fieldName);
        }
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapInstance.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.get(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        String resourceName = this.getResourceNameForPath(key);
        if (resourceName != null) {
            String keyWithoutResource = this.getFieldWithoutResource(resourceName, key);
            this.mapInstanceByResource.get(resourceName).put(keyWithoutResource, value);
        }
        if (this.staticFields != null && this.staticFields.contains(key)) {
            this.staticFieldsMap.put(key, value);
        }
        return this.mapInstance.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.mapInstance.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.mapInstance.putAll(m);
    }

    @Override
    public void clear() {
        this.mapInstance.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.purged ? this.staticFields : this.mapInstance.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.mapInstance.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> result;
        if (this.purged) {
            result = new LinkedHashSet();
            for (String key : this.keySet()) {
                result.add(new JoinableEntry<String, Object>(key, this.get(key)));
            }
        } else {
            result = this.mapInstance.entrySet();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this.mapInstance.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mapInstance.hashCode();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.mapInstance.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.mapInstance.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this.mapInstance.replaceAll(function);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        return this.mapInstance.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.mapInstance.remove(key, value);
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        return this.mapInstance.replace(key, oldValue, newValue);
    }

    @Override
    public Object replace(String key, Object value) {
        return this.mapInstance.replace(key, value);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return this.mapInstance.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.mapInstance.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.mapInstance.compute(key, remappingFunction);
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.mapInstance.merge(key, value, remappingFunction);
    }

    public static final class JoinableEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public JoinableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }

    public static final class GroupableSet
    extends ArrayList<Object> {
    }
}

