/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.properties.SystemProperties;

public class CollectionQueryFunction
extends BaseQueryFunctionLayer {
    private static final String SIZE = "size";
    private static final String SIZE_DISTINCT = "sizeDistinct";
    private static final String GET = "get";
    private static final String CONTAINS = "contains";
    private static final String CONTAINS_ALL = "containsAll";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String CONTAINS_ALL_KEYS = "containsAllKeys";
    private static final String KEYS = "keys";
    private static final String SORT = "sort";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String SKIP = "skip";
    private static final String LIMIT = "limit";

    public CollectionQueryFunction() {
        super(SystemProperties.get("hcjf.query.function.collection.name"));
        this.addFunctionName(SIZE);
        this.addFunctionName(SIZE_DISTINCT);
        this.addFunctionName(GET);
        this.addFunctionName(CONTAINS);
        this.addFunctionName(CONTAINS_ALL);
        this.addFunctionName(CONTAINS_KEY);
        this.addFunctionName(CONTAINS_ALL_KEYS);
        this.addFunctionName(KEYS);
        this.addFunctionName(SORT);
        this.addFunctionName(FIRST);
        this.addFunctionName(LAST);
        this.addFunctionName(SKIP);
        this.addFunctionName(LIMIT);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result = null;
        switch (functionName) {
            case "size": {
                if (this.getParameter(0, parameters) == null) {
                    result = 0;
                    break;
                }
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)parameters[0]).size();
                    break;
                }
                if (this.getParameter(0, parameters) instanceof Map) {
                    result = ((Map)parameters[0]).size();
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray()) {
                    result = Array.getLength(parameters[0]);
                    break;
                }
                result = 1;
                break;
            }
            case "sizeDistinct": {
                if (this.getParameter(0, parameters) == null) {
                    result = 0;
                    break;
                }
                if (this.getParameter(0, parameters) instanceof Collection) {
                    HashSet hashSet = new HashSet((Collection)parameters[0]);
                    result = hashSet.size();
                    break;
                }
                if (this.getParameter(0, parameters) instanceof Map) {
                    result = ((Map)parameters[0]).size();
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray()) {
                    HashSet<Object> hashSet = new HashSet<Object>(Collections.singletonList(parameters[0]));
                    result = hashSet.size();
                    break;
                }
                result = 1;
                break;
            }
            case "get": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = Array.get(((Collection)parameters[0]).toArray(), ((Number)parameters[1]).intValue());
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray()) {
                    result = Array.get(parameters[0], ((Number)parameters[1]).intValue());
                    break;
                }
                if (!(this.getParameter(0, parameters) instanceof Map)) break;
                result = ((Map)parameters[0]).get(parameters[1]);
                break;
            }
            case "contains": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)this.getParameter(0, parameters)).contains(this.getParameter(1, parameters));
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray()) {
                    result = Arrays.asList((Object[])this.getParameter(0, parameters)).contains(this.getParameter(1, parameters));
                    break;
                }
                throw new HCJFRuntimeException("Contains functions is only for collections and arrays", new Object[0]);
            }
            case "containsAll": {
                List<Object> secondCollection;
                List<Object> firstCollection;
                if (this.getParameter(0, parameters) instanceof Collection) {
                    firstCollection = (List<Object>)this.getParameter(0, parameters);
                } else if (this.getParameter(0, parameters).getClass().isArray()) {
                    firstCollection = Arrays.asList((Object[])this.getParameter(0, parameters));
                } else {
                    throw new HCJFRuntimeException("The first parameter for contains all function can only be a collection or an array", new Object[0]);
                }
                if (this.getParameter(1, parameters) instanceof Collection) {
                    secondCollection = (List<Object>)this.getParameter(1, parameters);
                } else if (this.getParameter(1, parameters).getClass().isArray()) {
                    secondCollection = Arrays.asList((Object[])this.getParameter(1, parameters));
                } else {
                    throw new HCJFRuntimeException("The second parameter for contains all function can only be a collection or an array", new Object[0]);
                }
                result = firstCollection.containsAll(secondCollection);
                break;
            }
            case "containsKey": {
                if (this.getParameter(0, parameters) instanceof Map) {
                    result = ((Map)this.getParameter(0, parameters)).containsKey(this.getParameter(1, parameters));
                    break;
                }
                throw new HCJFRuntimeException("Contains key function is only for maps", new Object[0]);
            }
            case "containsAllKeys": {
                List<Object> collection;
                if (!(this.getParameter(0, parameters) instanceof Map)) {
                    throw new HCJFRuntimeException("The first parameter for contains all keys function can only be a map", new Object[0]);
                }
                Map map = (Map)this.getParameter(0, parameters);
                if (this.getParameter(1, parameters) instanceof Collection) {
                    collection = (List<Object>)this.getParameter(1, parameters);
                } else if (parameters[1].getClass().isArray()) {
                    collection = Arrays.asList((Object[])this.getParameter(1, parameters));
                } else {
                    throw new HCJFRuntimeException("The second parameter for contains all keys function can only be a collection or an array", new Object[0]);
                }
                result = map.keySet().containsAll(collection);
                break;
            }
            case "keys": {
                if (!(this.getParameter(0, parameters) instanceof Map)) {
                    throw new HCJFRuntimeException("The first parameter for 'keys' function can only be a map", new Object[0]);
                }
                Map map = (Map)this.getParameter(0, parameters);
                result = map.keySet();
                break;
            }
            case "sort": {
                TreeSet set = new TreeSet((comparable1, comparable2) -> {
                    int compareResult = comparable1 == null ^ comparable2 == null ? (comparable1 == null ? -1 : 1) : (comparable1 == null && comparable2 == null ? 0 : (comparable1 instanceof Comparable && comparable2 instanceof Comparable ? ((Comparable)comparable1).compareTo(comparable2) : comparable1.hashCode() - comparable2.hashCode()));
                    return compareResult;
                });
                if (this.getParameter(0, parameters) instanceof Collection) {
                    set.addAll((Collection)this.getParameter(0, parameters));
                } else {
                    set.add(this.getParameter(0, parameters));
                }
                result = set;
                break;
            }
            case "first": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)this.getParameter(0, parameters)).stream().findFirst().orElse(null);
                    break;
                }
                result = this.getParameter(0, parameters);
                break;
            }
            case "last": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    Collection collection = (Collection)this.getParameter(0, parameters);
                    if (collection.size() > 0) {
                        result = ((Collection)this.getParameter(0, parameters)).stream().skip(collection.size() - 1).findFirst().orElse(null);
                        break;
                    }
                    result = null;
                    break;
                }
                result = this.getParameter(0, parameters);
                break;
            }
            case "skip": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)this.getParameter(0, parameters)).stream().skip(((Number)this.getParameter(1, parameters)).longValue()).collect(Collectors.toList());
                    break;
                }
                result = new ArrayList();
                break;
            }
            case "limit": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)this.getParameter(0, parameters)).stream().limit(((Number)this.getParameter(1, parameters)).longValue()).collect(Collectors.toList());
                    break;
                }
                ArrayList list = new ArrayList();
                list.add(this.getParameter(0, parameters));
                result = list;
            }
        }
        return result;
    }
}

