/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.utils.GeoUtils;
import org.hcjf.utils.JsonUtils;

public class GeoQueryFunctionLayer
extends BaseQueryFunctionLayer
implements QueryFunctionLayerInterface {
    private static final String NAME = "geo";

    public GeoQueryFunctionLayer() {
        super(NAME);
        this.addFunctionName("geoNew");
        this.addFunctionName("geoAsBinary");
        this.addFunctionName("geoAsJson");
        this.addFunctionName("geoAsGeoJson");
        this.addFunctionName("geoAsText");
        this.addFunctionName("geoBoundary");
        this.addFunctionName("geoBuffer");
        this.addFunctionName("geoCentroid");
        this.addFunctionName("geoContains");
        this.addFunctionName("geoConvertToMulti");
        this.addFunctionName("geoCrosses");
        this.addFunctionName("geoDifference");
        this.addFunctionName("geoDisjoint");
        this.addFunctionName("geoDistance");
        this.addFunctionName("geodesicDistance");
        this.addFunctionName("geoEnvelope");
        this.addFunctionName("geoEquals");
        this.addFunctionName("geoType");
        this.addFunctionName("geoIntersection");
        this.addFunctionName("geoIntersects");
        this.addFunctionName("geoIsEmpty");
        this.addFunctionName("geoIsMeasured");
        this.addFunctionName("geoIsSimple");
        this.addFunctionName("geoIsSimpleRelaxed");
        this.addFunctionName("geoMakeSimple");
        this.addFunctionName("geoMakeSimpleRelaxed");
        this.addFunctionName("geoOverlaps");
        this.addFunctionName("geoReduceFromMulti");
        this.addFunctionName("geoSrid");
        this.addFunctionName("geoSymDifference");
        this.addFunctionName("geoTouches");
        this.addFunctionName("geoUnion");
        this.addFunctionName("geoWithin");
        this.addFunctionName("geoProject");
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result;
        OGCGeometry geometry = GeoUtils.createGeometry(parameters[0]);
        switch (functionName) {
            case "geoNew": {
                result = JsonUtils.createObject(geometry.asGeoJson());
                break;
            }
            case "geoAsBinary": {
                result = geometry.asBinary();
                break;
            }
            case "geoAsGeoJson": {
                result = geometry.asGeoJson();
                break;
            }
            case "geoAsJson": {
                result = geometry.asJson();
                break;
            }
            case "geoAsText": {
                result = geometry.asText();
                break;
            }
            case "geoBoundary": {
                result = geometry.boundary();
                break;
            }
            case "geoBuffer": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Double.class);
                result = geometry.buffer(((Double)parameters[1]).doubleValue());
                break;
            }
            case "geoCentroid": {
                result = geometry.centroid();
                break;
            }
            case "geoContains": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.contains(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoConvertToMulti": {
                result = geometry.convertToMulti();
                break;
            }
            case "geoCrosses": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.crosses(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoDifference": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.difference(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoDisjoint": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.disjoint(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoDistance": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.distance(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoEnvelope": {
                result = geometry.envelope();
                break;
            }
            case "geoEquals": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.Equals(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoIntersection": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.intersection(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoIntersects": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.intersects(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoIsEmpty": {
                result = geometry.isEmpty();
                break;
            }
            case "geoIsMeasured": {
                result = geometry.isMeasured();
                break;
            }
            case "geoIsSimple": {
                result = geometry.isSimple();
                break;
            }
            case "geoIsSimpleRelaxed": {
                result = geometry.isSimpleRelaxed();
                break;
            }
            case "geoMakeSimple": {
                result = geometry.makeSimple();
                break;
            }
            case "geoMakeSimpleRelaxed": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Boolean.class);
                result = geometry.makeSimpleRelaxed(((Boolean)parameters[1]).booleanValue());
                break;
            }
            case "geoOverlaps": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.overlaps(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoReduceFromMulti": {
                result = geometry.reduceFromMulti();
                break;
            }
            case "geoSrid": {
                result = geometry.SRID();
                break;
            }
            case "geoSymDifference": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.symDifference(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoTouches": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.touches(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoType": {
                result = geometry.geometryType();
                break;
            }
            case "geoUnion": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.union(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geoWithin": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = geometry.within(GeoUtils.createGeometry(parameters[1]));
                break;
            }
            case "geodesicDistance": {
                this.checkNumberAndType(functionName, parameters, 2, Object.class, Object.class);
                result = GeometryEngine.geodesicDistanceOnWGS84((Point)((Point)geometry.centroid().getEsriGeometry()), (Point)((Point)GeoUtils.createGeometry(parameters[1]).centroid().getEsriGeometry()));
                break;
            }
            default: {
                throw new HCJFRuntimeException("Unrecognized get function: %s", functionName);
            }
        }
        if (result instanceof OGCGeometry) {
            result = JsonUtils.createObject(((OGCGeometry)result).asGeoJson());
        }
        return result;
    }

    private static final class Functions {
        private static final String GEO_NEW = "geoNew";
        private static final String GEO_AS_JSON = "geoAsJson";
        private static final String GEO_AS_GEO_JSON = "geoAsGeoJson";
        private static final String GEO_AS_BINARY = "geoAsBinary";
        private static final String GEO_AS_TEXT = "geoAsText";
        private static final String GEO_BOUNDARY = "geoBoundary";
        private static final String GEO_BUFFER = "geoBuffer";
        private static final String GEO_CENTROID = "geoCentroid";
        private static final String GEO_CONTAINS = "geoContains";
        private static final String GEO_CONVERT_TO_MULTI = "geoConvertToMulti";
        private static final String GEO_CROSSES = "geoCrosses";
        private static final String GEO_DIFFERENCE = "geoDifference";
        private static final String GEO_DISJOINT = "geoDisjoint";
        private static final String GEO_DISTANCE = "geoDistance";
        private static final String GEODESIC_DISTANCE = "geodesicDistance";
        private static final String GEO_ENVELOPE = "geoEnvelope";
        private static final String GEO_EQUALS = "geoEquals";
        private static final String GEO_TYPE = "geoType";
        private static final String GEO_INTERSECTION = "geoIntersection";
        private static final String GEO_INTERSECTS = "geoIntersects";
        private static final String GEO_IS_EMPTY = "geoIsEmpty";
        private static final String GEO_IS_MEASURED = "geoIsMeasured";
        private static final String GEO_IS_SIMPLE = "geoIsSimple";
        private static final String GEO_IS_SIMPLE_RELAXED = "geoIsSimpleRelaxed";
        private static final String GEO_MAKE_SIMPLE = "geoMakeSimple";
        private static final String GEO_MAKE_SIMPLE_RELAXED = "geoMakeSimpleRelaxed";
        private static final String GEO_OVERLAPS = "geoOverlaps";
        private static final String GEO_REDUCE_FROM_MULTI = "geoReduceFromMulti";
        private static final String GEO_SRID = "geoSrid";
        private static final String GEO_SYM_DIFFERENCE = "geoSymDifference";
        private static final String GEO_TOUCHES = "geoTouches";
        private static final String GEO_UNION = "geoUnion";
        private static final String GEO_WITHIN = "geoWithin";
        private static final String GEO_PROJECT = "geoProject";

        private Functions() {
        }
    }
}

