/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.hcjf.cloud.CloudConsumer;
import org.hcjf.cloud.CloudServiceImpl;
import org.hcjf.cloud.cache.CloudCache;
import org.hcjf.cloud.cache.CloudCacheStrategy;
import org.hcjf.cloud.counter.Counter;
import org.hcjf.cloud.timer.CloudTimerTask;
import org.hcjf.events.DistributedEvent;
import org.hcjf.layers.LayerInterface;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;

public final class Cloud
extends Service<CloudConsumer> {
    private static Cloud instance;
    private final CloudServiceImpl impl;
    private final Timer timer;

    private Cloud() {
        super(SystemProperties.get("hcjf.cloud.name"), SystemProperties.getInteger("hcjf.cloud.priority"));
        String implClassName = SystemProperties.get("hcjf.cloud.impl");
        if (implClassName == null) {
            throw new IllegalArgumentException("Implementation cloud class is null, see the system property 'hcjf.cloud.impl'");
        }
        try {
            Class<?> implClass = Class.forName(implClassName);
            this.impl = (CloudServiceImpl)implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to create cloud implementation", ex);
        }
        this.timer = new Timer();
    }

    private static synchronized Cloud getInstance() {
        if (instance == null) {
            instance = new Cloud();
        }
        return instance;
    }

    public static <K, V> Map<K, V> getMap(String mapName) {
        return Cloud.getInstance().impl.getMap(mapName);
    }

    public static <V> Queue<V> getQueue(String queueName) {
        return Cloud.getInstance().impl.getQueue(queueName);
    }

    public static <V> Set<V> getSet(String setName) {
        return Cloud.getInstance().impl.getSet(setName);
    }

    public static Counter getCounter(String counterName) {
        return Cloud.getInstance().impl.getCounter(counterName);
    }

    public static void lock(String resourceName) throws InterruptedException {
        Cloud.getInstance().impl.lock(resourceName);
    }

    public static void unlock(String resourceName) throws InterruptedException {
        Cloud.getInstance().impl.unlock(resourceName);
    }

    public static Lock getLock(String lockName) {
        return Cloud.getInstance().impl.getLock(lockName);
    }

    public static Condition getCondition(String conditionName, Lock lock) {
        return Cloud.getInstance().impl.getCondition(conditionName, lock);
    }

    public static void createCache(String cacheName, Set<CloudCacheStrategy> strategies) {
        Cloud.getInstance().impl.createCache(cacheName, strategies);
    }

    public static CloudCache getCache(String cacheName) {
        return Cloud.getInstance().impl.getCache(cacheName);
    }

    public static void dispatchEvent(DistributedEvent event) {
        Cloud.getInstance().impl.dispatchEvent(event);
    }

    public static void createTimerTask(CloudTimerTask timerTask) {
        Cloud.getInstance().fork(timerTask);
    }

    public static void publishDistributedLayer(Class<? extends LayerInterface> layerClass, String implName, String regex) {
        Cloud.getInstance().impl.publishDistributedLayer(layerClass, implName, regex);
    }

    public static void publishPlugin(byte[] jarFile) {
        Cloud.getInstance().impl.publishPlugin(jarFile);
    }

    public static boolean isLayerPublished(Class<? extends LayerInterface> layerClass, String implName) {
        return Cloud.getInstance().impl.isLayerPublished(layerClass, implName);
    }

    public static String getRegexFromDistributedLayer(Class<? extends LayerInterface> layerClass, String implName) {
        return Cloud.getInstance().impl.getRegexFromDistributedLayer(layerClass, implName);
    }

    public static <O> O layerInvoke(Class<? extends LayerInterface> layerClass, String implName, Method method, Object ... parameters) {
        return Cloud.getInstance().impl.layerInvoke(layerClass, implName, method, parameters);
    }

    public static void publishMe() {
        Cloud.getInstance().impl.publishMe();
    }

    public static void forkWorker(Map<String, Object> workerConfig) {
        Cloud.getInstance().impl.forkWorker(workerConfig);
    }

    @Override
    protected void shutdown(Service.ShutdownStage stage) {
        this.impl.shutdown();
    }

    @Override
    public void registerConsumer(CloudConsumer consumer) {
    }

    @Override
    public void unregisterConsumer(CloudConsumer consumer) {
    }
}

