/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.cache;

import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.hcjf.cloud.Cloud;
import org.hcjf.cloud.cache.CloudCache;
import org.hcjf.cloud.cache.CloudCacheStrategy;
import org.hcjf.properties.SystemProperties;

public class SizeStrategy
implements CloudCacheStrategy {
    private final Integer size;
    private Queue<Object> ids;

    public SizeStrategy(Integer size) {
        this.size = size;
    }

    @Override
    public void init(CloudCache cacheInstance) {
        this.ids = Cloud.getQueue(SystemProperties.get("hcjf.cloud.cache.size.strategy.map.suffix.name") + cacheInstance.getCacheName());
    }

    @Override
    public void onRemove(Object id) {
        this.ids.remove(id);
    }

    @Override
    public void onAdd(Object id, Object value) {
        if (this.ids.contains(id)) {
            this.ids.remove(id);
        }
        this.ids.offer(value);
    }

    @Override
    public Set<Object> applyStrategy() {
        Set result = null;
        if (this.ids.size() > this.size) {
            result = this.ids.stream().skip(this.size.intValue()).collect(Collectors.toSet());
        }
        return result;
    }
}

