/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.hcjf.errors.Errors;
import org.hcjf.io.fs.FileSystemWatcherConsumer;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;

public final class FileSystemWatcherService
extends Service<FileSystemWatcherConsumer> {
    private static final FileSystemWatcherService instance = new FileSystemWatcherService();
    private WatchService watcher;
    private final Map<Path, WatchKey> keys = new HashMap<Path, WatchKey>();
    private final Map<WatchKey, List<FileSystemWatcherConsumer>> consumers = new HashMap<WatchKey, List<FileSystemWatcherConsumer>>();
    private Future future;

    private FileSystemWatcherService() {
        super(SystemProperties.get("hcjf.file.system.service.name"), SystemProperties.getInteger("hcjf.file.system.service.priority"));
        if (System.getProperties().containsKey("hcjf.default.properties.file.path")) {
            this.registerConsumer(new SystemPropertiesConsumer());
        }
    }

    public static final FileSystemWatcherService getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(FileSystemWatcherConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException(Errors.getMessage("org.hcjf.io.fs@1", new Object[0]));
        }
        FileSystemWatcherService fileSystemWatcherService = this;
        synchronized (fileSystemWatcherService) {
            while (this.watcher == null) {
                try {
                    Log.d(SystemProperties.get("hcjf.file.system.log.tag"), "Waiting file system watcher init", new Object[0]);
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            fileSystemWatcherService = this;
            synchronized (fileSystemWatcherService) {
                WatchKey key;
                Path absolutePath = consumer.getBasePath().toAbsolutePath();
                if (!this.keys.containsKey(absolutePath)) {
                    this.keys.put(absolutePath, consumer.getBasePath().register(this.watcher, consumer.getEventKinds()));
                }
                if (!this.consumers.containsKey(key = this.keys.get(absolutePath))) {
                    this.consumers.put(key, new ArrayList());
                }
                this.consumers.get(key).add(consumer);
                Log.i(SystemProperties.get("hcjf.file.system.log.tag"), "File system watcher registered %s", absolutePath);
            }
        }
        catch (IOException ex) {
            Log.d(SystemProperties.get("hcjf.file.system.log.tag"), "Unable to register file system watcher consumer, '$1'", ex, consumer.getBasePath());
        }
    }

    @Override
    public void unregisterConsumer(FileSystemWatcherConsumer consumer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            FileSystemWatcherService fileSystemWatcherService = this;
            synchronized (fileSystemWatcherService) {
                this.notifyAll();
            }
        }
        catch (Throwable ex) {
            Log.d(SystemProperties.get("hcjf.file.system.log.tag"), "File System Watcher init fail", ex, new Object[0]);
        }
        this.future = this.fork(new FileSystemWatcherTask());
    }

    @Override
    protected void shutdown(Service.ShutdownStage stage) {
        this.future.cancel(true);
    }

    private class SystemPropertiesConsumer
    extends FileSystemWatcherConsumer {
        public final boolean xmlFile;

        public SystemPropertiesConsumer() {
            super(Paths.get(SystemProperties.get("hcjf.default.properties.file.path"), new String[0]), StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.xmlFile = SystemProperties.getBoolean("hcjf.default.properties.file.xml");
        }

        @Override
        protected void create(WatchEvent<Path> event) {
            this.load(this.getPath().toFile());
        }

        @Override
        protected void update(WatchEvent<Path> event) {
            this.load(this.getPath().toFile());
        }

        private void load(File file) {
            try {
                if (this.xmlFile) {
                    System.getProperties().loadFromXML(new FileInputStream(file));
                } else {
                    System.getProperties().load(new FileInputStream(file));
                }
            }
            catch (IOException ex) {
                Log.w(SystemProperties.get("hcjf.file.system.log.tag"), "Unable to load properties file", ex, new Object[0]);
            }
            Log.d(SystemProperties.get("hcjf.file.system.log.tag"), "Properties reloaded", new Object[0]);
        }
    }

    private class FileSystemWatcherTask
    implements Runnable {
        private FileSystemWatcherTask() {
        }

        @Override
        public void run() {
            if (FileSystemWatcherService.this.watcher != null) {
                while (!Thread.currentThread().isInterrupted()) {
                    WatchKey key;
                    try {
                        key = FileSystemWatcherService.this.watcher.take();
                    }
                    catch (InterruptedException x) {
                        break;
                    }
                    for (FileSystemWatcherConsumer consumer : FileSystemWatcherService.this.consumers.get(key)) {
                        key.pollEvents().stream().filter(event -> {
                            boolean result = false;
                            try {
                                result = event.count() <= 1 && (consumer.getFileName() == null || Files.isSameFile(consumer.getPath(), consumer.getBasePath().resolve((Path)event.context())));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return result;
                        }).forEach(event -> FileSystemWatcherService.this.fork(() -> {
                            FileSystemWatcherConsumer fileSystemWatcherConsumer = consumer;
                            synchronized (fileSystemWatcherConsumer) {
                                WatchEvent.Kind kind = event.kind();
                                if (kind == StandardWatchEventKinds.OVERFLOW) {
                                    consumer.overflow((WatchEvent<Path>)event);
                                } else if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                    consumer.create((WatchEvent<Path>)event);
                                } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                    consumer.update((WatchEvent<Path>)event);
                                } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                    consumer.delete((WatchEvent<Path>)event);
                                }
                            }
                        }));
                        boolean valid = key.reset();
                        if (valid) continue;
                        Log.d(SystemProperties.get("hcjf.file.system.log.tag"), "Inaccessible path '$1', consumer unregistered", consumer.getBasePath());
                    }
                }
                try {
                    FileSystemWatcherService.this.watcher.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.d(SystemProperties.get("hcjf.file.system.log.tag"), "File system watcher service stopped", new Object[0]);
            }
        }
    }
}

