/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseQueryAggregateFunctionLayer;
import org.hcjf.layers.query.functions.NumberSetFunction;
import org.hcjf.properties.SystemProperties;

public class MeanAggregateFunctionLayer
extends BaseQueryAggregateFunctionLayer
implements NumberSetFunction {
    public static final String NAME = "aggregateMean";
    public static final String ARITHMETIC = "arithmetic";
    public static final String GEOMETRIC = "geometric";
    public static final String HARMONIC = "harmonic";

    public MeanAggregateFunctionLayer() {
        super(NAME);
    }

    @Override
    public Collection evaluate(String alias, Collection resultSet, Object ... parameters) {
        Collection result = resultSet;
        if (parameters.length >= 1) {
            try {
                Integer accumulatedValue = 0;
                String meanKind = parameters.length == 1 ? ARITHMETIC : (String)this.getParameter(1, parameters);
                for (Object row : resultSet) {
                    Number[] functionResult;
                    switch (meanKind) {
                        case "geometric": {
                            functionResult = this.accumulateFunction(accumulatedValue, new Object[]{this.resolveValue(row, parameters[0])}, (A, V) -> A.multiply((BigDecimal)V));
                            functionResult[1] = Math.pow(functionResult[1].doubleValue(), 1.0 / functionResult[0].doubleValue());
                            break;
                        }
                        case "harmonic": {
                            functionResult = this.accumulateFunction(accumulatedValue, new Object[]{this.resolveValue(row, parameters[0])}, (A, V) -> A.add(new BigDecimal(1).divide((BigDecimal)V, (int)SystemProperties.getInteger("hcjf.query.function.big.decimal.divide.scale"), RoundingMode.HALF_EVEN)));
                            functionResult[1] = functionResult[0].doubleValue() / functionResult[1].doubleValue();
                            break;
                        }
                        default: {
                            functionResult = this.accumulateFunction(accumulatedValue, new Object[]{this.resolveValue(row, parameters[0])}, (A, V) -> A.add((BigDecimal)V));
                            functionResult[1] = functionResult[1].doubleValue() / functionResult[0].doubleValue();
                        }
                    }
                    ((Map)row).put(alias, functionResult[1]);
                }
            }
            catch (Exception ex) {
                throw new HCJFRuntimeException("Mean aggregate function fail", (Throwable)ex, new Object[0]);
            }
        } else {
            throw new HCJFRuntimeException("Mean aggregate function need at leas two parameter", new Object[0]);
        }
        return result;
    }
}

