/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.serializer;

import java.util.Collection;
import java.util.Date;
import org.hcjf.layers.Layer;
import org.hcjf.layers.query.Join;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.evaluators.And;
import org.hcjf.layers.query.evaluators.BaseEvaluator;
import org.hcjf.layers.query.evaluators.BooleanEvaluator;
import org.hcjf.layers.query.evaluators.Distinct;
import org.hcjf.layers.query.evaluators.Equals;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.evaluators.EvaluatorCollection;
import org.hcjf.layers.query.evaluators.FieldEvaluator;
import org.hcjf.layers.query.evaluators.GreaterThan;
import org.hcjf.layers.query.evaluators.GreaterThanOrEqual;
import org.hcjf.layers.query.evaluators.In;
import org.hcjf.layers.query.evaluators.Like;
import org.hcjf.layers.query.evaluators.NotIn;
import org.hcjf.layers.query.evaluators.Or;
import org.hcjf.layers.query.evaluators.SmallerThan;
import org.hcjf.layers.query.evaluators.SmallerThanOrEqual;
import org.hcjf.layers.query.model.QueryOrderParameter;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.layers.query.serializer.QuerySerializer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class SQLSerializer
extends Layer
implements QuerySerializer {
    private static final String NAME = "SQL";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    public String serialize(Query query) {
        Strings.Builder resultBuilder = new Strings.Builder();
        resultBuilder.append(SystemProperties.get("hcjf.query.select.reserved.word"));
        resultBuilder.append(" ");
        if (query.returnAll()) {
            resultBuilder.append(SystemProperties.get("hcjf.query.return.all.reserved.word"));
            SystemProperties.get("hcjf.query.argument.separator");
            resultBuilder.append(" ");
        }
        for (QueryReturnParameter field : query.getReturnParameters()) {
            resultBuilder.append(field);
            if (field.getAlias() != null) {
                resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.as.reserved.word"));
                resultBuilder.append(" ").append(field.getAlias());
            }
            resultBuilder.append("", SystemProperties.get("hcjf.query.argument.separator"));
        }
        resultBuilder.cleanBuffer();
        resultBuilder.append(" ");
        resultBuilder.append(SystemProperties.get("hcjf.query.from.reserved.word"));
        resultBuilder.append(" ");
        resultBuilder.append(query.getResource().toString());
        resultBuilder.append(" ");
        for (Join join : query.getJoins()) {
            if (join.getType() != Join.JoinType.JOIN) {
                resultBuilder.append((Object)join.getType());
                resultBuilder.append(" ");
            }
            resultBuilder.append(SystemProperties.get("hcjf.query.join.reserved.word")).append(" ");
            resultBuilder.append(join.getResource().toString()).append(" ");
            resultBuilder.append(SystemProperties.get("hcjf.query.on.reserved.word")).append(" ");
            if (join.getEvaluators().size() <= 0) continue;
            this.toStringEvaluatorCollection(resultBuilder, join);
        }
        if (query.getEvaluators().size() > 0) {
            resultBuilder.append(SystemProperties.get("hcjf.query.where.reserved.word")).append(" ");
            this.toStringEvaluatorCollection(resultBuilder, query);
        }
        if (query.getGroupParameters().size() > 0) {
            resultBuilder.append(SystemProperties.get("hcjf.query.group.by.reserved.word")).append(" ");
            for (QueryReturnParameter groupParameter : query.getGroupParameters()) {
                resultBuilder.append(groupParameter, SystemProperties.get("hcjf.query.argument.separator"));
            }
            resultBuilder.cleanBuffer();
            resultBuilder.append(" ");
        }
        if (query.getOrderParameters().size() > 0) {
            resultBuilder.append(SystemProperties.get("hcjf.query.order.by.reserved.word")).append(" ");
            for (QueryOrderParameter orderField : query.getOrderParameters()) {
                resultBuilder.append(orderField);
                if (orderField.isDesc()) {
                    resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.desc.reserved.word"));
                }
                resultBuilder.append("", SystemProperties.get("hcjf.query.argument.separator"));
            }
            resultBuilder.cleanBuffer();
        }
        if (query.getStart() != null) {
            resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.start.reserved.word"));
            resultBuilder.append(" ").append(query.getStart());
        }
        if (query.getUnderlyingStart() != null) {
            if (query.getStart() == null) {
                resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.start.reserved.word")).append(" ");
            }
            resultBuilder.append(",").append(query.getUnderlyingStart());
        }
        if (query.getLimit() != null) {
            resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.limit.reserved.word"));
            resultBuilder.append(" ").append(query.getLimit());
        }
        if (query.getUnderlyingLimit() != null) {
            if (query.getLimit() == null) {
                resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.limit.reserved.word")).append(" ");
            }
            resultBuilder.append(",").append(query.getUnderlyingLimit());
        }
        for (Queryable queryable : query.getUnions()) {
            resultBuilder.append(" ");
            resultBuilder.append(SystemProperties.get("hcjf.query.union.reserved.word"));
            resultBuilder.append(" ");
            resultBuilder.append(queryable.toString());
        }
        return resultBuilder.toString();
    }

    private void toStringEvaluatorCollection(Strings.Builder result, EvaluatorCollection collection) {
        Object separator = "";
        String separatorValue = collection instanceof Or ? SystemProperties.get("hcjf.query.or.reserved.word") : SystemProperties.get("hcjf.query.and.reserved.word");
        for (Evaluator evaluator : collection.getEvaluators()) {
            if (evaluator instanceof Or) {
                if (!((String)separator).isEmpty()) {
                    result.append(SystemProperties.get("hcjf.query.or.reserved.word"));
                }
                result.append(" ");
                if (((Or)evaluator).getEvaluators().size() == 1) {
                    this.toStringEvaluatorCollection(result, (Or)evaluator);
                } else {
                    result.append("(");
                    this.toStringEvaluatorCollection(result, (Or)evaluator);
                    result.append(")");
                }
                result.append(" ");
            } else if (evaluator instanceof And) {
                if (!((String)separator).isEmpty()) {
                    result.append(SystemProperties.get("hcjf.query.and.reserved.word"));
                }
                result.append(" ");
                if (collection instanceof Query) {
                    this.toStringEvaluatorCollection(result, (And)evaluator);
                } else if (((And)evaluator).getEvaluators().size() == 1) {
                    this.toStringEvaluatorCollection(result, (And)evaluator);
                } else {
                    result.append("(");
                    this.toStringEvaluatorCollection(result, (And)evaluator);
                    result.append(")");
                }
                result.append(" ");
            } else if (evaluator instanceof BooleanEvaluator) {
                result.append((String)separator);
                BooleanEvaluator booleanEvaluator = (BooleanEvaluator)evaluator;
                if (booleanEvaluator.isTrueForced()) {
                    result.append(Boolean.TRUE.toString());
                } else {
                    result = SQLSerializer.toStringFieldEvaluatorValue(booleanEvaluator.getValue(), booleanEvaluator.getClass(), result);
                }
                result.append(" ");
            } else if (evaluator instanceof FieldEvaluator) {
                result.append((String)separator);
                FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
                if (fieldEvaluator.isTrueForced()) {
                    result.append(Boolean.TRUE.toString());
                } else {
                    if (fieldEvaluator.getLeftValue() == null) {
                        result.append(SystemProperties.get("hcjf.query.null.reserved.word"));
                    } else {
                        result = SQLSerializer.toStringFieldEvaluatorValue(fieldEvaluator.getLeftValue(), fieldEvaluator.getLeftValue().getClass(), result);
                    }
                    result.append(" ");
                    if (fieldEvaluator instanceof Distinct) {
                        result.append(SystemProperties.get("hcjf.query.distinct.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof Equals) {
                        result.append(SystemProperties.get("hcjf.query.equals.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof GreaterThanOrEqual) {
                        result.append(SystemProperties.get("hcjf.query.greater.than.or.equals.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof GreaterThan) {
                        result.append(SystemProperties.get("hcjf.query.greater.than.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof NotIn) {
                        result.append(SystemProperties.get("hcjf.query.not.in.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof In) {
                        result.append(SystemProperties.get("hcjf.query.in.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof Like) {
                        result.append(SystemProperties.get("hcjf.query.like.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof SmallerThanOrEqual) {
                        result.append(SystemProperties.get("hcjf.query.smaller.than.or.equals.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof SmallerThan) {
                        result.append(SystemProperties.get("hcjf.query.smaller.than.reserved.word")).append(" ");
                    }
                    if (fieldEvaluator.getRightValue() == null) {
                        result.append(SystemProperties.get("hcjf.query.null.reserved.word"));
                    } else {
                        result = SQLSerializer.toStringFieldEvaluatorValue(fieldEvaluator.getRightValue(), fieldEvaluator.getRightValue().getClass(), result);
                    }
                }
                result.append(" ");
            }
            separator = separatorValue + " ";
        }
    }

    private static Strings.Builder toStringFieldEvaluatorValue(Object value, Class type, Strings.Builder result) {
        if (BaseEvaluator.ReplaceableValue.class.isAssignableFrom(type)) {
            result.append(SystemProperties.get("hcjf.query.replaceable.value.reserved.word"));
        } else if (BaseEvaluator.QueryValue.class.isAssignableFrom(type)) {
            result.append("(");
            result.append(((BaseEvaluator.QueryValue)value).getQuery().toString());
            result.append(")");
        } else if (String.class.isAssignableFrom(type)) {
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
            result.append(value);
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
        } else if (Date.class.isAssignableFrom(type)) {
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
            result.append(SystemProperties.getDateFormat("hcjf.query.date.format").format((Date)value));
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
        } else if (Collection.class.isAssignableFrom(type)) {
            result.append("(");
            String separator = "";
            for (Object object : (Collection)value) {
                if (object == null) continue;
                result.append(separator);
                result = SQLSerializer.toStringFieldEvaluatorValue(object, object.getClass(), result);
                separator = SystemProperties.get("hcjf.query.argument.separator");
            }
            result.append(")");
        } else {
            result.append(value.toString());
        }
        return result;
    }
}

