/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hcjf.service.security.SecurityPermissions;
import org.hcjf.utils.bson.BsonParcelable;

public final class Grants {
    private static final Map<String, Grant> grantsById = new HashMap<String, Grant>();
    private static final Map<String, Map<String, Grant>> grants = new HashMap<String, Map<String, Grant>>();

    public static synchronized void publishGrant(SecurityPermissions.SecurityPermission permission) {
        Grant grant = new Grant(permission.getName(), permission.getTargetClassName(), permission.getTitle(), permission.getPermissionName(), permission.getDescription(), permission.getTags());
        Map<String, Grant> grantsByClass = grants.get(permission.getTargetClassName());
        if (grantsByClass == null) {
            grantsByClass = new HashMap<String, Grant>();
            grants.put(permission.getTargetClassName(), grantsByClass);
        }
        grantsByClass.put(grant.getGrantName(), grant);
        grantsById.put(grant.permissionId, grant);
    }

    public static Grant getGrant(Class targetClass, String permissionName) {
        Grant result = null;
        Map<String, Grant> grantsByClass = grants.get(targetClass.getName());
        if (grantsByClass != null) {
            result = grantsByClass.get(permissionName);
        }
        return result;
    }

    public static Grant getGrant(String permissionId) {
        return grantsById.get(permissionId);
    }

    public static Collection<Grant> getGrants() {
        ArrayList<Grant> result = new ArrayList<Grant>();
        for (Map<String, Grant> grantsByClass : grants.values()) {
            result.addAll(grantsByClass.values());
        }
        return result;
    }

    public static final class Grant
    implements BsonParcelable {
        private final String permissionId;
        private final String targetClassName;
        private final String grantName;
        private final String title;
        private final String description;
        private final List<String> tags;

        private Grant(String permissionId, String targetClassName, String grantName, String title, String description, List<String> tags) {
            this.permissionId = permissionId;
            this.targetClassName = targetClassName;
            this.grantName = grantName;
            this.title = title;
            this.description = description;
            this.tags = tags;
        }

        public String getPermissionId() {
            return this.permissionId;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getGrantName() {
            return this.grantName;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String toString() {
            return this.getPermissionId();
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof Grant) {
                result = super.equals(obj);
            } else if (obj instanceof String) {
                result = Objects.equals(this.getPermissionId(), obj);
            }
            return result;
        }
    }
}

