/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.cache;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.hcjf.cloud.Cloud;
import org.hcjf.cloud.cache.CloudCacheStrategy;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Introspection;

public abstract class CloudCache {
    private final String cacheName;
    private final Map<Object, Map<String, Object>> instances;
    private final Set<CloudCacheStrategy> strategies;
    private final Lock lock;
    private final Condition condition;

    protected CloudCache(String cacheName, Set<CloudCacheStrategy> strategies) {
        this.cacheName = cacheName;
        this.strategies = strategies;
        this.instances = Cloud.getMap(SystemProperties.get("hcjf.cloud.cache.map.suffix.name") + cacheName);
        this.lock = Cloud.getLock(SystemProperties.get("hcjf.cloud.cache.lock.suffix.name") + cacheName);
        this.condition = Cloud.getCondition(SystemProperties.get("hcjf.cloud.cache.condition.suffix.name") + cacheName, this.lock);
        strategies.forEach(S -> S.init(this));
    }

    public final String getCacheName() {
        return this.cacheName;
    }

    private void applyStrategies() {
        TreeSet ids = new TreeSet();
        this.strategies.forEach(S -> ids.addAll(S.applyStrategy()));
        ids.forEach(this.instances::remove);
    }

    public final void remove(Object id) {
        if (this.instances.containsKey(id)) {
            this.lock.lock();
            try {
                this.instances.remove(id);
                this.strategies.forEach(S -> S.onRemove(id));
                this.applyStrategies();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final void add(Object id, Object value) {
        this.lock.lock();
        try {
            this.instances.put(id, Introspection.toMap(value));
            this.strategies.forEach(S -> S.onAdd(id, value));
            this.applyStrategies();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final <O> O get(Object id, Class<? extends O> resultType) {
        O result = null;
        this.applyStrategies();
        Map<String, Object> instance = this.instances.get(id);
        if (instance != null) {
            try {
                result = Introspection.toInstance(instance, resultType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

