/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hcjf.cloud.impl.network.CloudOrchestrator;
import org.hcjf.cloud.impl.objects.DistributedTree;

public class MapImpl<K, V>
implements Map<K, V> {
    private String name;

    public MapImpl(String name) {
        this.name = name;
        CloudOrchestrator.getInstance().publishPath(Map.class.getName(), name);
    }

    @Override
    public int size() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), this.name);
        return tree.size();
    }

    @Override
    public boolean isEmpty() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), this.name);
        return tree.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), this.name);
        return tree.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        V mapValue;
        boolean result = false;
        Iterator<V> iterator = this.values().iterator();
        while (iterator.hasNext() && !(result = (mapValue = iterator.next()).equals(value))) {
        }
        return result;
    }

    @Override
    public V get(Object key) {
        return (V)CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), this.name, key);
    }

    @Override
    public V put(K key, V value) {
        CloudOrchestrator.getInstance().publishObject(value, System.currentTimeMillis(), Map.class.getName(), this.name, key);
        return value;
    }

    @Override
    public V remove(Object key) {
        Object result = CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), this.name, key);
        CloudOrchestrator.getInstance().hidePath(Map.class.getName(), this.name, key);
        return (V)result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (K key : this.keySet()) {
            CloudOrchestrator.getInstance().hidePath(Map.class.getName(), this.name, key);
        }
    }

    @Override
    public Set<K> keySet() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), this.name);
        return tree.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (K key : this.keySet()) {
            result.add(this.get(key));
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        for (final K key : this.keySet()) {
            result.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return CloudOrchestrator.getInstance().invokeNode(Map.class.getName(), MapImpl.this.name, key);
                }

                @Override
                public V setValue(V value) {
                    CloudOrchestrator.getInstance().publishObject(value, System.currentTimeMillis(), Map.class.getName(), MapImpl.this.name, key);
                    return value;
                }
            });
        }
        return result;
    }
}

