/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl.network;

import java.util.HashMap;
import java.util.Map;
import org.hcjf.cloud.impl.network.CloudOrchestrator;
import org.hcjf.cloud.impl.network.Node;
import org.hcjf.io.net.InetPortProvider;
import org.hcjf.io.net.broadcast.BroadcastConsumer;
import org.hcjf.io.net.broadcast.BroadcastService;
import org.hcjf.properties.SystemProperties;

public class CloudBroadcastConsumer
implements BroadcastConsumer {
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public CloudBroadcastConsumer() {
        this.parameters.put("hcjf.cloud.orchestrator.this.node.lan.address", SystemProperties.get("hcjf.cloud.orchestrator.this.node.lan.address"));
        this.parameters.put("hcjf.cloud.orchestrator.this.node.lan.port", SystemProperties.get("hcjf.cloud.orchestrator.this.node.lan.port"));
    }

    @Override
    public String getTaskName() {
        return SystemProperties.get("hcjf.cloud.orchestrator.broadcast.task.name");
    }

    @Override
    public String getPrivateKey() {
        return SystemProperties.get("hcjf.cloud.orchestrator.cluster.name");
    }

    @Override
    public String getIpVersion() {
        return SystemProperties.get("hcjf.cloud.orchestrator.broadcast.ip.version");
    }

    @Override
    public String getNetInterfaceName() {
        return SystemProperties.get("hcjf.cloud.orchestrator.broadcast.interface.name");
    }

    @Override
    public Integer getPort() {
        return InetPortProvider.getUdpPort(SystemProperties.getInteger("hcjf.cloud.orchestrator.broadcast.port"));
    }

    @Override
    public Map<String, Object> getPingParameters() {
        return this.parameters;
    }

    @Override
    public void onPing(BroadcastService.PingMessage pingMessage) {
        String remoteHost = (String)pingMessage.getCustomParameters().get("hcjf.cloud.orchestrator.this.node.lan.address");
        Integer remotePort = (Integer)pingMessage.getCustomParameters().get("hcjf.cloud.orchestrator.this.node.lan.port");
        Node node = new Node();
        node.setLanAddress(remoteHost);
        node.setLanPort(remotePort);
        CloudOrchestrator.getInstance().registerConsumer(node);
    }

    @Override
    public void onPong(BroadcastService.PongMessage pongMessage) {
        String remoteHost = (String)pongMessage.getCustomParameters().get("hcjf.cloud.orchestrator.this.node.lan.address");
        Integer remotePort = (Integer)pongMessage.getCustomParameters().get("hcjf.cloud.orchestrator.this.node.lan.port");
        Node node = new Node();
        node.setLanAddress(remoteHost);
        node.setLanPort(remotePort);
        CloudOrchestrator.getInstance().registerConsumer(node);
    }

    @Override
    public void onShutdown(BroadcastService.ShutdownMessage shutdownMessage) {
    }
}

