/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hcjf.encoding.MimeType;
import org.hcjf.io.net.http.Context;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.utils.Introspection;

public class EnumContext
extends Context {
    private final String name;
    private final String[] names;

    public EnumContext(String name) {
        super("^/" + name + ".*");
        this.name = name;
        this.names = name.split("/");
    }

    @Override
    public HttpResponse onContext(HttpRequest request) {
        List<String> elements = request.getPathParts();
        String separator = "";
        StringBuilder enumClassNameBuilder = new StringBuilder();
        for (String element : elements) {
            if (element.isEmpty() || Arrays.binarySearch(this.names, element) >= 0) continue;
            enumClassNameBuilder.append(separator);
            enumClassNameBuilder.append(element);
            separator = ".";
        }
        String enumClassName = enumClassNameBuilder.toString();
        Class<?> enumClass = null;
        try {
            enumClass = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HttpResponse response = new HttpResponse();
        if (enumClass != null && enumClass.isEnum()) {
            JsonObject jsonBody = new JsonObject();
            for (Object enumInstance : enumClass.getEnumConstants()) {
                JsonObject jsonInstance = new JsonObject();
                Map<String, String> map = Introspection.toStringsMap(enumInstance);
                for (String key : map.keySet()) {
                    jsonInstance.addProperty(key, map.get(key));
                }
                jsonBody.add(enumInstance.toString(), (JsonElement)jsonInstance);
            }
            byte[] body = jsonBody.toString().getBytes();
            response.setResponseCode(HttpResponseCode.OK);
            response.setBody(body);
            response.addHeader(new HttpHeader("Content-Length", Integer.toString(body.length)));
            response.addHeader(new HttpHeader("Content-Type", MimeType.APPLICATION_JSON.toString()));
        } else {
            response.setResponseCode(HttpResponseCode.NOT_FOUND);
        }
        return response;
    }
}

