/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import org.hcjf.io.net.http.Cookie;
import org.hcjf.io.net.http.Cookie2;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpPackage;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.properties.SystemProperties;

public class HttpResponse
extends HttpPackage {
    private static final int VERSION_INDEX = 0;
    private static final int RESPONSE_CODE_INDEX = 1;
    private Integer responseCode;
    private String reasonPhrase;

    public HttpResponse() {
        this.responseCode = HttpResponseCode.OK;
        this.reasonPhrase = HttpResponseCode.DefaultPhrase.getDefaultPhrase(HttpResponseCode.OK);
    }

    protected HttpResponse(HttpResponse httpResponse) {
        super(httpResponse);
        this.responseCode = httpResponse.responseCode;
        this.reasonPhrase = httpResponse.reasonPhrase;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
        this.reasonPhrase = HttpResponseCode.DefaultPhrase.getDefaultPhrase(responseCode);
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    protected void processBody() {
    }

    @Override
    protected void processFirstLine(String firstLine) {
        String[] parts = firstLine.split(" ");
        if (parts.length == 2) {
            this.setResponseCode(Integer.parseInt(parts[1].trim()));
            this.setHttpVersion(parts[0]);
        }
        if (parts.length >= 3) {
            this.setResponseCode(Integer.parseInt(parts[1].trim()));
            this.setHttpVersion(parts[0]);
            StringBuilder reasonPhraseBuilder = new StringBuilder();
            for (int i = 2; i < parts.length; ++i) {
                reasonPhraseBuilder.append(parts[i]);
            }
            this.setReasonPhrase(reasonPhraseBuilder.toString());
        }
    }

    private String toStringProtocolHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHttpVersion()).append(" ");
        builder.append(this.getResponseCode()).append(" ");
        builder.append(this.getReasonPhrase() == null ? "" : this.getReasonPhrase()).append("\r\n");
        for (HttpHeader header : this.getHeaders()) {
            builder.append(header).append("\r\n");
        }
        for (Cookie cookie : this.getCookies()) {
            builder.append(cookie instanceof Cookie2 ? "Set-Cookie2".toString() : "Set-Cookie".toString());
            builder.append(": ").append(cookie).append("\r\n");
        }
        builder.append("\r\n");
        return builder.toString();
    }

    @Override
    public byte[] getProtocolHeader() {
        return this.toStringProtocolHeader().getBytes();
    }

    public String toString() {
        int maxLength;
        StringBuilder builder = new StringBuilder();
        builder.append(this.toStringProtocolHeader());
        if (this.getBody() != null && (maxLength = SystemProperties.getInteger("hcjf.net.http.output.log.body.max.length").intValue()) > 0) {
            if (this.getBody().length > maxLength) {
                builder.append(new String(this.getBody(), 0, maxLength));
                builder.append(" ... [").append(this.getBody().length - maxLength).append(" more]");
            } else {
                String s = new String(this.getBody());
                builder.append(new String(this.getBody()));
            }
        }
        return builder.toString();
    }
}

