/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hcjf.encoding.MimeType;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.http.Context;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpMethod;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.CreateLayerInterface;
import org.hcjf.layers.crud.DeleteLayerInterface;
import org.hcjf.layers.crud.ReadLayerInterface;
import org.hcjf.layers.crud.UpdateLayerInterface;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.ParameterizedQuery;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.ResultSet;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.JsonUtils;
import org.hcjf.utils.Strings;

public class RestContext
extends Context {
    private static final String REGEX_TEMPLATE = "\\/%s(\\/(?<resource>[A-Za-z0-9\\-\\_]{0,})){0,}";
    private static final String DEFAULT_QUERY_PARAMETER = "q";
    private final List<Pattern> idRegexList;

    public RestContext(String baseContext) {
        this(baseContext, List.of(SystemProperties.getPattern("hcjf.uuid.regex")));
    }

    public RestContext(String baseContext, List<Pattern> idRegexList) {
        super(String.format(REGEX_TEMPLATE, Strings.trim(baseContext, "/")));
        this.idRegexList = idRegexList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HttpResponse onContext(HttpRequest request) {
        RequestModel requestModel;
        JsonElement jsonElement;
        HttpMethod method = request.getMethod();
        Gson gson = new GsonBuilder().setDateFormat(SystemProperties.get("hcjf.default.date.format")).create();
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
        String lastPart = request.getPathParts().get(request.getPathParts().size() - 1);
        Object id = null;
        for (Pattern idRegex : this.idRegexList) {
            if (!idRegex.matcher(lastPart).matches()) continue;
            id = Strings.deductInstance(lastPart);
            break;
        }
        String resourceName = Strings.join(request.getPathParts().stream().skip(1L).limit(request.getPathParts().size() - (id == null ? 0 : 2)), ".");
        if (method.equals((Object)HttpMethod.GET)) {
            ReadLayerInterface readLayerInterface;
            if (id == null) {
                if (request.hasParameter(DEFAULT_QUERY_PARAMETER)) {
                    Query queryable = Query.compile((String)request.getParameter(DEFAULT_QUERY_PARAMETER));
                    Collection<JoinableMap> queryResult = Query.evaluate(queryable);
                    if (queryResult instanceof ResultSet) {
                        ResultSet resultSet = (ResultSet)queryResult;
                        headers.add(new HttpHeader("X-HCJF-Query-Total-Time", resultSet.getTotalTime().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Time-Compiling", resultSet.getTimeCompilingQuery().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Time-Collecting-Data", resultSet.getTimeCollectingData().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Time-Evaluating-Conditions", resultSet.getTimeEvaluatingConditions().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Average-Time-Evaluating-Conditions", resultSet.getAverageTimeFormattingDataByRow().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Time-Formatting-Data", resultSet.getTimeFormattingData().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Average-Time-Formatting-Data", resultSet.getAverageTimeFormattingDataByRow().toString()));
                        headers.add(new HttpHeader("X-HCJF-Query-Present-Fields", Strings.join(resultSet.getPresentFields(), ",")));
                    }
                    jsonElement = gson.toJsonTree(queryResult);
                } else {
                    readLayerInterface = Layers.get(ReadLayerInterface.class, resourceName);
                    jsonElement = gson.toJsonTree(readLayerInterface.read());
                }
            } else {
                readLayerInterface = Layers.get(ReadLayerInterface.class, resourceName);
                jsonElement = gson.toJsonTree(readLayerInterface.read(id));
            }
        } else if (method.equals((Object)HttpMethod.POST)) {
            JsonElement body = JsonParser.parseString((String)new String(request.getBody()));
            requestModel = body.isJsonObject() ? new RequestModel((JsonObject)body) : new RequestModel((JsonArray)body);
            if (requestModel.getBody() == null) {
                Queryable.DataSource<Object> dataSource = requestModel.getDataSource();
                if (requestModel.getQueryable() != null) {
                    jsonElement = dataSource == null ? gson.toJsonTree(Query.evaluate(requestModel.getQueryable())) : gson.toJsonTree(requestModel.getQueryable().evaluate(dataSource));
                } else {
                    if (requestModel.getQueryables() == null) throw new HCJFRuntimeException("Unsupported POST method configuration", new Object[0]);
                    JsonObject queriesResult = new JsonObject();
                    for (String key : requestModel.getQueryables().keySet()) {
                        try {
                            if (dataSource == null) {
                                queriesResult.add(key, gson.toJsonTree(Query.evaluate(requestModel.getQueryables().get(key))));
                                continue;
                            }
                            queriesResult.add(key, gson.toJsonTree(requestModel.getQueryables().get(key).evaluate(dataSource)));
                        }
                        catch (Throwable throwable) {
                            queriesResult.add(key, (JsonElement)this.createJsonFromThrowable(throwable));
                        }
                    }
                    for (String key : requestModel.getPointers().keySet()) {
                        String value = requestModel.getPointers().get(key);
                        queriesResult.add(key, gson.toJsonTree(requestModel.getDataSourcesMap().get(value)));
                    }
                    jsonElement = queriesResult;
                }
            } else {
                CreateLayerInterface createLayerInterface = Layers.get(CreateLayerInterface.class, resourceName);
                jsonElement = requestModel.getBody() instanceof Collection ? gson.toJsonTree(createLayerInterface.create((Collection)requestModel.getBody())) : gson.toJsonTree(createLayerInterface.create(requestModel.getBody()));
            }
        } else if (method.equals((Object)HttpMethod.PUT)) {
            UpdateLayerInterface updateLayerInterface = Layers.get(UpdateLayerInterface.class, resourceName);
            requestModel = new RequestModel(JsonParser.parseString((String)new String(request.getBody())).getAsJsonObject());
            if (requestModel.getQueryable() == null) {
                if (id != null) {
                    ((Map)requestModel.getBody()).put("id", id);
                }
                jsonElement = requestModel.getBody() instanceof Collection ? gson.toJsonTree(updateLayerInterface.update((Collection)requestModel.getBody())) : gson.toJsonTree(updateLayerInterface.update(requestModel.getBody()));
            } else {
                jsonElement = gson.toJsonTree(updateLayerInterface.update(requestModel.queryable, requestModel.getBody()));
            }
        } else {
            if (!method.equals((Object)HttpMethod.DELETE)) throw new HCJFRuntimeException("Unsupported http method: %s", method.toString());
            DeleteLayerInterface deleteLayerInterface = Layers.get(DeleteLayerInterface.class, resourceName);
            jsonElement = id != null && (request.getBody() == null || request.getBody().length == 0) ? gson.toJsonTree(deleteLayerInterface.delete(id)) : ((requestModel = new RequestModel(JsonParser.parseString((String)new String(request.getBody())).getAsJsonObject())).getQueryable() != null ? gson.toJsonTree(deleteLayerInterface.delete(requestModel.getQueryable())) : gson.toJsonTree(deleteLayerInterface.delete(requestModel.getBody())));
        }
        HttpResponse response = new HttpResponse();
        response.addHeader(new HttpHeader("Content-Type", MimeType.APPLICATION_JSON.toString()));
        byte[] body = jsonElement.toString().getBytes();
        response.addHeader(new HttpHeader("Content-Length", Integer.toString(body.length)));
        for (HttpHeader header : headers) {
            response.addHeader(header);
        }
        response.setBody(body);
        return response;
    }

    @Override
    protected HttpResponse onError(HttpRequest request, Throwable throwable) {
        HttpResponse response = new HttpResponse();
        response.setResponseCode(HttpResponseCode.BAD_REQUEST);
        response.addHeader(new HttpHeader("Content-Type", MimeType.APPLICATION_JSON.toString()));
        byte[] body = this.createJsonFromThrowable(throwable).toString().getBytes();
        response.addHeader(new HttpHeader("Content-Length", Integer.toString(body.length)));
        response.setBody(body);
        return response;
    }

    private JsonObject createJsonFromThrowable(Throwable throwable) {
        Map<String, String> tags;
        JsonObject jsonObject = new JsonObject();
        if (throwable.getMessage() != null) {
            jsonObject.addProperty("message", throwable.getMessage());
        }
        if (!(tags = this.getTags(throwable, new HashMap<String, String>())).isEmpty()) {
            JsonObject jsonTags = new JsonObject();
            for (String tag : tags.keySet()) {
                jsonTags.addProperty(tag, tags.get(tag));
            }
            jsonObject.add("tags", (JsonElement)jsonTags);
        }
        jsonObject.addProperty("exception", throwable.getClass().getName());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        jsonObject.addProperty("body", byteArrayOutputStream.toString());
        return jsonObject;
    }

    private Map<String, String> getTags(Throwable throwable, Map<String, String> tag) {
        if (throwable.getMessage() != null) {
            tag.putAll(Strings.getTagsFromMessage(throwable.getMessage()));
        }
        if (throwable.getCause() != null) {
            tag = this.getTags(throwable.getCause(), tag);
        }
        return tag;
    }

    private static class RequestModel {
        private Object body;
        private Queryable queryable;
        private Map<String, Queryable> queryables;
        private Map<String, String> pointers;
        private Map<String, Object> requestConfig;
        private Map<String, Object> dataSourcesMap;
        private Queryable.DataSource<Object> dataSource;

        public RequestModel(JsonArray jsonArray) {
            this.body = JsonUtils.createList(jsonArray);
        }

        public RequestModel(JsonObject jsonObject) {
            if (!(jsonObject.has(SystemProperties.get("hcjf.net.http.rest.body.field")) || jsonObject.has(SystemProperties.get("hcjf.net.http.rest.query.field")) || jsonObject.has(SystemProperties.get("hcjf.net.http.rest.queries.field")))) {
                this.body = JsonUtils.createBody(jsonObject);
            } else {
                if (jsonObject.has(SystemProperties.get("hcjf.net.http.rest.body.field"))) {
                    this.body = JsonUtils.createBody(jsonObject.getAsJsonObject(SystemProperties.get("hcjf.net.http.rest.body.field")));
                }
                if (jsonObject.has(SystemProperties.get("hcjf.net.http.rest.query.field"))) {
                    this.queryable = (Queryable)this.createQuery(jsonObject.get(SystemProperties.get("hcjf.net.http.rest.query.field")));
                }
                if (jsonObject.has(SystemProperties.get("hcjf.net.http.rest.queries.field"))) {
                    this.pointers = new HashMap<String, String>();
                    this.queryables = new HashMap<String, Queryable>();
                    JsonObject queryablesObject = jsonObject.getAsJsonObject(SystemProperties.get("hcjf.net.http.rest.queries.field"));
                    for (String key : queryablesObject.keySet()) {
                        Object query = this.createQuery(queryablesObject.get(key));
                        if (query instanceof Queryable) {
                            this.queryables.put(key, (Queryable)query);
                            continue;
                        }
                        this.pointers.put(key, (String)query);
                    }
                }
                if (jsonObject.has(SystemProperties.get("hcjf.net.http.rest.data.source.field"))) {
                    Map rawDataSources = (Map)JsonUtils.createObject(jsonObject.get(SystemProperties.get("hcjf.net.http.rest.data.source.field")));
                    this.dataSourcesMap = new HashMap<String, Object>();
                    for (String dataSourceName : rawDataSources.keySet()) {
                        Object dataSource = rawDataSources.get(dataSourceName);
                        if (dataSource instanceof String) {
                            Query queryable2 = Query.compile((String)dataSource);
                            this.dataSourcesMap.put(dataSourceName, Query.evaluate(queryable2));
                            continue;
                        }
                        if (dataSource instanceof List) {
                            this.dataSourcesMap.put(dataSourceName, dataSource);
                            continue;
                        }
                        if (!(dataSource instanceof Map)) continue;
                        ArrayList list = new ArrayList();
                        list.add(dataSource);
                        this.dataSourcesMap.put(dataSourceName, list);
                    }
                    this.dataSource = queryable -> {
                        if (this.dataSourcesMap.containsKey(queryable.getResourceName())) {
                            return (Collection)this.dataSourcesMap.get(queryable.getResourceName());
                        }
                        throw new HCJFRuntimeException("Data source not found: %s", queryable.getResourceName());
                    };
                }
            }
        }

        private Object createQuery(JsonElement element) {
            Object result;
            if (element instanceof JsonObject) {
                JsonObject queryJsonObject = element.getAsJsonObject();
                ParameterizedQuery parameterizedQuery = Query.compile(queryJsonObject.get("value").getAsString()).getParameterizedQuery();
                if (queryJsonObject.has("params")) {
                    for (Object parameter : JsonUtils.createList(queryJsonObject.get("params").getAsJsonArray())) {
                        parameterizedQuery.add(parameter);
                    }
                }
                result = parameterizedQuery;
            } else {
                String value = element.getAsString();
                result = value.startsWith("$") ? value.substring("$".length()) : Query.compile(element.getAsString());
            }
            return result;
        }

        public Object getBody() {
            return this.body;
        }

        public Queryable getQueryable() {
            return this.queryable;
        }

        public Map<String, Queryable> getQueryables() {
            return this.queryables;
        }

        public Map<String, String> getPointers() {
            return this.pointers;
        }

        public Map<String, Object> getDataSourcesMap() {
            return this.dataSourcesMap;
        }

        public Queryable.DataSource<Object> getDataSource() {
            return this.dataSource;
        }
    }

    private static class Fields {
        private static final String VALUE_FIELD = "value";
        private static final String PARAMS_FIELD = "params";
        private static final String ID_URL_FIELD = "id";
        private static final String POINTER_PREFIX = "$";
        private static final String REQUEST_CONFIG = "__request_config";
        private static final String DATE_FORMAT_CONFIG = "dateFormat";

        private Fields() {
        }

        private static class Throwable {
            private static final String MESSAGE = "message";
            private static final String EXCEPTION = "exception";
            private static final String BODY = "body";
            private static final String TAGS = "tags";

            private Throwable() {
            }
        }
    }
}

