/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.pipeline;

import java.nio.ByteBuffer;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.pipeline.HttpPipelineResponse;

public abstract class ChunkedHttpPipelineResponse
extends HttpPipelineResponse {
    private static final int RESERVED_BYTE_NUMBER = 4;
    private static final byte[] CHUNKED_SEPARATOR = "\r\n".getBytes();
    private boolean end;

    public ChunkedHttpPipelineResponse(int bufferSize) {
        super(ChunkedHttpPipelineResponse.calculateMainBufferSize(bufferSize), bufferSize);
        this.addHeader(new HttpHeader("Transfer-Encoding", "chunked"));
    }

    @Override
    protected int wrap(ByteBuffer result, HttpPipelineResponse.StreamingPackage streamingPackage, int size) {
        int resultSize;
        if (size == -1 && this.end) {
            resultSize = -1;
        } else {
            result.put(Integer.toString(size > 0 ? size : 0, 16).getBytes());
            result.put(CHUNKED_SEPARATOR);
            result.put(streamingPackage.getBuffer(), 0, size > 0 ? size : 0);
            result.put(CHUNKED_SEPARATOR);
            resultSize = result.position();
            if (size == -1) {
                this.end = true;
            }
        }
        return resultSize;
    }

    private static int calculateMainBufferSize(int bufferSize) {
        return bufferSize + Integer.toString(bufferSize).getBytes().length + 4;
    }
}

