/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.pipeline;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.hcjf.io.net.http.HttpResponse;

public abstract class HttpPipelineResponse
extends HttpResponse {
    private final ByteBuffer mainBuffer;
    private final StreamingPackage streamingPackage;
    private int readCounter;

    public HttpPipelineResponse(int mainBufferSize, int bufferSize) {
        this.mainBuffer = ByteBuffer.allocate(mainBufferSize);
        this.streamingPackage = new StreamingPackage(bufferSize);
        this.readCounter = 0;
    }

    public final boolean isFirstRead() {
        return this.getReadCounter() == 1;
    }

    public final int getReadCounter() {
        return this.readCounter;
    }

    public final int read() {
        this.mainBuffer.rewind();
        this.streamingPackage.clear();
        int size = this.readPipeline(this.streamingPackage);
        ++this.readCounter;
        size = this.wrap(this.mainBuffer, this.streamingPackage, size);
        return size;
    }

    public final ByteBuffer getMainBuffer() {
        return this.mainBuffer;
    }

    protected int wrap(ByteBuffer result, StreamingPackage streamingPackage, int size) {
        result.put(streamingPackage.getBuffer(), 0, size);
        return result.position();
    }

    public void onStart() {
    }

    public void onEnd() {
    }

    protected abstract int readPipeline(StreamingPackage var1);

    protected final class StreamingPackage {
        private final byte[] buffer;
        private final Map<String, Object> properties;

        public StreamingPackage(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.properties = new HashMap<String, Object>();
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public void put(String propertyName, Object propertyValue) {
            this.properties.put(propertyName, propertyValue);
        }

        public <O> O get(String propertyName) {
            return (O)this.properties.get(propertyName);
        }

        public boolean contains(String propertyName) {
            return this.properties.containsKey(propertyName);
        }

        public void clear() {
            this.properties.clear();
        }
    }
}

