/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes;

import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceConsumer;

public abstract class KubernetesSpyConsumer
implements ServiceConsumer {
    private final Map<String, V1Pod> pods;
    private final Map<String, V1Service> services;
    private final PodMatcher podMatcher;
    private final ServiceMatcher serviceMatcher;

    public KubernetesSpyConsumer(PodMatcher podMatcher, ServiceMatcher serviceMatcher) {
        this.podMatcher = podMatcher;
        this.serviceMatcher = serviceMatcher;
        this.pods = new HashMap<String, V1Pod>();
        this.services = new HashMap<String, V1Service>();
    }

    public KubernetesSpyConsumer(PodMatcher podMatcher) {
        this(podMatcher, S -> false);
    }

    public KubernetesSpyConsumer(ServiceMatcher serviceMatcher) {
        this(P -> false, serviceMatcher);
    }

    public KubernetesSpyConsumer() {
        this(P -> true, S -> true);
    }

    public final void updatePods(V1PodList podList) {
        Log.d(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Starting update pods process", new Object[0]);
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(this.pods.keySet());
        for (V1Pod pod : podList.getItems()) {
            if (ids.remove(pod.getMetadata().getUid())) continue;
            Log.d(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "New pod founded: %s", pod.getMetadata().getUid());
            this.pods.put(pod.getMetadata().getUid(), pod);
            if (!this.podMatcher.match(pod)) continue;
            Log.d(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Adding new pod: %s", pod.getMetadata().getUid());
            this.onPodDiscovery(pod);
        }
        for (String uid : ids) {
            this.onPodLost(this.pods.remove(uid));
        }
    }

    public final void updateServices(V1ServiceList serviceList) {
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(this.services.keySet());
        for (V1Service service : serviceList.getItems()) {
            if (!ids.remove(service.getMetadata().getUid())) {
                if (!service.getSpec().getPorts().isEmpty()) {
                    this.services.put(service.getMetadata().getUid(), service);
                    if (!this.serviceMatcher.match(service)) continue;
                    this.onServiceDiscovery(service);
                    continue;
                }
                Log.d(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Service skip because there aren't end points present: %s", service.getMetadata().getName());
                continue;
            }
            if (!service.getSpec().getPorts().isEmpty()) continue;
            Log.d(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Service lost because there aren't end points present: %s", service.getMetadata().getName());
            this.onServiceLost(this.services.remove(service.getMetadata().getUid()));
        }
        for (String uid : ids) {
            this.onServiceLost(this.services.remove(uid));
        }
    }

    protected void onPodDiscovery(V1Pod pod) {
    }

    protected void onPodLost(V1Pod pod) {
    }

    protected void onServiceDiscovery(V1Service service) {
    }

    protected void onServiceLost(V1Service service) {
    }

    public static interface ServiceMatcher {
        public boolean match(V1Service var1);
    }

    public static interface PodMatcher {
        public boolean match(V1Pod var1);
    }
}

