/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.process;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.hcjf.io.process.ProcessDiscoveryConsumer;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;

public class ProcessDiscoveryService
extends Service<ProcessDiscoveryConsumer> {
    private static final ProcessDiscoveryService instance = new ProcessDiscoveryService();
    private final Set<ProcessDiscoveryConsumer> consumers = new HashSet<ProcessDiscoveryConsumer>();
    private Boolean shuttingDown = false;

    private ProcessDiscoveryService() {
        super(SystemProperties.get("hcjf.process.discovery.service.name"), SystemProperties.getInteger("hcjf.process.discovery.service.priority"));
    }

    @Override
    protected void init() {
        this.fork(new ProcessMatcher());
    }

    public static ProcessDiscoveryService getInstance() {
        return instance;
    }

    @Override
    public void registerConsumer(ProcessDiscoveryConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void unregisterConsumer(ProcessDiscoveryConsumer consumer) {
        this.consumers.remove(consumer);
    }

    @Override
    protected void shutdown(Service.ShutdownStage stage) {
        this.shuttingDown = true;
    }

    private class ProcessMatcher
    implements Runnable {
        private ProcessMatcher() {
        }

        @Override
        public void run() {
            while (!ProcessDiscoveryService.this.shuttingDown.booleanValue()) {
                try {
                    Stream<ProcessHandle> liveProcesses = ProcessHandle.allProcesses();
                    for (ProcessDiscoveryConsumer consumer : ProcessDiscoveryService.this.consumers) {
                        try {
                            liveProcesses.filter(consumer::match).forEach(P -> {
                                if (P.isAlive()) {
                                    consumer.onDiscovery((ProcessHandle)P);
                                } else {
                                    consumer.onKill((ProcessHandle)P);
                                }
                            });
                        }
                        catch (Exception ex) {
                            Log.w(SystemProperties.get("hcjf.process.log.tag"), "Process discovery match error", ex, new Object[0]);
                        }
                    }
                }
                catch (Exception ex) {
                    Log.w(SystemProperties.get("hcjf.process.log.tag"), "Process discovery error", ex, new Object[0]);
                }
                try {
                    Thread.sleep(SystemProperties.getLong("hcjf.process.delay"));
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            Log.d(SystemProperties.get("hcjf.process.log.tag"), "Process matcher end", new Object[0]);
        }
    }
}

