/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.evaluators.EvaluatorCollection;
import org.hcjf.layers.query.model.QueryResource;

public class Join
extends EvaluatorCollection
implements Comparable<Join> {
    private final QueryResource resource;
    private final JoinType type;
    private final Boolean outer;

    public Join(Query query, String resourceName, JoinType type) {
        this(query, new QueryResource(resourceName), type, false);
    }

    public Join(Query query, QueryResource resource, JoinType type) {
        this(query, resource, type, false);
    }

    public Join(Query query, String resourceName, JoinType type, boolean outer) {
        this(query, new QueryResource(resourceName), type, outer);
    }

    public Join(Query query, QueryResource resource, JoinType type, boolean outer) {
        super(query);
        this.resource = resource;
        this.type = type;
        this.outer = outer;
    }

    public QueryResource getResource() {
        return this.resource;
    }

    public String getResourceName() {
        return this.resource.getResourceName();
    }

    public JoinType getType() {
        return this.type;
    }

    public Boolean getOuter() {
        return this.outer;
    }

    @Override
    public int compareTo(Join join) {
        return this.getResource().compareTo(join.getResource());
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object.getClass().equals(this.getClass())) {
            Join join = (Join)object;
            result = this.getResource().equals(join.getResource());
        }
        return result;
    }

    public static enum JoinType {
        JOIN,
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

