/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hcjf.bson.BsonDocument;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.IdentifiableLayerInterface;
import org.hcjf.layers.query.Enlarged;
import org.hcjf.layers.query.Groupable;
import org.hcjf.layers.query.Join;
import org.hcjf.layers.query.Joinable;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.ParameterizedQuery;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.ResultSet;
import org.hcjf.layers.query.compilers.JsonCompiler;
import org.hcjf.layers.query.compilers.QueryCompiler;
import org.hcjf.layers.query.compilers.SQLCompiler;
import org.hcjf.layers.query.evaluators.And;
import org.hcjf.layers.query.evaluators.BooleanEvaluator;
import org.hcjf.layers.query.evaluators.Equals;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.evaluators.EvaluatorCollection;
import org.hcjf.layers.query.evaluators.FieldEvaluator;
import org.hcjf.layers.query.evaluators.In;
import org.hcjf.layers.query.evaluators.Or;
import org.hcjf.layers.query.evaluators.TrueEvaluator;
import org.hcjf.layers.query.functions.AddAggregateFunction;
import org.hcjf.layers.query.functions.BsonQueryFunctionLayer;
import org.hcjf.layers.query.functions.CollectionQueryFunction;
import org.hcjf.layers.query.functions.ContextAggregateFunction;
import org.hcjf.layers.query.functions.CountQueryAggregateFunctionLayer;
import org.hcjf.layers.query.functions.DateQueryFunctionLayer;
import org.hcjf.layers.query.functions.DistinctQueryAggregateFunction;
import org.hcjf.layers.query.functions.EvalExpressionAggregateFunctionLayer;
import org.hcjf.layers.query.functions.GeoDistanceAggregateFunctionLayer;
import org.hcjf.layers.query.functions.GeoQueryFunctionLayer;
import org.hcjf.layers.query.functions.GeoUnionAggregateFunctionLayer;
import org.hcjf.layers.query.functions.MathQueryFunctionLayer;
import org.hcjf.layers.query.functions.MaxAggregateFunctionLayer;
import org.hcjf.layers.query.functions.MeanAggregateFunctionLayer;
import org.hcjf.layers.query.functions.MinAggregateFunctionLayer;
import org.hcjf.layers.query.functions.ObjectQueryFunction;
import org.hcjf.layers.query.functions.ProductAggregateFunctionLayer;
import org.hcjf.layers.query.functions.PutAggregateFunction;
import org.hcjf.layers.query.functions.ReferenceFunctionLayer;
import org.hcjf.layers.query.functions.ShellQueryFunction;
import org.hcjf.layers.query.functions.StringQueryFunctionLayer;
import org.hcjf.layers.query.functions.SumAggregateFunctionLayer;
import org.hcjf.layers.query.model.QueryBsonBuilderLayer;
import org.hcjf.layers.query.model.QueryDynamicResource;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryId;
import org.hcjf.layers.query.model.QueryJsonResource;
import org.hcjf.layers.query.model.QueryOrderField;
import org.hcjf.layers.query.model.QueryOrderFunction;
import org.hcjf.layers.query.model.QueryOrderParameter;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryResource;
import org.hcjf.layers.query.model.QueryReturnField;
import org.hcjf.layers.query.model.QueryReturnFunction;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.layers.query.serializer.QuerySerializer;
import org.hcjf.layers.query.serializer.SQLSerializer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.LruMap;
import org.hcjf.utils.NamedUuid;
import org.hcjf.utils.bson.BsonParcelable;

public class Query
extends EvaluatorCollection
implements Queryable {
    public static final String QUERY_BSON_FIELD_NAME = "__query__";
    public static final String DISJOINT_RESULT_SET = "disjointResultSet";
    private static final LruMap<String, Query> cache = new LruMap(SystemProperties.getInteger("hcjf.query.compiler.cache.size"));
    private final QueryId id;
    private final QueryResource resource;
    private final List<QueryResource> resources;
    private Integer limit;
    private Integer underlyingLimit;
    private Integer start;
    private Integer underlyingStart;
    private final List<QueryReturnParameter> groupParameters;
    private final List<QueryOrderParameter> orderParameters;
    private final List<QueryReturnParameter> returnParameters;
    private final List<Join> joins;
    private final List<Queryable> unions;
    private boolean returnAll;
    private boolean disjoint;
    private Map<String, Object> environment;

    public Query(QueryResource resource, QueryId id) {
        this.id = id;
        this.groupParameters = new ArrayList<QueryReturnParameter>();
        this.orderParameters = new ArrayList<QueryOrderParameter>();
        this.returnParameters = new ArrayList<QueryReturnParameter>();
        this.joins = new ArrayList<Join>();
        this.resource = resource;
        this.resources = new ArrayList<QueryResource>();
        this.resources.add(this.resource);
        this.unions = new ArrayList<Queryable>();
    }

    public Query(String resource) {
        this(new QueryResource(resource));
    }

    public Query(QueryResource resource) {
        this(resource, new QueryId());
    }

    private Query(Query source) {
        super(source);
        this.id = new QueryId();
        this.resource = source.resource;
        this.resources = new ArrayList<QueryResource>();
        this.resources.add(this.resource);
        this.limit = source.limit;
        this.start = source.start;
        this.returnAll = source.returnAll;
        this.orderParameters = new ArrayList<QueryOrderParameter>();
        this.orderParameters.addAll(source.orderParameters);
        this.returnParameters = new ArrayList<QueryReturnParameter>();
        this.returnParameters.addAll(source.returnParameters);
        this.groupParameters = new ArrayList<QueryReturnParameter>();
        this.groupParameters.addAll(source.groupParameters);
        this.joins = new ArrayList<Join>();
        this.joins.addAll(source.joins);
        this.unions = new ArrayList<Queryable>();
        this.unions.addAll(source.unions);
    }

    private QueryParameter checkQueryParameter(QueryParameter queryParameter) {
        if (queryParameter instanceof QueryField) {
            QueryField queryField = (QueryField)queryParameter;
            QueryResource queryResource = queryField.getResource();
        } else if (queryParameter instanceof QueryFunction) {
            QueryFunction function = (QueryFunction)queryParameter;
            for (Object functionParameter : function.getParameters()) {
                if (!(functionParameter instanceof QueryParameter)) continue;
                this.checkQueryParameter((QueryParameter)functionParameter);
            }
        }
        return queryParameter;
    }

    @Override
    protected Evaluator checkEvaluator(Evaluator evaluator) {
        if (evaluator instanceof FieldEvaluator) {
            FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
            if (fieldEvaluator.getLeftValue() instanceof QueryParameter) {
                this.checkQueryParameter((QueryParameter)fieldEvaluator.getLeftValue());
            }
            if (fieldEvaluator.getRightValue() instanceof QueryParameter) {
                this.checkQueryParameter((QueryParameter)fieldEvaluator.getRightValue());
            }
        }
        return evaluator;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment = environment;
    }

    public final boolean returnAll() {
        return this.returnAll || this.returnParameters.isEmpty();
    }

    public final ParameterizedQuery getParameterizedQuery() {
        return new ParameterizedQuery(this);
    }

    public final QueryId getId() {
        return this.id;
    }

    public List<Join> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    public List<Queryable> getUnions() {
        return Collections.unmodifiableList(this.unions);
    }

    public QueryResource getResource() {
        return this.resource;
    }

    @Override
    public final String getResourceName() {
        return this.resource.getResourceName();
    }

    public List<QueryResource> getResources() {
        return this.resources;
    }

    public final Integer getLimit() {
        return this.limit;
    }

    public final void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getUnderlyingLimit() {
        return this.underlyingLimit;
    }

    public void setUnderlyingLimit(Integer underlyingLimit) {
        this.underlyingLimit = underlyingLimit;
    }

    public final Integer getStart() {
        return this.start != null ? this.start : 0;
    }

    public final void setStart(Integer start) {
        this.start = start;
    }

    public Integer getUnderlyingStart() {
        return this.underlyingStart;
    }

    public void setUnderlyingStart(Integer underlyingStart) {
        this.underlyingStart = underlyingStart;
    }

    public List<QueryReturnParameter> getGroupParameters() {
        return Collections.unmodifiableList(this.groupParameters);
    }

    public final Query addGroupField(String groupField) {
        return this.addGroupField(new QueryReturnField(this, groupField));
    }

    public final Query addGroupField(QueryReturnParameter groupField) {
        this.groupParameters.add((QueryReturnParameter)((Object)this.checkQueryParameter((QueryParameter)((Object)groupField))));
        return this;
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    public void setDisjoint(boolean disjoint) {
        this.disjoint = disjoint;
    }

    public final List<QueryOrderParameter> getOrderParameters() {
        return Collections.unmodifiableList(this.orderParameters);
    }

    public final Query addOrderField(String orderField) {
        return this.addOrderField(orderField, SystemProperties.getBoolean("hcjf.query.default.desc.order"));
    }

    public final Query addOrderField(String orderField, boolean desc) {
        return this.addOrderParameter(new QueryOrderField(this, orderField, desc));
    }

    public final Query addOrderParameter(QueryOrderParameter orderParameter) {
        this.orderParameters.add((QueryOrderParameter)((Object)this.checkQueryParameter((QueryParameter)((Object)orderParameter))));
        return this;
    }

    public final List<QueryReturnParameter> getReturnParameters() {
        return Collections.unmodifiableList(this.returnParameters);
    }

    public final Query addReturnField(String returnField) {
        if (returnField.equals(SystemProperties.get("hcjf.query.return.all.reserved.word"))) {
            this.returnAll = true;
        } else {
            this.addReturnField(new QueryReturnField(this, returnField));
        }
        return this;
    }

    public final Query addReturnField(QueryReturnParameter returnParameter) {
        if (returnParameter instanceof QueryReturnField && ((QueryReturnField)returnParameter).getFieldPath().equals(SystemProperties.get("hcjf.query.return.all.reserved.word"))) {
            this.returnAll = true;
        } else {
            this.returnParameters.add((QueryReturnParameter)((Object)this.checkQueryParameter((QueryParameter)((Object)returnParameter))));
        }
        return this;
    }

    public final void addJoin(Join join) {
        if (join != null && !this.joins.contains(join)) {
            this.joins.add(join);
        } else if (join == null) {
            throw new NullPointerException("Null join instance");
        }
    }

    public final void addUnion(Queryable queryable) {
        if (queryable == null) {
            throw new HCJFRuntimeException("Null union value", new Object[0]);
        }
        this.unions.add(queryable);
    }

    @Override
    public final <O> Collection<O> evaluate(Collection<O> dataSource) {
        return this.evaluate((Queryable query) -> dataSource, new Queryable.IntrospectionConsumer());
    }

    @Override
    public final <O> Collection<O> evaluate(Collection<O> dataSource, Queryable.Consumer<O> consumer) {
        return this.evaluate((Queryable query) -> dataSource, consumer);
    }

    @Override
    public final <O> Collection<O> evaluate(Queryable.DataSource<O> dataSource) {
        return this.evaluate(dataSource, new Queryable.IntrospectionConsumer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final <O> Collection<O> evaluate(Queryable.DataSource<O> dataSource, Queryable.Consumer<O> consumer) {
        Collection<Joinable> result;
        HashMap<String, Groupable> groupables = null;
        HashMap<String, JoinableMap> disjointResultSets = null;
        ArrayList<QueryReturnFunction> aggregateFunctions = new ArrayList<QueryReturnFunction>();
        if (!(Thread.currentThread() instanceof ServiceThread)) {
            result = Service.call(() -> this.evaluate(dataSource, consumer), ServiceSession.getGuestSession());
        } else {
            Long totalTime = System.currentTimeMillis();
            this.initializeEvaluatorsCache();
            result = this.orderParameters.size() > 0 ? new TreeSet((o1, o2) -> {
                int compareResult = 0;
                for (QueryOrderParameter orderField : this.orderParameters) {
                    Comparable comparable2;
                    Comparable comparable1;
                    try {
                        if (orderField instanceof QueryOrderFunction) {
                            comparable1 = (Comparable)consumer.resolveFunction((QueryOrderFunction)orderField, o1, dataSource);
                            comparable2 = (Comparable)consumer.resolveFunction((QueryOrderFunction)orderField, o2, dataSource);
                        } else {
                            comparable1 = (Comparable)consumer.get((Joinable)o1, (QueryParameter)((Object)orderField), dataSource);
                            comparable2 = (Comparable)consumer.get((Joinable)o2, (QueryParameter)((Object)orderField), dataSource);
                        }
                    }
                    catch (ClassCastException ex) {
                        throw new HCJFRuntimeException("Order field must be comparable", new Object[0]);
                    }
                    if ((compareResult = comparable1 == null ^ comparable2 == null ? (comparable1 == null ? -1 : 1) : (comparable1 == null && comparable2 == null ? 0 : comparable1.compareTo(comparable2) * (orderField.isDesc() ? -1 : 1))) == 0) continue;
                    break;
                }
                if (compareResult == 0) {
                    compareResult = o1.hashCode() - o2.hashCode();
                }
                return compareResult;
            }) : new ArrayList();
            Long timeCollectingData = System.currentTimeMillis();
            Integer evaluatingCount = 0;
            Integer formattingCount = 0;
            Long timeEvaluatingConditions = 0L;
            Long timeFormattingData = 0L;
            TreeSet<String> presentFields = new TreeSet<String>();
            try {
                Collection<? extends Joinable> data;
                if (this.joins.size() > 0) {
                    data = this.join(dataSource, consumer);
                } else if (this.getResource() instanceof QueryDynamicResource) {
                    data = this.resolveDynamicResource((QueryDynamicResource)this.getResource(), dataSource, consumer);
                } else if (this.getResource() instanceof QueryJsonResource) {
                    data = ((QueryJsonResource)this.getResource()).getResourceValues();
                } else {
                    Query resolveQuery = new Query(this.getResource());
                    resolveQuery.returnAll = true;
                    resolveQuery.setLimit(this.getLimit());
                    resolveQuery.setUnderlyingLimit(this.getUnderlyingLimit());
                    resolveQuery.setStart(this.getStart());
                    resolveQuery.setUnderlyingStart(this.getUnderlyingStart());
                    for (QueryOrderParameter queryOrderParameter : this.getOrderParameters()) {
                        resolveQuery.addOrderParameter(queryOrderParameter);
                    }
                    this.copyEvaluators(resolveQuery, this);
                    data = dataSource.getResourceData(this.verifyInstance(resolveQuery, consumer));
                }
                timeCollectingData = System.currentTimeMillis() - timeCollectingData;
                ArrayList<String> returnParametersAsArray = new ArrayList<String>();
                for (QueryReturnParameter returnParameter : this.getReturnParameters()) {
                    if (returnParameter instanceof QueryReturnFunction && ((QueryReturnFunction)returnParameter).isAggregate()) {
                        aggregateFunctions.add((QueryReturnFunction)returnParameter);
                    }
                    returnParametersAsArray.add(returnParameter.getAlias());
                }
                if (!this.groupParameters.isEmpty()) {
                    if (this.isDisjoint()) {
                        disjointResultSets = new HashMap<String, JoinableMap>();
                    } else {
                        groupables = new HashMap<String, Groupable>();
                    }
                }
                for (Joinable joinable : data) {
                    void var20_27;
                    Long timeEvaluating = System.currentTimeMillis();
                    boolean add = this.verifyCondition(joinable, dataSource, consumer);
                    timeEvaluating = System.currentTimeMillis() - timeEvaluating;
                    timeEvaluatingConditions = timeEvaluatingConditions + timeEvaluating;
                    Integer n = evaluatingCount;
                    evaluatingCount = evaluatingCount + 1;
                    if (!add) continue;
                    Long timeFormatting = System.currentTimeMillis();
                    if (joinable instanceof Enlarged || joinable instanceof Map) {
                        Enlarged enlargedObject;
                        if (joinable instanceof Enlarged) {
                            if (this.returnAll) {
                                enlargedObject = ((Enlarged)((Object)joinable)).clone(new String[0]);
                                presentFields.addAll(enlargedObject.keySet());
                            } else {
                                enlargedObject = ((Enlarged)((Object)joinable)).clone(returnParametersAsArray.toArray(new String[0]));
                            }
                        } else if (this.returnAll) {
                            enlargedObject = new JoinableMap((Map)((Object)joinable), new String[0]).clone(new String[0]);
                            presentFields.addAll(enlargedObject.keySet());
                        } else {
                            enlargedObject = new JoinableMap((Map)((Object)joinable), new String[0]).clone(returnParametersAsArray.toArray(new String[0]));
                        }
                        Enlarged enlarged = enlargedObject;
                        for (QueryReturnParameter queryReturnParameter : this.getReturnParameters()) {
                            Map.Entry<String, Object> entry = consumer.resolveQueryReturnParameter(queryReturnParameter, enlarged, dataSource);
                            if (entry == null) continue;
                            presentFields.add(entry.getKey());
                            enlargedObject.put(entry.getKey(), entry.getValue());
                        }
                    }
                    if (!this.groupParameters.isEmpty() && (var20_27 instanceof Groupable || this.isDisjoint())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        HashMap groupKeyValues = new HashMap();
                        for (QueryReturnParameter returnParameter2 : this.groupParameters) {
                            Object groupValue = returnParameter2 instanceof QueryReturnField ? consumer.get((Joinable)var20_27, (QueryReturnField)returnParameter2, dataSource) : consumer.resolveFunction((QueryReturnFunction)returnParameter2, var20_27, dataSource);
                            groupKeyValues.put(returnParameter2.getAlias(), groupValue);
                            stringBuilder.append(groupValue);
                        }
                        if (this.isDisjoint()) {
                            void var25_39;
                            if (disjointResultSets.containsKey(stringBuilder.toString())) {
                                Collection collection = (Collection)Introspection.resolve(disjointResultSets, stringBuilder.toString(), DISJOINT_RESULT_SET);
                            } else {
                                ArrayList arrayList = new ArrayList();
                                JoinableMap disjointMap = new JoinableMap();
                                disjointMap.putAll(groupKeyValues);
                                disjointMap.put(DISJOINT_RESULT_SET, (Object)arrayList);
                                disjointResultSets.put(stringBuilder.toString(), disjointMap);
                            }
                            if (var20_27 instanceof Enlarged && !this.returnAll) {
                                ((Enlarged)var20_27).purge();
                            }
                            var25_39.add(var20_27);
                        } else if (groupables.containsKey(stringBuilder.toString())) {
                            ((Groupable)groupables.get(stringBuilder.toString())).group((Groupable)var20_27);
                        } else {
                            groupables.put(stringBuilder.toString(), (Groupable)var20_27);
                        }
                    } else {
                        result.add((Joinable)var20_27);
                    }
                    timeFormatting = System.currentTimeMillis() - timeFormatting;
                    Integer n2 = formattingCount;
                    formattingCount = formattingCount + 1;
                    timeFormattingData = timeFormattingData + timeFormatting;
                }
                if (groupables != null) {
                    result.addAll(groupables.values());
                }
                if (disjointResultSets != null) {
                    result.addAll(disjointResultSets.values());
                }
            }
            finally {
                this.clearEvaluatorsCache();
            }
            Long timeAggregatingData = System.currentTimeMillis();
            if (aggregateFunctions.size() > 0) {
                for (QueryReturnFunction queryReturnFunction : aggregateFunctions) {
                    result = (Collection)consumer.resolveFunction(queryReturnFunction, result, dataSource);
                }
            }
            if (result.size() > 0 && result.iterator().next() instanceof Enlarged && !this.returnAll && !this.isDisjoint()) {
                result.forEach(O -> ((Enlarged)O).purge());
            }
            if (this.getStart() != 0 || this.getLimit() != null) {
                result = this.getLimit() != null ? (Collection)result.stream().skip(this.getStart().intValue()).limit(this.getLimit().intValue()).collect(Collectors.toList()) : (Collection)result.stream().skip(this.getStart().intValue()).collect(Collectors.toList());
            }
            timeAggregatingData = System.currentTimeMillis() - timeAggregatingData;
            totalTime = System.currentTimeMillis() - totalTime;
            ResultSet resultSet = new ResultSet(totalTime, timeCollectingData, timeEvaluatingConditions, evaluatingCount == 0 ? 0L : timeEvaluatingConditions / (long)evaluatingCount.intValue(), timeFormattingData, formattingCount == 0 ? 0L : timeFormattingData / (long)formattingCount.intValue(), timeAggregatingData, presentFields, result);
            result = resultSet;
            for (Queryable queryable : this.unions) {
                result.addAll(queryable.evaluate(dataSource, consumer));
            }
        }
        return result;
    }

    private Collection<? extends Joinable> resolveDynamicResource(QueryDynamicResource resource, Queryable.DataSource<Joinable> dataSource, Queryable.Consumer<Joinable> consumer) {
        Collection<Joinable> data = resource.getQuery().evaluate(dataSource, consumer);
        if (resource.getPath() != null && !resource.getPath().isBlank()) {
            Collection resultPath = this.resolveResourcePath(data, resource.getPath());
            data = new ArrayList<Joinable>();
            for (Object dataObject : resultPath) {
                data.add(new JoinableMap(Introspection.toMap(dataObject), new String[0]));
            }
        }
        return data;
    }

    private Collection resolveResourcePath(Collection resultSet, String path) {
        ArrayList result = new ArrayList();
        for (Object row : resultSet) {
            Object pathValue = Introspection.resolve(row, path);
            if (pathValue == null) continue;
            if (pathValue instanceof Collection) {
                result.addAll((Collection)pathValue);
                continue;
            }
            result.add(pathValue);
        }
        return result;
    }

    private Queryable verifyInstance(Query query, Queryable.Consumer consumer) {
        Queryable result = query;
        if (consumer instanceof ParameterizedQuery.ParameterizedConsumer && ((ParameterizedQuery.ParameterizedConsumer)consumer).getParameters().size() > 0) {
            ParameterizedQuery parameterizedQuery = query.getParameterizedQuery();
            for (Object parameter : ((ParameterizedQuery.ParameterizedConsumer)consumer).getParameters()) {
                parameterizedQuery.add(parameter);
            }
            result = parameterizedQuery;
        }
        return result;
    }

    public final boolean verifyCondition(Object object) {
        Queryable.IntrospectionConsumer consumer = new Queryable.IntrospectionConsumer();
        List<Object> collection = List.of(object);
        return this.verifyCondition(object, Q -> collection, consumer);
    }

    public final boolean verifyCondition(Object object, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        Boolean result = true;
        for (Evaluator evaluator : this.getEvaluators()) {
            if (!(evaluator instanceof BooleanEvaluator && ((BooleanEvaluator)evaluator).getValue() instanceof QueryParameter && ((QueryParameter)((BooleanEvaluator)evaluator).getValue()).isUnderlying() || this.isEvaluatorDone(evaluator) || (result = Boolean.valueOf(result & evaluator.evaluate(object, dataSource, consumer))).booleanValue())) break;
        }
        return result;
    }

    private boolean isEvaluatorDone(Evaluator evaluator) {
        List evaluatorsCache;
        boolean result = false;
        Object session = ServiceSession.getCurrentSession();
        if (session != null && (evaluatorsCache = (List)((ServiceSession)session).getProperties().get(SystemProperties.get("hcjf.query.evaluators.cache"))) != null) {
            result = evaluatorsCache.contains(evaluator);
        }
        return result;
    }

    private void initializeEvaluatorsCache() {
        Object session = ServiceSession.getCurrentIdentity();
        if (session != null) {
            ((ServiceSession)session).put(SystemProperties.get("hcjf.query.evaluators.cache"), new ArrayList());
            ((ServiceSession)session).put(SystemProperties.get("hcjf.query.evaluator.left.values.cache"), new HashMap());
            ((ServiceSession)session).put(SystemProperties.get("hcjf.query.evaluator.right.values.cache"), new HashMap());
        }
    }

    private void clearEvaluatorsCache() {
        Object session = ServiceSession.getCurrentIdentity();
        if (session != null) {
            ((ServiceSession)session).remove(SystemProperties.get("hcjf.query.evaluators.cache"));
            ((ServiceSession)session).remove(SystemProperties.get("hcjf.query.evaluator.left.values.cache"));
            ((ServiceSession)session).remove(SystemProperties.get("hcjf.query.evaluator.right.values.cache"));
        }
    }

    public static void skipEvaluator(Evaluator evaluator) {
        List evaluatorsCache;
        Object session = ServiceSession.getCurrentSession();
        if (session != null && (evaluatorsCache = (List)((ServiceSession)session).getProperties().get(SystemProperties.get("hcjf.query.evaluators.cache"))) != null) {
            evaluatorsCache.add(evaluator);
        }
    }

    private void copyEvaluators(EvaluatorCollection dest, EvaluatorCollection src) {
        for (Evaluator evaluator : src.getEvaluators()) {
            if (evaluator instanceof FieldEvaluator) {
                dest.addEvaluator(((FieldEvaluator)evaluator).copy());
                continue;
            }
            if (evaluator instanceof BooleanEvaluator) {
                QueryFunction queryFunction;
                BooleanEvaluator booleanEvaluator = (BooleanEvaluator)evaluator;
                if (!(booleanEvaluator.getValue() instanceof QueryFunction) || !(queryFunction = (QueryFunction)booleanEvaluator.getValue()).isUnderlying()) continue;
                dest.addEvaluator(evaluator);
                continue;
            }
            if (evaluator instanceof And) {
                this.copyEvaluators(dest.and(), (EvaluatorCollection)((Object)evaluator));
                continue;
            }
            if (!(evaluator instanceof Or)) continue;
            this.copyEvaluators(dest.or(), (EvaluatorCollection)((Object)evaluator));
        }
    }

    private Collection<? extends Joinable> setResource(Collection<? extends Joinable> resultSet, String resourceName) {
        for (Joinable joinable : resultSet) {
            if (!(joinable instanceof JoinableMap)) continue;
            ((JoinableMap)joinable).setResource(resourceName);
        }
        return resultSet;
    }

    private Collection<? extends Joinable> join(Queryable.DataSource<Joinable> dataSource, Queryable.Consumer<Joinable> consumer) {
        Query query = new Query(this.getResource());
        query.addReturnField(SystemProperties.get("hcjf.query.return.all.reserved.word"));
        for (Evaluator evaluator : this.getEvaluatorsFromResource(this, query, query.getResource())) {
            query.addEvaluator(evaluator);
        }
        Collection<? extends Joinable> leftData = this.getJoinData(query, dataSource, consumer);
        for (Join join : this.getJoins()) {
            query = new Query(join.getResource());
            query.addReturnField(SystemProperties.get("hcjf.query.return.all.reserved.word"));
            for (Evaluator evaluator : this.optimizeJoin(leftData, join)) {
                query.addEvaluator(evaluator);
            }
            for (Evaluator evaluator : this.getEvaluatorsFromResource(this, query, join.getResource())) {
                query.addEvaluator(evaluator);
            }
            Collection<? extends Joinable> rightData = this.getJoinData(query, dataSource, consumer);
            leftData = this.product(leftData, rightData, join, dataSource, consumer);
        }
        return leftData;
    }

    private Collection<? extends Joinable> getJoinData(Query query, Queryable.DataSource<Joinable> dataSource, Queryable.Consumer<Joinable> consumer) {
        Collection<? extends Joinable> result = query.getResource() instanceof QueryDynamicResource ? this.resolveDynamicResource((QueryDynamicResource)query.getResource(), dataSource, consumer) : (this.getResource() instanceof QueryJsonResource ? ((QueryJsonResource)this.getResource()).getResourceValues() : dataSource.getResourceData(this.verifyInstance(query, consumer)));
        return this.setResource(result, query.getResourceName());
    }

    private Collection<Evaluator> optimizeJoin(Collection<? extends Joinable> leftData, Join join) {
        Equals equals;
        ArrayList<Evaluator> result = new ArrayList<Evaluator>();
        if ((join.getType().equals((Object)Join.JoinType.JOIN) || join.getType().equals((Object)Join.JoinType.INNER) || join.getType().equals((Object)Join.JoinType.LEFT)) && join.getEvaluators().size() == 1 && join.getEvaluators().stream().findFirst().get() instanceof Equals && (equals = (Equals)join.getEvaluators().stream().findFirst().get()).getLeftValue() instanceof QueryField && equals.getRightValue() instanceof QueryField) {
            QueryField foreignKey = null;
            QueryField key = null;
            if (!((QueryField)equals.getLeftValue()).getResource().equals(join.getResource()) && ((QueryField)equals.getRightValue()).getResource().equals(join.getResource())) {
                foreignKey = (QueryField)equals.getLeftValue();
                key = (QueryField)equals.getRightValue();
            } else if (!((QueryField)equals.getRightValue()).getResource().equals(join.getResource()) && ((QueryField)equals.getLeftValue()).getResource().equals(join.getResource())) {
                foreignKey = (QueryField)equals.getRightValue();
                key = (QueryField)equals.getLeftValue();
            }
            if (foreignKey != null) {
                HashSet reducerList = new HashSet();
                for (Joinable joinable : leftData) {
                    Object foreignKeyValue = Introspection.resolve((Object)joinable, foreignKey.getFieldPath());
                    if (foreignKeyValue == null) continue;
                    reducerList.add(foreignKeyValue);
                }
                In inEvaluator = new In(key, reducerList);
                result.add(inEvaluator);
            }
        }
        return result;
    }

    private Collection<Joinable> product(Collection<? extends Joinable> left, Collection<? extends Joinable> right, Join join, Queryable.DataSource<? extends Joinable> dataSource, Queryable.Consumer<? extends Joinable> consumer) {
        ArrayList<Joinable> leftCopy = null;
        ArrayList<Joinable> rightCopy = null;
        switch (join.getType()) {
            case LEFT: {
                leftCopy = new ArrayList<Joinable>();
                leftCopy.addAll(left);
                break;
            }
            case RIGHT: {
                rightCopy = new ArrayList<Joinable>();
                rightCopy.addAll(right);
                break;
            }
            case FULL: {
                leftCopy = new ArrayList();
                leftCopy.addAll(left);
                rightCopy = new ArrayList();
                rightCopy.addAll(right);
            }
        }
        ArrayList<Joinable> result = new ArrayList<Joinable>();
        for (Joinable joinable : left) {
            for (Joinable joinable2 : right) {
                Evaluator evaluator;
                Joinable row = joinable.join(this.getResourceName(), join.getResourceName(), joinable2);
                Boolean rowEvaluation = false;
                Iterator<Evaluator> iterator = join.getEvaluators().iterator();
                while (iterator.hasNext() && (rowEvaluation = Boolean.valueOf((evaluator = iterator.next()).evaluate(row, dataSource, consumer))).booleanValue()) {
                }
                if (join.getOuter().booleanValue()) {
                    rowEvaluation = rowEvaluation == false;
                }
                if (!rowEvaluation.booleanValue()) continue;
                result.add(row);
                switch (join.getType()) {
                    case LEFT: {
                        leftCopy.remove(joinable);
                        break;
                    }
                    case RIGHT: {
                        rightCopy.remove(joinable2);
                        break;
                    }
                    case FULL: {
                        leftCopy.remove(joinable);
                        rightCopy.remove(joinable2);
                    }
                }
            }
        }
        switch (join.getType()) {
            case LEFT: {
                result.addAll(leftCopy);
                break;
            }
            case RIGHT: {
                result.addAll(rightCopy);
                break;
            }
            case FULL: {
                result.addAll(leftCopy);
                result.addAll(rightCopy);
            }
        }
        return result;
    }

    private List<Evaluator> getEvaluatorsFromResource(EvaluatorCollection collection, EvaluatorCollection parent, QueryResource resource) {
        ArrayList<Evaluator> result = new ArrayList<Evaluator>();
        for (Evaluator evaluator : collection.getEvaluators()) {
            QueryParameter queryParameter;
            if (evaluator instanceof FieldEvaluator) {
                FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
                boolean evaluatorAdded = false;
                if (fieldEvaluator.getLeftValue() instanceof QueryParameter && (queryParameter = (QueryParameter)fieldEvaluator.getLeftValue()).verifyResource(resource)) {
                    result.add(evaluator);
                    evaluatorAdded = true;
                }
                if (evaluatorAdded || !(fieldEvaluator.getRightValue() instanceof QueryParameter) || !(queryParameter = (QueryParameter)fieldEvaluator.getRightValue()).verifyResource(resource)) continue;
                result.add(evaluator);
                continue;
            }
            if (evaluator instanceof BooleanEvaluator) {
                if (!(((BooleanEvaluator)evaluator).getValue() instanceof QueryParameter) || !(queryParameter = (QueryParameter)((BooleanEvaluator)evaluator).getValue()).verifyResource(resource)) continue;
                result.add(evaluator);
                continue;
            }
            if (!(evaluator instanceof EvaluatorCollection)) continue;
            EvaluatorCollection subCollection = null;
            if (evaluator instanceof And) {
                subCollection = new And(parent);
            } else if (evaluator instanceof Or) {
                subCollection = new Or(parent);
            }
            for (Evaluator subEvaluator : this.getEvaluatorsFromResource((EvaluatorCollection)((Object)evaluator), subCollection, resource)) {
                subCollection.addEvaluator(subEvaluator);
            }
        }
        return result;
    }

    public final Query reduce(Collection<Evaluator> evaluatorsToRemove) {
        Query copy = new Query(this);
        copy.evaluators.addAll(this.evaluators);
        if (evaluatorsToRemove != null && !evaluatorsToRemove.isEmpty()) {
            this.reduceCollection(copy, evaluatorsToRemove);
        }
        return copy;
    }

    public final Query reduceFieldEvaluator(String fieldName, Class<? extends FieldEvaluator> ... evaluatorType) {
        return this.reduce(this.getFieldEvaluators(fieldName, evaluatorType));
    }

    private final void reduceCollection(EvaluatorCollection collection, Collection<Evaluator> evaluatorsToRemove) {
        for (Evaluator evaluatorToRemove : evaluatorsToRemove) {
            collection.removeEvaluator(evaluatorToRemove);
            collection.addEvaluator(new TrueEvaluator());
        }
        for (Evaluator evaluator : collection.getEvaluators()) {
            if (!(evaluator instanceof Or) && !(evaluator instanceof And)) continue;
            this.reduceCollection((EvaluatorCollection)((Object)evaluator), evaluatorsToRemove);
        }
    }

    public String toString(String serializerName) {
        QuerySerializer querySerializer = Layers.get(QuerySerializer.class, serializerName);
        return querySerializer.serialize(this);
    }

    public String toString() {
        return this.toString(SystemProperties.get("hcjf.query.default.serializer"));
    }

    public static Collection<JoinableMap> evaluate(String query) {
        return Query.evaluate(Query.compile(query));
    }

    public static Collection<JoinableMap> evaluate(Queryable queryable) {
        return queryable.evaluate(new Queryable.ReadableDataSource());
    }

    public static <O> O evaluate(UUID uuid) {
        String resourceName = NamedUuid.getName(uuid);
        IdentifiableLayerInterface identifiableLayerInterface = Layers.get(IdentifiableLayerInterface.class, resourceName);
        return identifiableLayerInterface.read(uuid);
    }

    public static Query compile(String queryDefinition) {
        return Query.compile(queryDefinition, SystemProperties.get("hcjf.query.default.compiler"));
    }

    public static Query compile(String queryDefinition, String compilerName) {
        QueryCompiler queryCompiler = Layers.get(QueryCompiler.class, compilerName);
        return queryCompiler.compile(queryDefinition);
    }

    @Override
    public BsonDocument toBson() {
        BsonDocument document = new BsonDocument();
        document.put("__pcn__", (Object)this.getClass().getName());
        document.put(QUERY_BSON_FIELD_NAME, (Object)this.toString());
        return document;
    }

    @Override
    public <P extends BsonParcelable> P populate(BsonDocument document) {
        return (P)this;
    }

    public boolean equals(Object obj) {
        return obj instanceof Query && obj.toString().equals(this.toString());
    }

    static {
        Layers.publishLayer(SQLCompiler.class);
        Layers.publishLayer(JsonCompiler.class);
        Layers.publishLayer(SQLSerializer.class);
        Layers.publishLayer(MathQueryFunctionLayer.class);
        Layers.publishLayer(StringQueryFunctionLayer.class);
        Layers.publishLayer(DateQueryFunctionLayer.class);
        Layers.publishLayer(ReferenceFunctionLayer.class);
        Layers.publishLayer(BsonQueryFunctionLayer.class);
        Layers.publishLayer(CollectionQueryFunction.class);
        Layers.publishLayer(ObjectQueryFunction.class);
        Layers.publishLayer(QueryBsonBuilderLayer.class);
        Layers.publishLayer(GeoQueryFunctionLayer.class);
        Layers.publishLayer(ShellQueryFunction.class);
        Layers.publishLayer(CountQueryAggregateFunctionLayer.class);
        Layers.publishLayer(SumAggregateFunctionLayer.class);
        Layers.publishLayer(ProductAggregateFunctionLayer.class);
        Layers.publishLayer(MeanAggregateFunctionLayer.class);
        Layers.publishLayer(MaxAggregateFunctionLayer.class);
        Layers.publishLayer(MinAggregateFunctionLayer.class);
        Layers.publishLayer(DistinctQueryAggregateFunction.class);
        Layers.publishLayer(GeoUnionAggregateFunctionLayer.class);
        Layers.publishLayer(GeoDistanceAggregateFunctionLayer.class);
        Layers.publishLayer(EvalExpressionAggregateFunctionLayer.class);
        Layers.publishLayer(ContextAggregateFunction.class);
        Layers.publishLayer(PutAggregateFunction.class);
        Layers.publishLayer(AddAggregateFunction.class);
    }
}

