/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.compilers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layer;
import org.hcjf.layers.query.Join;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.compilers.QueryCompiler;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.model.QueryDynamicResource;
import org.hcjf.layers.query.model.QueryJsonResource;
import org.hcjf.layers.query.model.QueryOrderParameter;
import org.hcjf.layers.query.model.QueryResource;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.JsonUtils;

public class JsonCompiler
extends Layer
implements QueryCompiler {
    private static final String NAME = "json";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    public Query compile(String queryExpression) {
        Map queryModel = (Map)JsonUtils.createObject(queryExpression);
        return this.compile(queryModel);
    }

    private Query compile(Map<String, Object> queryModel) {
        Collection orderParameters;
        Collection joins;
        Collection evaluators;
        Object from = Introspection.resolve(queryModel, "from");
        Query query = new Query(this.createResource(from));
        query.setEnvironment((Map)Introspection.resolve(queryModel, "environment"));
        Collection fields = (Collection)Introspection.resolve(queryModel, "fields");
        if (fields != null) {
            for (Object fieldBody : fields) {
                query.addReturnField(this.createQueryReturnParameter(query, fieldBody));
            }
        }
        if ((evaluators = (Collection)Introspection.resolve(queryModel, "where")) != null) {
            for (Object evaluatorBody : evaluators) {
                query.addEvaluator(this.createEvaluator(query, evaluatorBody));
            }
        }
        if ((joins = (Collection)Introspection.resolve(queryModel, "join")) != null) {
            for (Object joinModel : joins) {
                query.addJoin(this.createJoin(query, joinModel));
            }
        }
        Collection groupFields = null;
        if (queryModel.containsKey("groupBy")) {
            groupFields = (Collection)Introspection.resolve(queryModel, "fields");
        } else if (queryModel.containsKey("disjoint")) {
            groupFields = (Collection)Introspection.resolve(queryModel, "disjoint");
            query.setDisjoint(true);
        }
        if (groupFields != null) {
            for (Object groupBody : groupFields) {
                query.addGroupField(this.createQueryReturnParameter(query, groupBody));
            }
        }
        if ((orderParameters = (Collection)Introspection.resolve(queryModel, "orderBy")) != null) {
            for (Object order : orderParameters) {
                query.addOrderParameter(this.createQueryOrderParameter(query, order));
            }
        }
        if (queryModel.containsKey("start")) {
            query.setStart((Integer)Introspection.resolve(queryModel, "start"));
        }
        if (queryModel.containsKey("underlyingStart")) {
            query.setUnderlyingStart((Integer)Introspection.resolve(queryModel, "underlyingStart"));
        }
        if (queryModel.containsKey("limit")) {
            query.setLimit((Integer)Introspection.resolve(queryModel, "limit"));
        }
        if (queryModel.containsKey("underlyingLimit")) {
            query.setUnderlyingLimit((Integer)Introspection.resolve(queryModel, "underlyingLimit"));
        }
        return query;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryResource createResource(Object from) {
        ArrayList<Map<String, Object>> collection;
        if (from == null) throw new HCJFRuntimeException("The 'from' is not present into query model.", new Object[0]);
        if (from instanceof String) {
            return new QueryResource((String)from);
        }
        if (!(from instanceof Map)) throw new HCJFRuntimeException("Incompatible resource type %s expected resource name or resource object", new Object[0]);
        Map body = (Map)from;
        String alias = (String)Introspection.resolve((Object)body, "as");
        if (alias == null) throw new HCJFRuntimeException("For complex resource the alias is required", new Object[0]);
        if (alias.isBlank()) {
            throw new HCJFRuntimeException("For complex resource the alias is required", new Object[0]);
        }
        if (body.containsKey("query")) {
            Map subQueryModel = (Map)Introspection.resolve((Object)"query", new String[0]);
            String path = (String)Introspection.resolve((Object)"path", new String[0]);
            Query subQuery = this.compile(subQueryModel);
            return new QueryDynamicResource(alias, subQuery, path);
        }
        if (!body.containsKey("data")) throw new HCJFRuntimeException("", new Object[0]);
        Object data = Introspection.resolve((Object)"data", new String[0]);
        if (data instanceof Map) {
            collection = new ArrayList<Map>();
            collection.add((Map)data);
            return new QueryJsonResource(alias, collection);
        } else {
            if (!(data instanceof Collection)) throw new HCJFRuntimeException("", new Object[0]);
            collection = (Collection)data;
        }
        return new QueryJsonResource(alias, collection);
    }

    private QueryReturnParameter createQueryReturnParameter(Query query, Object fieldBody) {
        QueryReturnParameter result = null;
        if (fieldBody instanceof Map) {
            // empty if block
        }
        return result;
    }

    private Evaluator createEvaluator(Query query, Object evaluatorBody) {
        return null;
    }

    private Join createJoin(Query query, Object joinBody) {
        return null;
    }

    private QueryOrderParameter createQueryOrderParameter(Query query, Object orderBody) {
        return null;
    }

    public static final class Fields {
        public static final String ENVIRONMENT = "environment";
        public static final String FIELDS = "fields";
        public static final String FROM = "from";
        public static final String WHERE = "where";
        public static final String JOIN = "join";
        public static final String GROUP_BY = "groupBy";
        public static final String DISJOINT = "disjoint";
        public static final String ORDER_BY = "orderBy";
        public static final String START = "start";
        public static final String UNDERLYING_START = "underlyingStart";
        public static final String LIMIT = "limit";
        public static final String UNDERLYING_LIMIT = "underlyingLimit";
        public static final String AS = "as";
        public static final String QUERY = "query";
        public static final String DATA = "data";
        public static final String PATH = "path";
        public static final String FUNCTION = "function";
        public static final String PARAMETERS = "parameters";
    }
}

