/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.bson.BsonArray;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonElement;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.properties.SystemProperties;

public class BsonQueryFunctionLayer
extends BaseQueryFunctionLayer {
    private static final String BSON_PARSE = "bsonParse";

    public BsonQueryFunctionLayer() {
        super(SystemProperties.get("hcjf.query.function.bson.name"));
        this.addFunctionName(BSON_PARSE);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Map<String, Object> result = null;
        switch (functionName) {
            case "bsonParse": {
                result = this.createMap(BsonDecoder.decode((byte[])((byte[])this.getParameter(0, parameters))));
            }
        }
        return result;
    }

    private Map<String, Object> createMap(BsonDocument document) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map bsonMap = (Map)document.getValue();
        for (String name : bsonMap.keySet()) {
            BsonElement element = document.get(name);
            if (element instanceof BsonDocument) {
                result.put(name, this.createMap((BsonDocument)element));
                continue;
            }
            if (element instanceof BsonArray) {
                result.put(name, this.createList((BsonArray)element));
                continue;
            }
            result.put(name, element.getValue());
        }
        return result;
    }

    private List<Object> createList(BsonArray array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < array.getLength(); ++i) {
            BsonElement element = array.get(Integer.valueOf(i));
            if (element instanceof BsonDocument) {
                result.add(this.createMap((BsonDocument)element));
                continue;
            }
            if (element instanceof BsonArray) {
                result.add(this.createList((BsonArray)element));
                continue;
            }
            result.add(element.getValue());
        }
        return result;
    }
}

