/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hcjf.errors.HCJFRemoteException;
import org.hcjf.layers.Layers;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.scripting.CodeEvaluator;
import org.hcjf.layers.scripting.ExecutionResult;

public class ShellQueryFunction
extends BaseQueryFunctionLayer {
    private static final String PARAMETER_PATTERN = "_p%d";
    private static final String STATEMENT_PATTERN = "return %s;";
    private static final String NAME = "shell";

    public ShellQueryFunction() {
        super(NAME);
        this.addFunctionName("java");
        this.addFunctionName("js");
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        if (parameters.length == 0) {
            throw new HCJFRemoteException("The shell function expected at list one parameter, the script to evaluate", new Object[0]);
        }
        if (!(parameters[0] instanceof String)) {
            throw new HCJFRemoteException("The shell function expected the first parameter as script to evaluate", new Object[0]);
        }
        String script = (String)parameters[0];
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        for (int i = 1; i < parameters.length; ++i) {
            Iterator parameter = parameters[i];
            if (parameter instanceof Map) {
                parametersMap.putAll((Map)((Object)parameter));
                continue;
            }
            parametersMap.put(String.format(PARAMETER_PATTERN, i), parameter);
        }
        ArrayList keys = new ArrayList(parametersMap.keySet());
        for (String key : keys) {
            if (!(parametersMap.get(key) instanceof Enum)) continue;
            parametersMap.remove(key);
        }
        CodeEvaluator codeEvaluator = Layers.get(CodeEvaluator.class, functionName);
        ExecutionResult result = codeEvaluator.evaluate(String.format(STATEMENT_PATTERN, script), parametersMap);
        return result.getResult();
    }

    private static final class Functions {
        private static final String JAVA = "java";
        private static final String JS = "js";

        private Functions() {
        }
    }
}

