/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.model;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryResource;

public class QueryFunction
extends QueryParameter {
    private final String functionName;
    private final List<Object> parameters;

    public QueryFunction(Query query, String originalFunction, String functionName, List<Object> parameters) {
        super(query, originalFunction, functionName);
        this.functionName = functionName;
        this.parameters = parameters;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public Set<QueryResource> getResources() {
        TreeSet<QueryResource> queryResources = new TreeSet<QueryResource>();
        for (Object parameter : this.parameters) {
            if (parameter instanceof QueryField) {
                queryResources.add(((QueryField)parameter).getResource());
                continue;
            }
            if (!(parameter instanceof QueryFunction)) continue;
            queryResources.addAll(((QueryFunction)parameter).getResources());
        }
        return queryResources;
    }

    @Override
    public boolean verifyResource(QueryResource resource) {
        return this.getResources().contains(resource);
    }
}

