/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.model;

import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.model.QueryComponent;
import org.hcjf.layers.query.model.QueryResource;

public abstract class QueryParameter
implements Comparable<QueryParameter>,
QueryComponent {
    private final Query container;
    private QueryResource resource;
    private String fieldPath;
    private final String originalValue;
    private final boolean underlying;

    public QueryParameter(Query query, String originalValue, String value) {
        this.container = query;
        this.originalValue = originalValue.trim();
        String cleanValue = value;
        if (cleanValue.startsWith("@")) {
            cleanValue = value.substring(1);
            this.underlying = true;
        } else {
            this.underlying = false;
        }
        this.resource = QueryResource.ANY;
        if (cleanValue.contains(".")) {
            boolean resourceNameFounded = false;
            for (QueryResource queryResource : query.getResources()) {
                if (!originalValue.startsWith(queryResource.getResourceName() + ".")) continue;
                this.resource = queryResource;
                resourceNameFounded = true;
                break;
            }
            this.fieldPath = resourceNameFounded ? cleanValue.substring(this.resource.getResourceName().length() + 1) : cleanValue;
        } else {
            this.fieldPath = cleanValue;
        }
    }

    protected Query getContainer() {
        return this.container;
    }

    public QueryResource getResource() {
        return this.resource;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String toString() {
        return this.originalValue;
    }

    @Override
    public boolean isUnderlying() {
        return this.underlying;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(QueryParameter o) {
        return this.toString().compareTo(o.toString());
    }

    public abstract boolean verifyResource(QueryResource var1);
}

