/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceThread;
import org.hcjf.service.security.Grants;

public class ServiceSession
implements Comparable {
    private static final String DEFAULT_TIME_ZONE = "UTC";
    private static final SystemSession SYSTEM_SESSION;
    private static final ServiceSession GUEST_SESSION;
    private static final List<ServiceSessionSource> sources;
    private final UUID id;
    private String sessionName;
    private final Map<Long, List<LayerStackElement>> layerStack;
    private final Map<Long, Map<String, Object>> properties;
    private final Map<Long, Long> systemTimeByThread;
    private final ThreadMXBean threadMXBean;
    private final List<ServiceSession> identities;
    private final Set<Grants.Grant> grants;
    private Locale locale;
    private String timezone;

    public ServiceSession(UUID id) {
        this.id = id;
        this.properties = new HashMap<Long, Map<String, Object>>();
        this.layerStack = Collections.synchronizedMap(new HashMap());
        this.systemTimeByThread = new HashMap<Long, Long>();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.locale = SystemProperties.getLocale();
        this.identities = new ArrayList<ServiceSession>();
        this.grants = new HashSet<Grants.Grant>();
        this.timezone = DEFAULT_TIME_ZONE;
    }

    protected ServiceSession(ServiceSession serviceSession) {
        this.id = serviceSession.id;
        this.sessionName = serviceSession.sessionName;
        this.properties = new HashMap<Long, Map<String, Object>>();
        this.layerStack = Collections.synchronizedMap(new HashMap());
        this.systemTimeByThread = new HashMap<Long, Long>();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.locale = serviceSession.locale;
        this.identities = new ArrayList<ServiceSession>();
        this.grants = new HashSet<Grants.Grant>();
        this.grants.addAll(serviceSession.grants);
        this.timezone = serviceSession.timezone;
    }

    public static void runAs(Runnable runnable, ServiceSession newIdentity) {
        boolean addIdentity = ((ServiceSession)ServiceSession.getCurrentSession()).addIdentity(newIdentity);
        try {
            runnable.run();
        }
        finally {
            if (addIdentity) {
                ((ServiceSession)ServiceSession.getCurrentSession()).removeIdentity();
            }
        }
    }

    public static <O> O callAs(Callable<O> callable, ServiceSession newIdentity) {
        boolean addIdentity = ((ServiceSession)ServiceSession.getCurrentSession()).addIdentity(newIdentity);
        try {
            O o = callable.call();
            return o;
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("Call as exception", (Throwable)ex, new Object[0]);
        }
        finally {
            if (addIdentity) {
                ((ServiceSession)ServiceSession.getCurrentSession()).removeIdentity();
            }
        }
    }

    private final boolean addIdentity(ServiceSession serviceSession) {
        boolean result = false;
        if (serviceSession != null && !serviceSession.equals(ServiceSession.getCurrentIdentity())) {
            this.identities.add(0, serviceSession);
            return true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeIdentity() {
        List<ServiceSession> list = this.identities;
        synchronized (list) {
            if (!this.identities.isEmpty()) {
                this.identities.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <S extends ServiceSession> S currentIdentity() {
        ServiceSession result = this;
        List<ServiceSession> list = this.identities;
        synchronized (list) {
            if (!this.identities.isEmpty()) {
                result = this.identities.get(0);
            }
        }
        return (S)result;
    }

    public final UUID getId() {
        return this.id;
    }

    public final void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public final String getSessionName() {
        return this.sessionName;
    }

    public final synchronized void startThread() {
        this.systemTimeByThread.put(Thread.currentThread().getId(), this.threadMXBean.getCurrentThreadCpuTime());
        this.layerStack.put(Thread.currentThread().getId(), new ArrayList());
        this.properties.put(Thread.currentThread().getId(), new HashMap());
        this.onStartThread();
    }

    protected void onStartThread() {
    }

    public final synchronized void endThread() {
        this.layerStack.remove(Thread.currentThread().getId());
        this.properties.remove(Thread.currentThread().getId());
        this.onEndThread();
        this.addThreadTime(this.threadMXBean.getCurrentThreadCpuTime() - this.systemTimeByThread.remove(Thread.currentThread().getId()));
    }

    protected void onEndThread() {
    }

    public final Map<String, Object> getProperties() {
        Map<String, Object> result = null;
        if (((ServiceSession)ServiceSession.getCurrentSession()).properties.containsKey(Thread.currentThread().getId())) {
            result = Collections.unmodifiableMap(((ServiceSession)ServiceSession.getCurrentSession()).properties.get(Thread.currentThread().getId()));
        }
        return result;
    }

    public final void putAll(Map<String, Object> properties) {
        ((ServiceSession)ServiceSession.getCurrentSession()).properties.get(Thread.currentThread().getId()).putAll(properties);
    }

    public final void put(String propertyName, Object propertyValue) {
        ((ServiceSession)ServiceSession.getCurrentSession()).properties.get(Thread.currentThread().getId()).put(propertyName, propertyValue);
    }

    public final <O> O get(String propertyName) {
        return (O)((ServiceSession)ServiceSession.getCurrentSession()).properties.get(Thread.currentThread().getId()).get(propertyName);
    }

    public final <O> O remove(String propertyName) {
        return (O)((ServiceSession)ServiceSession.getCurrentSession()).properties.remove(propertyName);
    }

    public final void putLayer(LayerStackElement element) {
        ((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()).add(0, element);
    }

    public final void removeLayer() {
        ((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()).remove(0);
    }

    public final Collection<LayerStackElement> getLayerStack() {
        return Collections.unmodifiableCollection((Collection)((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()));
    }

    public final LayerStackElement getCurrentLayer() {
        LayerStackElement result = null;
        if (((ServiceSession)ServiceSession.getCurrentSession()).layerStack.containsKey(Thread.currentThread().getId()) && ((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()).size() > 0) {
            result = ((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()).get(0);
        }
        return result;
    }

    public final LayerStackElement getInvokerLayer() {
        LayerStackElement result = null;
        if (((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()).size() > 1) {
            result = ((ServiceSession)ServiceSession.getCurrentSession()).layerStack.get(Thread.currentThread().getId()).get(1);
        }
        return result;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    protected void addThreadTime(long time) {
    }

    public void addIngressPackage(long size) {
    }

    public void addEgressPackage(long size) {
    }

    public final void addGrant(Grants.Grant grant) {
        this.grants.add(grant);
    }

    public final void removeGrant(Grants.Grant grant) {
        this.grants.remove(grant);
    }

    public final Set<Grants.Grant> getGrants() {
        return Collections.unmodifiableSet(this.grants);
    }

    public final boolean containsGrant(String grantId) {
        Grants.Grant grant;
        boolean result = false;
        Iterator<Grants.Grant> iterator = this.grants.iterator();
        while (iterator.hasNext() && !(result = (grant = iterator.next()).getPermissionId().equals(grantId))) {
        }
        return result;
    }

    public final boolean isSystemSession() {
        return this.equals(ServiceSession.getSystemSession());
    }

    public final boolean isGuestSession() {
        return this.equals(ServiceSession.getGuestSession());
    }

    public final int compareTo(Object object) {
        int result = this.hashCode() - object.hashCode();
        if (this.getClass().equals(object.getClass())) {
            ServiceSession otherSession = (ServiceSession)object;
            if (this.getId().equals(otherSession.getId())) {
                result = 0;
            }
        }
        return result;
    }

    public final boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ServiceSession) {
            result = ((ServiceSession)obj).getId().equals(this.getId());
        }
        return result;
    }

    public ServiceSession getClone() {
        return new ServiceSession(this);
    }

    public static void addServiceSessionSource(ServiceSessionSource source) {
        Objects.requireNonNull(source, "Unable to add null source");
        sources.add(source);
    }

    public static <S extends ServiceSession> S findSession(UUID sessionId) {
        ServiceSession result = null;
        if (sessionId.equals(ServiceSession.getSystemSession().getId())) {
            result = ServiceSession.getSystemSession();
        } else if (sessionId.equals(ServiceSession.getGuestSession().getId())) {
            result = ServiceSession.getGuestSession();
        } else {
            ServiceSessionSource source;
            Iterator<ServiceSessionSource> iterator = sources.iterator();
            while (iterator.hasNext() && (result = (source = iterator.next()).findSession(sessionId)) == null) {
            }
        }
        return (S)result;
    }

    public static <S extends ServiceSession> S findSession(Map<String, Object> sessionBean) {
        ServiceSessionSource source;
        S result = null;
        Iterator<ServiceSessionSource> iterator = sources.iterator();
        while (iterator.hasNext() && (result = (S)(source = iterator.next()).findSession(sessionBean)) == null) {
        }
        return result;
    }

    public static final ServiceSession getSystemSession() {
        return SYSTEM_SESSION;
    }

    public static final ServiceSession getGuestSession() {
        return GUEST_SESSION;
    }

    public static final <S extends ServiceSession> S getCurrentSession() {
        Thread currentThread = Thread.currentThread();
        if (ServiceThread.class.isAssignableFrom(currentThread.getClass())) {
            return (S)((ServiceThread)currentThread).getSession();
        }
        throw new IllegalStateException("The current thread is not a service thread.");
    }

    public static final <S extends ServiceSession> S getCurrentIdentity() {
        Thread currentThread = Thread.currentThread();
        if (ServiceThread.class.isAssignableFrom(currentThread.getClass())) {
            return ((ServiceThread)currentThread).getSession() == null ? null : (S)((ServiceThread)currentThread).getSession().currentIdentity();
        }
        throw new IllegalStateException("The current thread is not a service thread.");
    }

    public Map<String, Object> getBody() {
        Map<String, Object> result = null;
        Boolean next = false;
        if (!((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            for (ServiceSession serviceSession : ((ServiceSession)ServiceSession.getCurrentSession()).identities) {
                if (next.booleanValue()) {
                    result = serviceSession.getBody();
                    break;
                }
                if (!serviceSession.equals(this)) continue;
                next = true;
            }
            if (result == null) {
                result = ((ServiceSession)ServiceSession.getCurrentSession()).getBody();
            }
        } else {
            result = Map.of();
        }
        return result;
    }

    static {
        GUEST_SESSION = new GuestSession();
        SYSTEM_SESSION = new SystemSession();
        sources = new ArrayList<ServiceSessionSource>();
    }

    public static interface ServiceSessionSource {
        public <S extends ServiceSession> S findSession(UUID var1);

        public <S extends ServiceSession> S findSession(Map<String, Object> var1);
    }

    public static final class LayerStackElement {
        private final Class<? extends Layer> layerClass;
        private final String implName;
        private final boolean plugin;
        private final boolean stateful;

        public LayerStackElement(Class<? extends Layer> layerClass, String implName, boolean plugin, boolean stateful) {
            this.layerClass = layerClass;
            this.implName = implName;
            this.plugin = plugin;
            this.stateful = stateful;
        }

        public Class<? extends Layer> getLayerClass() {
            return this.layerClass;
        }

        public String getImplName() {
            return this.implName;
        }

        public boolean isPlugin() {
            return this.plugin;
        }

        public boolean isStateful() {
            return this.stateful;
        }
    }

    private static class GuestSession
    extends ServiceSession {
        public GuestSession() {
            super(new UUID(0L, 1L));
            this.setSessionName(SystemProperties.get("hcjf.service.guest.session.name"));
        }
    }

    private static class SystemSession
    extends ServiceSession {
        public SystemSession() {
            super(new UUID(0L, 0L));
            this.setSessionName(SystemProperties.get("hcjf.service.system.session.name"));
        }
    }
}

