/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hcjf.properties.SystemProperties;

public class LruMap<K, V>
implements Map<K, V> {
    private Integer maxSize;
    private final List<Key<K>> keys = new ArrayList<Key<K>>();
    private final Map<K, Key<K>> metadata = new HashMap<K, Key<K>>();
    private final Map<K, V> mapInstance = new HashMap();
    private final List<RemoveOverflowListener<K, V>> listeners;

    public LruMap() {
        this(SystemProperties.getInteger("hcjf.default.lru.map.size"));
    }

    public LruMap(Integer maxSize) {
        this.maxSize = maxSize;
        this.listeners = new ArrayList<RemoveOverflowListener<K, V>>();
    }

    public final void addRemoveOverflowListener(RemoveOverflowListener<K, V> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public final Integer getMaxSize() {
        return this.maxSize;
    }

    public final synchronized void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        this.removeOverflow();
    }

    private void updateMetadata(Key<K> ... keys) {
        for (Key<K> key : keys) {
            key.update();
        }
        Collections.sort(this.keys);
    }

    private void removeOverflow() {
        for (int i = 0; i < this.keys.size() - this.maxSize; ++i) {
            Key key = this.keys.remove(this.keys.size() - 1);
            this.metadata.remove(key.getKey());
            Object value = this.mapInstance.remove(key.getKey());
            this.listeners.forEach((? super T L) -> L.onRemove(key.getKey(), value));
        }
    }

    @Override
    public int size() {
        return this.mapInstance.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapInstance.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapInstance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapInstance.containsValue(value);
    }

    @Override
    public synchronized V get(Object key) {
        V result = null;
        if (this.mapInstance.containsKey(key)) {
            this.updateMetadata(this.metadata.get(key));
            result = this.mapInstance.get(key);
        }
        return result;
    }

    @Override
    public synchronized V put(K key, V value) {
        V result = this.mapInstance.put(key, value);
        Key<K> temporalKey = new Key<K>(key);
        this.keys.add(temporalKey);
        this.metadata.put(key, temporalKey);
        this.updateMetadata(new Key[0]);
        this.removeOverflow();
        return result;
    }

    @Override
    public synchronized V remove(Object key) {
        V result = this.mapInstance.remove(key);
        this.keys.remove(this.metadata.remove(key));
        this.updateMetadata(new Key[0]);
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        this.mapInstance.putAll(m);
        for (K key : m.keySet()) {
            Key<K> temporalKey = new Key<K>(key);
            this.keys.add(temporalKey);
            this.metadata.put(key, temporalKey);
        }
        this.updateMetadata(new Key[0]);
        this.removeOverflow();
    }

    @Override
    public synchronized void clear() {
        this.mapInstance.clear();
        this.metadata.clear();
        this.keys.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mapInstance.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mapInstance.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mapInstance.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.mapInstance.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mapInstance.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.mapInstance.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.mapInstance.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.mapInstance.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.mapInstance.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.mapInstance.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.mapInstance.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.mapInstance.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.mapInstance.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.mapInstance.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.mapInstance.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mapInstance.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public static interface RemoveOverflowListener<K, V> {
        public void onRemove(K var1, V var2);
    }

    private static final class Key<K>
    implements Comparable<Key> {
        private final K key;
        private Long lastUpdate;

        public Key(K key) {
            this.key = key;
            this.lastUpdate = System.currentTimeMillis();
        }

        public K getKey() {
            return this.key;
        }

        public void update() {
            this.lastUpdate = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof Key) {
                result = this.key.equals(((Key)obj).key);
            }
            return result;
        }

        public String toString() {
            return this.key.toString();
        }

        @Override
        public int compareTo(Key o) {
            return this.lastUpdate.compareTo(o.lastUpdate) * -1;
        }
    }
}

