/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class NamedUuid {
    private static final Map<Integer, String> names = new HashMap<Integer, String>();
    private final UUID id;
    private final Integer hash;

    private NamedUuid(UUID id, Integer hash) {
        this.id = id;
        this.hash = hash;
    }

    public static void registerName(String name) {
        names.put(name.hashCode(), name);
    }

    public static String getName(UUID uuid) {
        if (uuid.version() == 5) {
            return names.get((int)uuid.getLeastSignificantBits());
        }
        throw new IllegalArgumentException("Only for uuid version 5");
    }

    public UUID getId() {
        return this.id;
    }

    public Integer getHash() {
        return this.hash;
    }

    public static NamedUuid create(UUID uuid) {
        return new NamedUuid(uuid, (int)uuid.getLeastSignificantBits());
    }

    public static NamedUuid create(String name) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SHA-1 not supported");
        }
        md.update(NamedUuid.toBytes(UUID.randomUUID()));
        md.update(name.getBytes());
        byte[] sha1Bytes = md.digest();
        sha1Bytes[6] = (byte)(sha1Bytes[6] & 0xF);
        sha1Bytes[6] = (byte)(sha1Bytes[6] | 0x50);
        sha1Bytes[8] = (byte)(sha1Bytes[8] & 0x3F);
        sha1Bytes[8] = (byte)(sha1Bytes[8] | 0x80);
        int hashCode = name.hashCode();
        ByteBuffer hashBuffer = ByteBuffer.allocate(4);
        hashBuffer.putInt(hashCode);
        hashBuffer.rewind();
        sha1Bytes[12] = hashBuffer.get();
        sha1Bytes[13] = hashBuffer.get();
        sha1Bytes[14] = hashBuffer.get();
        sha1Bytes[15] = hashBuffer.get();
        return new NamedUuid(NamedUuid.fromBytes(sha1Bytes), hashCode);
    }

    private static UUID fromBytes(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length >= 16);
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static byte[] toBytes(UUID uuid) {
        int i;
        byte[] out = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        for (i = 0; i < 8; ++i) {
            out[i] = (byte)(msb >> (7 - i) * 8 & 0xFFL);
        }
        for (i = 8; i < 16; ++i) {
            out[i] = (byte)(lsb >> (15 - i) * 8 & 0xFFL);
        }
        return out;
    }

    public String toString() {
        return this.id.toString();
    }
}

