/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.hcjf.cloud.impl.network.CloudOrchestrator;

public final class LockImpl
implements Lock {
    private static final String LOCK_NAME = "__lock__";
    private static final String DEFAULT_CONDITION_NAME = "__default_condition_name__";
    private final String name;
    private final Map<String, ConditionImpl> conditionMap;
    private long lockedId;

    public LockImpl(String name) {
        this.name = name;
        this.conditionMap = new HashMap<String, ConditionImpl>();
        CloudOrchestrator.getInstance().publishPath(Lock.class.getName(), name);
    }

    @Override
    public void lock() {
        CloudOrchestrator.getInstance().lock(Lock.class.getName(), this.name, LOCK_NAME);
        this.lockedId = Thread.currentThread().getId();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlock() {
        this.lockedId = -1L;
        CloudOrchestrator.getInstance().unlock(Lock.class.getName(), this.name, LOCK_NAME);
    }

    @Override
    public Condition newCondition() {
        return this.newCondition(DEFAULT_CONDITION_NAME);
    }

    public synchronized Condition newCondition(String conditionName) {
        ConditionImpl result = this.conditionMap.get(conditionName);
        if (result == null) {
            result = new ConditionImpl(this, conditionName);
            this.conditionMap.put(conditionName, result);
        }
        return result;
    }

    public static final class ConditionImpl
    implements Condition {
        private final LockImpl lock;
        private final String name;

        private ConditionImpl(LockImpl lock, String name) {
            this.lock = lock;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await() throws InterruptedException {
            if (Thread.currentThread().getId() == this.lock.lockedId) {
                CloudOrchestrator.getInstance().unlock(Lock.class.getName(), this.lock.name, LockImpl.LOCK_NAME);
                ConditionImpl conditionImpl = this;
                synchronized (conditionImpl) {
                    this.wait();
                }
            } else {
                throw new IllegalMonitorStateException();
            }
            CloudOrchestrator.getInstance().lock(Lock.class.getName(), this.lock.name, LockImpl.LOCK_NAME);
        }

        @Override
        public void awaitUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            this.await(nanosTimeout, TimeUnit.NANOSECONDS);
            return nanosTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            long startTime;
            if (Thread.currentThread().getId() == this.lock.lockedId) {
                CloudOrchestrator.getInstance().unlock(Lock.class.getName(), this.lock.name, LockImpl.LOCK_NAME);
                startTime = System.currentTimeMillis();
                ConditionImpl conditionImpl = this;
                synchronized (conditionImpl) {
                    unit.timedWait(this, time);
                }
            } else {
                throw new IllegalMonitorStateException();
            }
            boolean result = System.currentTimeMillis() - startTime >= unit.toMillis(time);
            CloudOrchestrator.getInstance().lock(Lock.class.getName(), this.lock.name, LockImpl.LOCK_NAME);
            return result;
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            boolean result = false;
            long time = deadline.getTime() - System.currentTimeMillis();
            if (time > 0L) {
                result = this.await(time, TimeUnit.MILLISECONDS);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signal() {
            ConditionImpl conditionImpl = this;
            synchronized (conditionImpl) {
                this.notify();
            }
            CloudOrchestrator.getInstance().signal(this.lock.name, this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signalAll() {
            ConditionImpl conditionImpl = this;
            synchronized (conditionImpl) {
                this.notifyAll();
            }
            CloudOrchestrator.getInstance().signalAll(this.lock.name, this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void distributedSignal() {
            ConditionImpl conditionImpl = this;
            synchronized (conditionImpl) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void distributedSignalAll() {
            ConditionImpl conditionImpl = this;
            synchronized (conditionImpl) {
                this.notifyAll();
            }
        }
    }
}

