/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.hcjf.cloud.impl.network.CloudOrchestrator;
import org.hcjf.cloud.impl.objects.DistributedTree;

public class QueueImpl<O>
implements Queue<O> {
    private final String name;

    public QueueImpl(String name) {
        this.name = name;
        CloudOrchestrator.getInstance().publishPath(Queue.class.getName(), name);
    }

    @Override
    public int size() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        return tree.size();
    }

    @Override
    public boolean isEmpty() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        return tree.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        Boolean result = false;
        for (Object key : tree.keySet()) {
            result = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, key).equals(o);
            if (!result.booleanValue()) continue;
            break;
        }
        return result;
    }

    @Override
    public Iterator<O> iterator() {
        final DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        return new Iterator<O>(){
            Set keySet;
            Iterator iterator;
            {
                this.keySet = Set.of(tree.keySet());
                this.iterator = this.keySet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public O next() {
                return CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), QueueImpl.this.name, this.iterator.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        Object[] result = new Object[tree.size()];
        int i = 0;
        for (Object key : tree.keySet()) {
            result[i++] = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, key);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public boolean add(O value) {
        CloudOrchestrator.getInstance().publishObject(value, System.currentTimeMillis(), Queue.class.getName(), this.name, this.createKey());
        return true;
    }

    @Override
    public boolean remove(Object o) {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        Boolean result = false;
        for (Object key : tree.keySet()) {
            result = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, key).equals(o);
            CloudOrchestrator.getInstance().hidePath(Queue.class.getName(), this.name, key);
            if (!result.booleanValue()) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        for (Object object : c) {
            if (!(result &= this.contains(object))) break;
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends O> c) {
        boolean result = true;
        for (O object : c) {
            result &= this.add(object);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = true;
        for (Object object : c) {
            result &= this.remove(object);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (Object object : c) {
            if (this.contains(object)) continue;
            this.remove(object);
            result = true;
        }
        return result;
    }

    @Override
    public void clear() {
        DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
        for (Object key : tree.keySet()) {
            CloudOrchestrator.getInstance().hidePath(Queue.class.getName(), this.name, key);
        }
    }

    @Override
    public boolean offer(O o) {
        return this.add(o);
    }

    @Override
    public O remove() {
        if (this.size() > 0) {
            DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
            TreeSet keys = new TreeSet();
            keys.addAll(tree.keySet());
            Object result = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, keys.first());
            CloudOrchestrator.getInstance().hidePath(Queue.class.getName(), this.name, keys.first());
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public O poll() {
        O result = null;
        if (this.size() > 0) {
            DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
            TreeSet keys = new TreeSet();
            keys.addAll(tree.keySet());
            result = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, keys.first());
            CloudOrchestrator.getInstance().hidePath(Queue.class.getName(), this.name, keys.first());
        }
        return result;
    }

    @Override
    public O element() {
        if (this.size() > 0) {
            DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
            TreeSet keys = new TreeSet();
            keys.addAll(tree.keySet());
            Object result = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, keys.first());
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public O peek() {
        O result = null;
        if (this.size() > 0) {
            DistributedTree tree = (DistributedTree)CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name);
            TreeSet keys = new TreeSet();
            keys.addAll(tree.keySet());
            result = CloudOrchestrator.getInstance().invokeNode(Queue.class.getName(), this.name, keys.first());
        }
        return result;
    }

    private String createKey() {
        return Long.toString(System.currentTimeMillis()) + Long.toString(System.nanoTime());
    }
}

