/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.encoding.MimeType;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.RequestBodyDecoderLayer;
import org.hcjf.layers.Layer;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Bytes;

public class MultipartFormDataDecoder
extends Layer
implements RequestBodyDecoderLayer {
    private static final String NAME_FIELD = "name";
    private static final String FILE_NAME_FIELD = "filename";
    private static final String FIELDS_SEPARATOR = ";";
    private static final String BOUNDARY_START = "--";

    public MultipartFormDataDecoder() {
        super("multipart/form-data");
    }

    @Override
    public Map<String, Object> decode(HttpRequest request) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HttpHeader contentType = request.getHeader("Content-Type");
        String boundary = BOUNDARY_START + contentType.getParameter("multipart/form-data", "boundary");
        MimeType mimeType = null;
        String name = null;
        String fileName = null;
        for (byte[] part : Bytes.split(request.getBody(), boundary.getBytes())) {
            byte[] file;
            if (part.length == 0) continue;
            if (Arrays.equals(part, BOUNDARY_START.getBytes())) break;
            mimeType = null;
            name = null;
            fileName = null;
            List<Integer> indexes = Bytes.allIndexOf(part, "\r\n".getBytes());
            String charset = null;
            Integer startIndex = 0;
            for (Integer index : indexes) {
                byte[] line = new byte[index - startIndex];
                System.arraycopy(part, startIndex, line, 0, line.length);
                String stringLine = new String(line).trim();
                if (stringLine.isEmpty()) {
                    startIndex = index + "\r\n".getBytes().length;
                    continue;
                }
                if (stringLine.startsWith("Content-Disposition")) {
                    HttpHeader lineContentDisposition = new HttpHeader(stringLine);
                    for (String headerPart : lineContentDisposition.getHeaderValue().split(FIELDS_SEPARATOR)) {
                        if (headerPart.trim().startsWith(NAME_FIELD)) {
                            name = headerPart.substring(headerPart.indexOf("=") + 1).trim().replace("\"", "");
                        }
                        if (!headerPart.trim().startsWith(FILE_NAME_FIELD)) continue;
                        fileName = headerPart.substring(headerPart.indexOf("=") + 1).trim().replace("\"", "");
                    }
                    startIndex = index + "\r\n".getBytes().length;
                    continue;
                }
                if (stringLine.startsWith("Content-Type")) {
                    HttpHeader lineContentType = new HttpHeader(stringLine);
                    mimeType = MimeType.fromString(lineContentType.getHeaderValue());
                    startIndex = index + "\r\n".getBytes().length;
                    charset = contentType.getParameter(contentType.getGroups().iterator().next(), "charset");
                    continue;
                }
                if (!stringLine.trim().isEmpty()) continue;
                break;
            }
            if (charset == null) {
                charset = SystemProperties.getDefaultCharset();
            }
            if (name == null) continue;
            if (part.length - startIndex >= "\r\n".getBytes().length) {
                file = new byte[part.length - startIndex - "\r\n".getBytes().length];
                System.arraycopy(part, startIndex, file, 0, file.length);
            } else {
                file = new byte[]{};
            }
            if (fileName != null) {
                ArrayList<HttpRequest.AttachFile> attachFiles;
                HttpRequest.AttachFile attachFile = new HttpRequest.AttachFile(name, fileName, mimeType == null ? MimeType.APPLICATION_X_BINARY : mimeType, file);
                if (parameters.containsKey(name) && parameters.get(name) instanceof ArrayList) {
                    attachFiles = (ArrayList<HttpRequest.AttachFile>)parameters.get(name);
                    attachFiles.add(attachFile);
                    continue;
                }
                if (parameters.containsKey(name) && parameters.get(name) instanceof HttpRequest.AttachFile) {
                    attachFiles = new ArrayList<HttpRequest.AttachFile>();
                    attachFiles.add((HttpRequest.AttachFile)parameters.get(name));
                    attachFiles.add(attachFile);
                    parameters.put(name, attachFiles);
                    continue;
                }
                parameters.put(name, attachFile);
                continue;
            }
            String value = new String(file);
            try {
                parameters.put(name, URLDecoder.decode(value, charset));
            }
            catch (UnsupportedEncodingException e) {
                Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Unable to decode http parameter, %s:%s", name, value);
                parameters.put(name, value);
            }
        }
        return parameters;
    }
}

