/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.datasources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.http.datasources.DataSourceServiceConsumer;
import org.hcjf.layers.query.Query;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.utils.Strings;

public final class DataSourceService
extends Service<DataSourceServiceConsumer> {
    private static final String THREAD_POOL_NAME = "DATA_SOURCE_THREAD_POOL";
    private static final DataSourceService instance = new DataSourceService();
    private final ThreadPoolExecutor serviceExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(this.createThreadFactory());

    private DataSourceService() {
        super(SystemProperties.get("hcjf.net.http.data.sources.service.name"), SystemProperties.getInteger("hcjf.net.http.data.sources.service.priority"));
        this.serviceExecutor.setCorePoolSize(SystemProperties.getInteger("hcjf.service.thread.pool.core.size"));
        this.serviceExecutor.setMaximumPoolSize(SystemProperties.getInteger("hcjf.service.thread.pool.max.size"));
        this.serviceExecutor.setKeepAliveTime(SystemProperties.getLong("hcjf.service.thread.pool.keep.alive.time"), TimeUnit.SECONDS);
    }

    public static DataSourceService getInstance() {
        return instance;
    }

    @Override
    public void registerConsumer(DataSourceServiceConsumer consumer) {
        Map<String, Object> rawDataSources = consumer.getRawDataSources();
        HashMap<String, Object> dataSourcesMap = new HashMap<String, Object>();
        Boolean threadPoolEnabled = SystemProperties.getBoolean("hcjf.net.http.data.sources.service.thread.pool.enabled");
        if (threadPoolEnabled.booleanValue()) {
            this.fork(() -> {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (String dataSourceName : rawDataSources.keySet()) {
                    futures.add(this.fork(() -> this.resolveDataSource(dataSourceName, rawDataSources.get(dataSourceName), dataSourcesMap), THREAD_POOL_NAME, this.serviceExecutor));
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (Exception ex) {
                        consumer.setThrowable(ex);
                        break;
                    }
                }
                consumer.setResult(dataSourcesMap);
            }, THREAD_POOL_NAME, this.serviceExecutor);
        } else {
            for (String dataSourceName : rawDataSources.keySet()) {
                try {
                    this.resolveDataSource(dataSourceName, rawDataSources.get(dataSourceName), dataSourcesMap);
                }
                catch (Exception ex) {
                    consumer.setThrowable(ex);
                    break;
                }
            }
            consumer.setResult(dataSourcesMap);
        }
    }

    private void resolveDataSource(String dataSourceName, Object dataSource, Map<String, Object> dataSourcesMap) {
        if (dataSource instanceof String) {
            try {
                Query queryable = Query.compile((String)dataSource);
                dataSourcesMap.put(dataSourceName, Query.evaluate(queryable));
            }
            catch (Exception e) {
                throw new HCJFRuntimeException(Strings.createTaggedMessage(String.format("Error resolving data source %s", dataSourceName), "DATA_SOURCE"), (Throwable)e, new Object[0]);
            }
        } else if (dataSource instanceof List) {
            dataSourcesMap.put(dataSourceName, dataSource);
        } else if (dataSource instanceof Map) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(dataSource);
            dataSourcesMap.put(dataSourceName, list);
        }
    }

    @Override
    public void unregisterConsumer(DataSourceServiceConsumer consumer) {
    }
}

