/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.http2.frames;

import java.nio.ByteBuffer;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.http.http2.frames.ContinuationFrame;
import org.hcjf.io.net.http.http2.frames.DataFrame;
import org.hcjf.io.net.http.http2.frames.GoAwayFrame;
import org.hcjf.io.net.http.http2.frames.HeadersFrame;
import org.hcjf.io.net.http.http2.frames.PingFrame;
import org.hcjf.io.net.http.http2.frames.PriorityFrame;
import org.hcjf.io.net.http.http2.frames.PushPromiseFrame;
import org.hcjf.io.net.http.http2.frames.RstStreamFrame;
import org.hcjf.io.net.http.http2.frames.SettingsFrame;
import org.hcjf.io.net.http.http2.frames.WindowsUpdateFrame;

public abstract class Http2Frame {
    public static final Integer FRAME_HEADER_LENGTH = 9;
    private Integer id;
    private Byte flags;
    private Integer length;
    private Type type;
    private ByteBuffer payload;

    protected Http2Frame(Integer id, Byte flags, Integer length, Type type) {
        this.id = id;
        this.flags = flags;
        this.length = length;
        this.type = type;
        this.payload = ByteBuffer.allocate(length);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Byte getFlags() {
        return this.flags;
    }

    public void setFlags(Byte flags) {
        this.flags = flags;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ByteBuffer getPayload() {
        return this.payload;
    }

    public final void setPayload(ByteBuffer payload) {
        this.payload = payload;
        this.processPayload();
    }

    public final ByteBuffer serialize() {
        this.length = this.recalculateLength();
        ByteBuffer fixedBuffer = ByteBuffer.allocate(this.getLength() + FRAME_HEADER_LENGTH);
        byte[] lengthBytes = ByteBuffer.allocate(4).putInt(this.getLength()).array();
        for (int i = 1; i < 4; ++i) {
            fixedBuffer.put(lengthBytes[i]);
        }
        fixedBuffer.put(this.getType().id);
        fixedBuffer.put(this.getFlags());
        fixedBuffer.putInt(this.getId());
        return this.serializePayload(fixedBuffer);
    }

    protected abstract Integer recalculateLength();

    protected abstract void processPayload();

    protected abstract ByteBuffer serializePayload(ByteBuffer var1);

    public static enum Error {
        NO_ERROR(0),
        PROTOCOL_ERROR(1),
        INTERNAL_ERROR(2),
        FLOW_CONTROL_ERROR(3),
        SETTINGS_TIMEOUT(4),
        STREAM_CLOSED(5),
        FRAME_SIZE_ERROR(6),
        REFUSED_STREAM(7),
        CANCEL(8),
        COMPRESSION_ERROR(9),
        CONNECT_ERROR(10),
        ENHANCE_YOUR_CALM(11),
        INADEQUATE_SECURITY(12),
        HTTP_1_1_REQUIRED(13);

        private final byte id;

        private Error(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    protected static enum Type {
        DATA(DataFrame.class, 0),
        HEADERS(HeadersFrame.class, 1),
        PRIORITY(PriorityFrame.class, 2),
        RST_STREAM(RstStreamFrame.class, 3),
        SETTINGS(SettingsFrame.class, 4),
        PUSH_PROMISE(PushPromiseFrame.class, 5),
        PING(PingFrame.class, 6),
        GO_AWAY(GoAwayFrame.class, 7),
        WINDOW_UPDATE(WindowsUpdateFrame.class, 8),
        CONTINUATION(ContinuationFrame.class, 9);

        private final Class<? extends Http2Frame> frameClass;
        private final byte id;

        private Type(Class<? extends Http2Frame> frameClass, byte id) {
            this.frameClass = frameClass;
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static Class<? extends Http2Frame> getClassById(byte id) {
            Class<? extends Http2Frame> result = null;
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                result = type.frameClass;
            }
            return result;
        }
    }

    public static final class Builder {
        public static <F extends Http2Frame> F build(Integer id, Byte flags, Integer length, Byte type) {
            Class<? extends Http2Frame> frameClass = Type.getClassById(type);
            if (frameClass == null) {
                throw new HCJFRuntimeException("Frame type not found: %d", type);
            }
            try {
                return (F)frameClass.getConstructor(Integer.class, Byte.class, Integer.class).newInstance(id, flags, length);
            }
            catch (Exception e) {
                throw new HCJFRuntimeException("Unable to create frame instance", new Object[0]);
            }
        }
    }
}

