/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.http2.frames;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.io.net.http.http2.frames.Http2Frame;

public class SettingsFrame
extends Http2Frame {
    private static final Integer SETTING_PAYLOAD_LENGTH = 6;
    private Map<Short, Integer> settings = new HashMap<Short, Integer>();
    private List<Short> order;

    public SettingsFrame(Integer id, Byte flags, Integer length) {
        super(id, flags, length, Http2Frame.Type.SETTINGS);
    }

    public SettingsFrame(Integer id, Byte flags, SettingsFrame settingsFrame) {
        super(id, flags, settingsFrame.getLength(), Http2Frame.Type.SETTINGS);
        this.settings.putAll(settingsFrame.settings);
        this.order = new ArrayList<Short>();
        this.order.addAll(settingsFrame.order);
    }

    public static SettingsFrame createDefaultSettingsFrame(Integer id) {
        SettingsFrame settingsFrame = new SettingsFrame(id, (Byte)0, 1);
        settingsFrame.setMaxHeaderListSize(Settings.SETTINGS_MAX_HEADER_LIST_SIZE.getDefaultValue());
        settingsFrame.setMaxConcurrentStreams(Settings.SETTINGS_MAX_CONCURRENT_STREAMS.getDefaultValue());
        settingsFrame.setMaxFrameSize(Settings.SETTINGS_MAX_FRAME_SIZE.getDefaultValue());
        settingsFrame.setInitialWindowsSize(Settings.SETTINGS_INITIAL_WINDOW_SIZE.getDefaultValue());
        settingsFrame.setHeaderTableSize(Settings.SETTINGS_HEADER_TABLE_SIZE.getDefaultValue());
        return settingsFrame;
    }

    @Override
    protected Integer recalculateLength() {
        Integer length = this.settings.size() * SETTING_PAYLOAD_LENGTH;
        return length;
    }

    @Override
    protected void processPayload() {
        this.order = new ArrayList<Short>();
        ByteBuffer payload = this.getPayload();
        while (payload.limit() > payload.position()) {
            Short settingId = (short)((payload.get() & 0xF) << 8 | payload.get() & 0xFF);
            Integer settingValue = (payload.get() & 0xFF) << 24 | (payload.get() & 0xFF) << 16 | (payload.get() & 0xFF) << 8 | payload.get() & 0xFF;
            this.setSetting(settingId, settingValue);
            this.order.add(settingId);
        }
        System.out.println();
    }

    @Override
    protected ByteBuffer serializePayload(ByteBuffer fixedBuffer) {
        if (this.order != null) {
            for (Short id : this.order) {
                fixedBuffer.putShort(id);
                fixedBuffer.putInt(this.settings.get(id));
            }
        } else {
            for (Short id : this.settings.keySet()) {
                fixedBuffer.putShort(id);
                fixedBuffer.putInt(this.settings.get(id));
            }
        }
        return fixedBuffer;
    }

    private void setSetting(Short id, Integer value) {
        this.settings.put(id, value);
    }

    public Integer getHeaderTableSize() {
        return this.settings.get(Settings.SETTINGS_HEADER_TABLE_SIZE.id);
    }

    public void setHeaderTableSize(Integer headerTableSize) {
        this.settings.put(Settings.SETTINGS_HEADER_TABLE_SIZE.id, headerTableSize);
    }

    public Integer getEnablePush() {
        return this.settings.get(Settings.SETTINGS_ENABLE_PUSH.id);
    }

    public void setEnablePush(Integer enablePush) {
        this.settings.put(Settings.SETTINGS_ENABLE_PUSH.id, enablePush);
    }

    public Integer getMaxConcurrentStreams() {
        return this.settings.get(Settings.SETTINGS_MAX_CONCURRENT_STREAMS.id);
    }

    public void setMaxConcurrentStreams(Integer maxConcurrentStreams) {
        this.settings.put(Settings.SETTINGS_MAX_CONCURRENT_STREAMS.id, maxConcurrentStreams);
    }

    public Integer getInitialWindowsSize() {
        return this.settings.get(Settings.SETTINGS_INITIAL_WINDOW_SIZE.id);
    }

    public void setInitialWindowsSize(Integer initialWindowsSize) {
        this.settings.put(Settings.SETTINGS_INITIAL_WINDOW_SIZE.id, initialWindowsSize);
    }

    public Integer getMaxFrameSize() {
        return this.settings.get(Settings.SETTINGS_MAX_FRAME_SIZE.id);
    }

    public void setMaxFrameSize(Integer maxFrameSize) {
        this.settings.put(Settings.SETTINGS_MAX_FRAME_SIZE.id, maxFrameSize);
    }

    public Integer getMaxHeaderListSize() {
        return this.settings.get(Settings.SETTINGS_MAX_HEADER_LIST_SIZE.id);
    }

    public void setMaxHeaderListSize(Integer maxHeaderListSize) {
        this.settings.put(Settings.SETTINGS_MAX_HEADER_LIST_SIZE.id, maxHeaderListSize);
    }

    public static enum Settings {
        SETTINGS_HEADER_TABLE_SIZE(1, 4096),
        SETTINGS_ENABLE_PUSH(2, 1),
        SETTINGS_MAX_CONCURRENT_STREAMS(3, 0),
        SETTINGS_INITIAL_WINDOW_SIZE(4, 65535),
        SETTINGS_MAX_FRAME_SIZE(5, 16384),
        SETTINGS_MAX_HEADER_LIST_SIZE(6, Integer.MAX_VALUE);

        private final short id;
        private final int defaultValue;

        private Settings(short id, int defaultValue) {
            this.id = id;
            this.defaultValue = defaultValue;
        }

        public short getId() {
            return this.id;
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }
    }
}

