/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.layered;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hcjf.io.net.http.Context;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.io.net.http.layered.LayeredRequest;
import org.hcjf.io.net.http.layered.LayeredResponse;
import org.hcjf.layers.LayerInterface;
import org.hcjf.layers.Layers;
import org.hcjf.utils.Strings;

public abstract class LayeredContext<L extends LayerInterface, P extends LayeredRequest, R extends LayeredResponse>
extends Context {
    private final List<String> endPointPath;

    public LayeredContext(String ... endPointPath) {
        super("^/" + Strings.join(Arrays.asList(endPointPath), "/") + ".*");
        this.endPointPath = Arrays.asList(endPointPath);
    }

    protected final L getLayerInterface(String implementationName) {
        Class implementationClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return Layers.get(implementationClass, implementationName);
    }

    protected final List<String> getEndPointPath() {
        return this.endPointPath;
    }

    protected final List<String> getResourcePath(HttpRequest request) {
        return request.getPathParts().stream().skip(this.getEndPointPath().size()).collect(Collectors.toList());
    }

    @Override
    public final HttpResponse onContext(HttpRequest request) {
        P layeredRequest = this.decode(request);
        return this.encode(this.onAction(layeredRequest), layeredRequest);
    }

    protected abstract R onAction(P var1);

    @Override
    protected HttpResponse onError(HttpRequest request, Throwable throwable) {
        HttpResponse result = new HttpResponse();
        result.setResponseCode(HttpResponseCode.INTERNAL_SERVER_ERROR);
        return result;
    }

    protected abstract P decode(HttpRequest var1);

    protected abstract HttpResponse encode(R var1, P var2);
}

