/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes;

import io.kubernetes.client.Metrics;
import io.kubernetes.client.custom.NodeMetrics;
import io.kubernetes.client.custom.NodeMetricsList;
import io.kubernetes.client.custom.PodMetrics;
import io.kubernetes.client.custom.PodMetricsList;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.BatchV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.V1ComponentStatus;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapEnvSource;
import io.kubernetes.client.openapi.models.V1ConfigMapVolumeSource;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EnvFromSource;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1LimitRange;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplate;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ResourceQuota;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretVolumeSource;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layer;
import org.hcjf.layers.crud.CreateLayerInterface;
import org.hcjf.layers.crud.ReadRowsLayerInterface;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Queryable;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Introspection;

public class KubernetesSpyResource
extends Layer
implements CreateLayerInterface<Map<String, Object>>,
ReadRowsLayerInterface {
    public static final String NAME = "system_k8s";
    public static final String CONFIG_MAP = "system_k8s_config_map";
    public static final String NAMESPACED_CONFIG_MAP = "system_k8s_namespaced_config_map";
    public static final String END_POINT = "system_k8s_end_point";
    public static final String NAMESPACED_END_POINT = "system_k8s_namespaced_end_point";
    public static final String EVENT = "system_k8s_event";
    public static final String NAMESPACED_EVENT = "system_k8s_namespaced_event";
    public static final String LIMIT_RANGE = "system_k8s_limit_range";
    public static final String NAMESPACE = "system_k8s_namespace";
    public static final String NODE = "system_k8s_node";
    public static final String PERSISTENT_VOLUME = "system_k8s_persistent_volume";
    public static final String PERSISTENT_VOLUME_CLAIM = "system_k8s_persistent_volume_claim";
    public static final String POD = "system_k8s_pod";
    public static final String NAMESPACED_POD = "system_k8s_namespaced_pod";
    public static final String POD_TEMPLATE = "system_k8s_pod_template";
    public static final String NAMESPACED_POD_TEMPLATE = "system_k8s_namespaced_pod_template";
    public static final String REPLICATION_CONTROLLER = "system_k8s_replication_controller";
    public static final String RESOURCE_QUOTA = "system_k8s_resource_quota";
    public static final String NAMESPACED_RESOURCE_QUOTA = "system_k8s_namespaced_resource_quota";
    public static final String SECRET = "system_k8s_secret";
    public static final String NAMESPACED_SECRET = "system_k8s_namespaced_secret";
    public static final String SERVICE_ACCOUNT = "system_k8s_service_account";
    public static final String NAMESPACED_SERVICE_ACCOUNT = "system_k8s_namespaced_service_account";
    public static final String SERVICE = "system_k8s_service";
    public static final String NAMESPACED_SERVICE = "system_k8s_namespaced_service";
    public static final String COMPONENT_STATUS = "system_k8s_component_status";
    public static final String POD_METRICS = "system_k8s_pod_metrics";
    public static final String NODE_METRICS = "system_k8s_node_metrics";
    private final ApiClient client;
    private final Metrics metrics;
    private final BatchV1Api batchApi;
    private final CoreV1Api api;

    public KubernetesSpyResource() {
        super(NAME);
        try {
            this.client = Config.fromCluster();
            this.metrics = new Metrics(this.client);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        Configuration.setDefaultApiClient((ApiClient)this.client);
        this.api = new CoreV1Api();
        this.batchApi = new BatchV1Api();
    }

    @Override
    public Set<String> getAliases() {
        return Set.of(CONFIG_MAP, NAMESPACED_CONFIG_MAP, END_POINT, NAMESPACED_END_POINT, EVENT, NAMESPACED_EVENT, LIMIT_RANGE, NAMESPACE, NODE, PERSISTENT_VOLUME, PERSISTENT_VOLUME_CLAIM, POD, NAMESPACED_POD, POD_TEMPLATE, NAMESPACED_POD_TEMPLATE, REPLICATION_CONTROLLER, RESOURCE_QUOTA, NAMESPACED_RESOURCE_QUOTA, SECRET, NAMESPACED_SECRET, SERVICE_ACCOUNT, NAMESPACED_SERVICE_ACCOUNT, SERVICE, NAMESPACED_SERVICE, COMPONENT_STATUS, POD_METRICS, NODE_METRICS);
    }

    @Override
    public Map<String, Object> create(Map<String, Object> object) {
        Map<String, Object> result;
        String kind;
        if (!object.containsKey("kind")) {
            throw new HCJFRuntimeException("Unable to create some kubernetes artifact if 'kind' field is not present", new Object[0]);
        }
        switch (kind = (String)object.get("kind")) {
            case "Job": {
                result = Introspection.toMap(this.createJob(object));
                break;
            }
            case "ConfigMap": {
                result = Introspection.toMap(this.createConfigMap(object));
                break;
            }
            default: {
                throw new HCJFRuntimeException("Unrecognized kubernetes artifact '%s'", kind);
            }
        }
        return result;
    }

    private V1Job createJob(Map<String, Object> jobDefinition) {
        V1Job job;
        try {
            job = new V1Job().apiVersion("batch/v1").kind((String)jobDefinition.get("kind")).metadata(new V1ObjectMeta().name((String)jobDefinition.get("name")).namespace(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"))).spec(new V1JobSpec().template(new V1PodTemplateSpec().metadata(new V1ObjectMeta().name((String)jobDefinition.get("name")).namespace(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"))).spec(new V1PodSpec().volumes(this.getVolumes((Collection)jobDefinition.get("volumes"))).restartPolicy((String)jobDefinition.get("restartPolicy")).containers(this.getContainers((Collection)jobDefinition.get("containers"))))));
            Integer replicas = (Integer)jobDefinition.get("replicas");
            for (int i = 0; i < replicas; ++i) {
                this.batchApi.createNamespacedJob(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), job, null, null, null, null);
            }
        }
        catch (ApiException ex) {
            throw new HCJFRuntimeException("Unable to create job, '%s'", (Throwable)ex, ex.getResponseBody());
        }
        return job;
    }

    private List<V1Container> getContainers(Collection<Map<String, Object>> definition) {
        ArrayList<V1Container> result = new ArrayList<V1Container>();
        if (definition != null) {
            for (Map<String, Object> container : definition) {
                result.add(new V1Container().envFrom(this.getEvnFromSources((Collection)container.get("environments"))).name((String)container.get("name")).image((String)container.get("image")).command((List)container.get("command")).args((List)container.get("args")).volumeMounts(this.getVolumeMounts((Collection)container.get("volumeMounts"))));
            }
        }
        return result;
    }

    private List<V1EnvFromSource> getEvnFromSources(Collection<Map<String, Object>> definition) {
        ArrayList<V1EnvFromSource> result = new ArrayList<V1EnvFromSource>();
        if (definition != null) {
            for (Map<String, Object> env : definition) {
                result.add(new V1EnvFromSource().configMapRef(new V1ConfigMapEnvSource().name((String)env.get("name"))));
            }
        }
        return result;
    }

    private List<V1VolumeMount> getVolumeMounts(Collection<Map<String, Object>> definition) {
        ArrayList<V1VolumeMount> result = new ArrayList<V1VolumeMount>();
        if (definition != null) {
            for (Map<String, Object> vm : definition) {
                result.add(new V1VolumeMount().name((String)vm.get("name")).mountPath((String)vm.get("mountPath")));
            }
        }
        return result;
    }

    private List<V1Volume> getVolumes(Collection<Map<String, Object>> definition) {
        ArrayList<V1Volume> result = new ArrayList<V1Volume>();
        if (definition != null) {
            for (Map<String, Object> v : definition) {
                if (v.containsKey("configMapName")) {
                    result.add(new V1Volume().name((String)v.get("name")).configMap(new V1ConfigMapVolumeSource().name((String)v.get("configMapName"))));
                    continue;
                }
                if (!v.containsKey("secretName")) continue;
                result.add(new V1Volume().name((String)v.get("name")).secret(new V1SecretVolumeSource().secretName((String)v.get("secretName"))));
            }
        }
        return result;
    }

    private V1ConfigMap createConfigMap(Map<String, Object> configMapDefinition) {
        V1ConfigMap configMap;
        try {
            configMap = new V1ConfigMap().apiVersion("v1").kind((String)configMapDefinition.get("kind")).metadata(new V1ObjectMeta().name((String)configMapDefinition.get("name")).namespace(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"))).data((Map)configMapDefinition.get("data"));
            this.api.createNamespacedConfigMap(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), configMap, null, null, null, null);
        }
        catch (ApiException ex) {
            throw new HCJFRuntimeException("Unable to create config map", (Throwable)ex, new Object[0]);
        }
        return configMap;
    }

    @Override
    public Collection<JoinableMap> readRows(Queryable queryable) {
        ArrayList<JoinableMap> result = new ArrayList<JoinableMap>();
        KubernetesBeanConsumer consumer = new KubernetesBeanConsumer();
        try {
            switch (queryable.getResourceName()) {
                case "system_k8s_config_map": {
                    for (V1ConfigMap configMap : this.api.listConfigMapForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(configMap, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_config_map": {
                    for (V1ConfigMap configMap : this.api.listNamespacedConfigMap(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(configMap, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_end_point": {
                    for (V1Endpoints endpoints : this.api.listEndpointsForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(endpoints, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_end_point": {
                    for (V1Endpoints endpoints : this.api.listNamespacedEndpoints(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(endpoints, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_event": {
                    for (CoreV1Event event : this.api.listEventForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(event, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_event": {
                    for (CoreV1Event event : this.api.listNamespacedEvent(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(event, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_limit_range": {
                    for (V1LimitRange limitRange : this.api.listNamespacedLimitRange(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(limitRange, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespace": {
                    for (V1Namespace namespace : this.api.listNamespace(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(namespace, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_node": {
                    for (V1Node node : this.api.listNode(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(node, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_persistent_volume": {
                    for (V1PersistentVolume persistentVolume : this.api.listPersistentVolume(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(persistentVolume, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_persistent_volume_claim": {
                    for (V1PersistentVolumeClaim persistentVolumeClaim : this.api.listNamespacedPersistentVolumeClaim(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(persistentVolumeClaim, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_pod": {
                    for (V1Pod pod : this.api.listPodForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(pod, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_pod": {
                    for (V1Pod pod : this.api.listNamespacedPod(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(pod, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_pod_template": {
                    for (V1PodTemplate podTemplate : this.api.listNamespacedPodTemplate(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(podTemplate, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_pod_template": {
                    for (V1PodTemplate podTemplate : this.api.listPodTemplateForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(podTemplate, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_replication_controller": {
                    for (V1ReplicationController replicationController : this.api.listNamespacedReplicationController(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(replicationController, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_resource_quota": {
                    for (V1ResourceQuota resourceQuota : this.api.listResourceQuotaForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(resourceQuota, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_resource_quota": {
                    for (V1ResourceQuota resourceQuota : this.api.listNamespacedResourceQuota(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(resourceQuota, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_secret": {
                    for (V1Secret secret : this.api.listSecretForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(secret, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_secret": {
                    for (V1Secret secret : this.api.listNamespacedSecret(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(secret, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_service_account": {
                    for (V1ServiceAccount serviceAccount : this.api.listServiceAccountForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(serviceAccount, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_service_account": {
                    for (V1ServiceAccount serviceAccount : this.api.listNamespacedServiceAccount(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(serviceAccount, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_service": {
                    for (V1Service service : this.api.listServiceForAllNamespaces(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(service, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_namespaced_service": {
                    for (V1Service service : this.api.listNamespacedService(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"), null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(service, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_component_status": {
                    for (V1ComponentStatus status : this.api.listComponentStatus(null, null, null, null, null, null, null, null, null, Boolean.valueOf(false)).getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(status, consumer), new String[0]));
                    }
                    break;
                }
                case "system_k8s_pod_metrics": {
                    PodMetricsList podMetricsList = this.metrics.getPodMetrics(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace"));
                    for (PodMetrics podMetrics : podMetricsList.getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(podMetrics), new String[0]));
                    }
                    break;
                }
                case "system_k8s_node_metrics": {
                    NodeMetricsList nodeMetricsList = this.metrics.getNodeMetrics();
                    for (NodeMetrics nodeMetrics : nodeMetricsList.getItems()) {
                        result.add(new JoinableMap(Introspection.toMap(nodeMetrics), new String[0]));
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Kubernetes resource error", ex);
        }
        return queryable.evaluate(result);
    }

    private static class KubernetesBeanConsumer
    implements Introspection.Consumer {
        private static final String K8S_PACKAGE_NAME = "io.kubernetes";

        private KubernetesBeanConsumer() {
        }

        @Override
        public Object consume(Object value) {
            ArrayList<Object> result;
            if (value.getClass().getPackage().getName().startsWith(K8S_PACKAGE_NAME)) {
                result = Introspection.toMap(value, this);
            } else if (value instanceof Collection) {
                ArrayList<Object> newCollection = new ArrayList<Object>();
                for (Object collectionValue : (Collection)value) {
                    newCollection.add(this.consume(collectionValue));
                }
                result = newCollection;
            } else {
                result = value;
            }
            return result;
        }
    }

    private static final class Fields {
        private static final String KIND = "kind";

        private Fields() {
        }

        private static final class EnvFromSource {
            private static final String KIND = "kind";
            private static final String NAME = "name";

            private EnvFromSource() {
            }
        }

        private static final class Container {
            private static final String NAME = "name";
            private static final String IMAGE = "image";
            private static final String COMMAND = "command";
            private static final String ARGS = "args";
            private static final String ENVIRONMENTS = "environments";
            private static final String VOLUME_MOUNTS = "volumeMounts";

            private Container() {
            }
        }

        private static final class VolumeMount {
            private static final String NAME = "name";
            private static final String MOUNT_PATH = "mountPath";

            private VolumeMount() {
            }
        }

        private static final class Volume {
            private static final String NAME = "name";
            private static final String CONFIG_MAP_NAME = "configMapName";
            private static final String SECRET_NAME = "secretName";

            private Volume() {
            }
        }

        private static final class Job {
            private static final String API_VERSION = "batch/v1";
            private static final String NAME = "name";
            private static final String REPLICAS = "replicas";
            private static final String RESTART_POLICY = "restartPolicy";
            private static final String CONTAINERS = "containers";
            private static final String VOLUMES = "volumes";

            private Job() {
            }
        }

        private static final class ConfigMap {
            private static final String API_VERSION = "v1";
            private static final String NAME = "name";
            private static final String DATA = "data";

            private ConfigMap() {
            }
        }
    }

    private static final class Kinds {
        private static final String JOB = "Job";
        private static final String CONFIG_MAP = "ConfigMap";

        private Kinds() {
        }
    }
}

