/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.plugins;

import java.util.ArrayList;
import java.util.List;
import org.hcjf.layers.Layer;
import org.hcjf.utils.Version;

public final class Plugin {
    private final String groupName;
    private final String name;
    private final Version version;
    private final List<Class<? extends Layer>> layers;

    public Plugin(String groupName, String name, Version version) {
        this.groupName = groupName;
        this.name = name;
        this.version = version;
        this.layers = new ArrayList<Class<? extends Layer>>();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void addLayer(Class<? extends Layer> layerClass) {
        this.layers.add(layerClass);
    }

    public List<Class<? extends Layer>> getLayers() {
        return this.layers;
    }

    public String toString() {
        return this.groupName + ", " + this.name + ", " + this.version.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Plugin) {
            result = this.groupName.equals(((Plugin)obj).groupName) && this.name.equals(((Plugin)obj).name);
        }
        return result;
    }
}

