/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.compilers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layer;
import org.hcjf.layers.query.Join;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.compilers.QueryCompiler;
import org.hcjf.layers.query.evaluators.And;
import org.hcjf.layers.query.evaluators.BaseEvaluator;
import org.hcjf.layers.query.evaluators.BooleanEvaluator;
import org.hcjf.layers.query.evaluators.Distinct;
import org.hcjf.layers.query.evaluators.Equals;
import org.hcjf.layers.query.evaluators.EvaluatorCollection;
import org.hcjf.layers.query.evaluators.GreaterThan;
import org.hcjf.layers.query.evaluators.GreaterThanOrEqual;
import org.hcjf.layers.query.evaluators.In;
import org.hcjf.layers.query.evaluators.Like;
import org.hcjf.layers.query.evaluators.NotIn;
import org.hcjf.layers.query.evaluators.Or;
import org.hcjf.layers.query.evaluators.SmallerThan;
import org.hcjf.layers.query.evaluators.SmallerThanOrEqual;
import org.hcjf.layers.query.model.QueryConditional;
import org.hcjf.layers.query.model.QueryDynamicResource;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryJsonResource;
import org.hcjf.layers.query.model.QueryOrderField;
import org.hcjf.layers.query.model.QueryOrderFunction;
import org.hcjf.layers.query.model.QueryOrderParameter;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryResource;
import org.hcjf.layers.query.model.QueryReturnConditional;
import org.hcjf.layers.query.model.QueryReturnField;
import org.hcjf.layers.query.model.QueryReturnFunction;
import org.hcjf.layers.query.model.QueryReturnLiteral;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.layers.query.model.QueryReturnUnprocessedValue;
import org.hcjf.layers.query.model.QueryTextResource;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.JsonUtils;
import org.hcjf.utils.Strings;

public final class SQLCompiler
extends Layer
implements QueryCompiler {
    private static final String NAME = "SQL";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    public Query compile(String queryExpression) {
        Query result = null;
        List<String> richTexts = Strings.groupRichText(queryExpression);
        List<String> groups = Strings.replaceableGroup(Strings.removeLines(richTexts.get(richTexts.size() - 1)));
        result = this.compile(groups, richTexts, groups.size() - 1, new AtomicInteger(0));
        return result;
    }

    public Query compileSingleQuery(String resourceName) {
        return this.compile(String.format(SystemProperties.get("hcjf.query.single.pattern"), resourceName));
    }

    private Query compile(List<String> groups, List<String> richTexts, Integer startGroup, AtomicInteger placesIndex) {
        Query query;
        String[] unions = groups.get(startGroup).split(SystemProperties.get("hcjf.query.union.regular.expression"));
        String queryDefinition = unions[0].trim();
        Pattern pattern = SystemProperties.getPattern("hcjf.query.select.regular.expression");
        Matcher matcher = pattern.matcher(queryDefinition);
        if (matcher.matches()) {
            String environmentBody = matcher.group(SystemProperties.get("hcjf.query.environment.group.index"));
            String selectBody = matcher.group(SystemProperties.get("hcjf.query.select.group.index"));
            selectBody = selectBody.replaceFirst("(?i)" + SystemProperties.get("hcjf.query.select.reserved.word"), "");
            String fromBody = matcher.group(SystemProperties.get("hcjf.query.from.group.index"));
            fromBody = fromBody.replaceFirst("(?i)" + SystemProperties.get("hcjf.query.from.reserved.word"), "");
            String conditionalBody = matcher.group(SystemProperties.get("hcjf.query.conditional.group.index"));
            if (conditionalBody != null && conditionalBody.endsWith(SystemProperties.get("hcjf.query.statement.end.reserved.word"))) {
                conditionalBody = conditionalBody.substring(0, conditionalBody.indexOf(SystemProperties.get("hcjf.query.statement.end.reserved.word")) - 1);
            }
            String resourceValue = matcher.group(SystemProperties.get("hcjf.query.resource.value.index"));
            String dynamicResource = matcher.group(SystemProperties.get("hcjf.query.dynamic.resource.group.index"));
            String dynamicResourceAlias = matcher.group(SystemProperties.get("hcjf.query.dynamic.resource.alias.group.index"));
            query = new Query(this.createResource(resourceValue, dynamicResource, dynamicResourceAlias, groups, richTexts, placesIndex));
            if (environmentBody != null && !environmentBody.isBlank()) {
                environmentBody = environmentBody.substring(environmentBody.indexOf("'")).trim();
                environmentBody = Strings.reverseRichTextGrouping(environmentBody, richTexts);
                environmentBody = environmentBody.substring(1, environmentBody.length() - 1);
                query.setEnvironment((Map)JsonUtils.createObject(environmentBody));
            }
            if (conditionalBody != null) {
                Pattern conditionalPatter = SystemProperties.getPattern("hcjf.query.conditional.regular.expression", 2);
                List conditionalElements = List.of(conditionalPatter.split(conditionalBody)).stream().filter(S -> !S.isBlank()).collect(Collectors.toList());
                for (int i = 0; i < conditionalElements.size(); ++i) {
                    String resource;
                    String element = ((String)conditionalElements.get(i++)).trim();
                    String elementValue = ((String)conditionalElements.get(i)).trim();
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.join.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.full.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.inner.join.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.left.join.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.right.join.reserved.word"))) {
                        Pattern joinPattern;
                        Matcher joinMatcher;
                        String[] type = Join.JoinType.valueOf(element.toUpperCase());
                        if (type != Join.JoinType.JOIN) {
                            elementValue = ((String)conditionalElements.get(++i)).trim();
                        }
                        if (!(joinMatcher = (joinPattern = SystemProperties.getPattern("hcjf.query.join.regular.expression")).matcher(elementValue)).matches()) {
                            throw new HCJFRuntimeException("Join syntax wrong, near '%s'", elementValue);
                        }
                        String joinDynamicResource = joinMatcher.group(SystemProperties.get("hcjf.query.join.dynamic.resource.index"));
                        String joinResourceValue = joinMatcher.group(SystemProperties.get("hcjf.query.join.resource.value"));
                        String joinDynamicResourceAlias = joinMatcher.group(SystemProperties.get("hcjf.query.join.dynamic.resource.alias.index"));
                        QueryResource joinResource = this.createResource(joinResourceValue, joinDynamicResource, joinDynamicResourceAlias, groups, richTexts, placesIndex);
                        String joinConditionalBody = joinMatcher.group(SystemProperties.get("hcjf.query.join.conditional.body.index"));
                        joinConditionalBody = Strings.reverseGrouping(joinConditionalBody, groups);
                        joinConditionalBody = Strings.reverseRichTextGrouping(joinConditionalBody, richTexts);
                        Join join = new Join(query, joinResource, (Join.JoinType)type);
                        query.getResources().add(join.getResource());
                        this.completeEvaluatorCollection(query, joinConditionalBody, groups, richTexts, join, 0, placesIndex);
                        query.addJoin(join);
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.where.reserved.word"))) {
                        this.completeEvaluatorCollection(query, elementValue, groups, richTexts, query, 0, placesIndex);
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.order.by.reserved.word"))) {
                        for (String orderField : elementValue.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                            query.addOrderParameter((QueryOrderParameter)this.processStringValue(query, groups, richTexts, orderField, placesIndex, QueryOrderParameter.class, new ArrayList<QueryField>()));
                        }
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.group.by.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.disjoint.by.reserved.word"))) {
                        for (String orderField : elementValue.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                            query.addGroupField((QueryReturnParameter)this.processStringValue(query, groups, richTexts, orderField, placesIndex, QueryReturnParameter.class, new ArrayList<QueryField>()));
                        }
                        if (!element.equalsIgnoreCase(SystemProperties.get("hcjf.query.disjoint.by.reserved.word"))) continue;
                        query.setDisjoint(true);
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.limit.reserved.word"))) {
                        if (elementValue.isBlank()) {
                            throw new HCJFRuntimeException("Undeclared limit value", new Object[0]);
                        }
                        String[] limitValues = elementValue.split(",");
                        if (limitValues.length > 0 && !limitValues[0].isBlank()) {
                            try {
                                query.setLimit(Integer.parseInt(limitValues[0].trim()));
                            }
                            catch (NumberFormatException ex) {
                                throw new HCJFRuntimeException("The limit value must be an integer", (Throwable)ex, new Object[0]);
                            }
                        }
                        if (limitValues.length <= 1 || limitValues[1].isBlank()) continue;
                        try {
                            query.setUnderlyingLimit(Integer.parseInt(limitValues[1].trim()));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new HCJFRuntimeException("The underlying limit value must be an integer", (Throwable)ex, new Object[0]);
                        }
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.start.reserved.word"))) {
                        if (elementValue.isBlank()) {
                            throw new HCJFRuntimeException("Undeclared start value", new Object[0]);
                        }
                        String[] startValues = elementValue.split(",");
                        if (startValues.length > 0 && !startValues[0].isBlank()) {
                            try {
                                query.setStart(Integer.parseInt(startValues[0].trim()));
                            }
                            catch (NumberFormatException ex) {
                                throw new HCJFRuntimeException("The start value must be an integer", (Throwable)ex, new Object[0]);
                            }
                        }
                        if (startValues.length <= 1 || startValues[1].isBlank()) continue;
                        try {
                            query.setUnderlyingStart(Integer.parseInt(startValues[1].trim()));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new HCJFRuntimeException("The underlying start value must be an integer", (Throwable)ex, new Object[0]);
                        }
                    }
                    if (!element.equalsIgnoreCase(SystemProperties.get("hcjf.query.underlying.reserved.word"))) continue;
                    Map<String, List<QueryReturnFunction>> underlyingMap = query.getUnderlyingFunctions();
                    if (underlyingMap == null) {
                        underlyingMap = new HashMap<String, List<QueryReturnFunction>>();
                        query.setUnderlyingFunctions(underlyingMap);
                    }
                    Pattern sourcePatter = SystemProperties.getPattern("hcjf.query.source.regular.expression", 2);
                    String[] underlyingParts = sourcePatter.split(elementValue);
                    String functionsBody = underlyingParts[0];
                    ArrayList<QueryReturnFunction> functions = new ArrayList<QueryReturnFunction>();
                    if (underlyingParts.length == 1) {
                        resource = query.getResourceName();
                    } else if (underlyingParts.length == 3) {
                        resource = underlyingParts[2];
                    } else {
                        throw new HCJFRuntimeException("Malformed query underlying body", new Object[0]);
                    }
                    for (String functionBody : functionsBody.split(",")) {
                        functions.add((QueryReturnFunction)this.processStringValue(query, groups, richTexts, functionBody, placesIndex, QueryReturnParameter.class, new ArrayList<QueryField>()));
                    }
                    underlyingMap.put(resource, functions);
                }
            }
            for (String returnField : selectBody.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                QueryReturnParameter queryReturnParameter = (QueryReturnParameter)this.processStringValue(query, groups, richTexts, returnField, placesIndex, QueryReturnParameter.class, new ArrayList<QueryField>());
                if (queryReturnParameter.getAlias().isBlank()) continue;
                query.addReturnField(queryReturnParameter);
            }
        } else {
            String value = queryDefinition;
            int place = Strings.getNoMatchPlace(matcher, queryDefinition);
            String nearFrom = Strings.getNearFrom(value, place, 5);
            throw new HCJFRuntimeException("Query match fail near from ( '...%s...' ), query body: '%s'", new Object[]{nearFrom, value});
        }
        for (int i = 2; i < unions.length; i += 2) {
            groups.set(groups.size() - 1, unions[i].trim());
            query.addUnion(this.compile(groups, richTexts, groups.size() - 1, placesIndex));
        }
        return query;
    }

    private QueryResource createResource(String resourceValue, String dynamicResource, String dynamicResourceAlias, List<String> groups, List<String> richTexts, AtomicInteger placesIndex) {
        QueryResource result;
        if (dynamicResource.isBlank()) {
            result = new QueryResource(resourceValue.trim());
        } else if (resourceValue.startsWith("'") && resourceValue.endsWith("'")) {
            String text = Strings.reverseRichTextGrouping(resourceValue, richTexts);
            if ((text = text.substring(1, text.length() - 1).trim()).startsWith("[") && text.endsWith("]") || text.startsWith("{") && text.endsWith("}")) {
                Object object = JsonUtils.createObject(text);
                List<Map<String, Object>> resourceValues = object instanceof Collection ? (List<Map<String, Object>>)object : List.of((Map)object);
                result = new QueryJsonResource(dynamicResourceAlias.trim(), resourceValues);
            } else {
                result = new QueryTextResource(dynamicResourceAlias.trim(), text);
            }
        } else {
            String path = null;
            if (resourceValue.indexOf(".") > 0) {
                path = resourceValue.substring(resourceValue.indexOf(".") + 1).trim();
                resourceValue = resourceValue.substring(0, resourceValue.indexOf("."));
            }
            Integer index = Strings.getGroupIndexAsNumber(resourceValue.trim(), "\u00bf");
            resourceValue = Strings.reverseGrouping(resourceValue, groups);
            resourceValue = Strings.reverseRichTextGrouping(resourceValue, richTexts);
            Query subQuery = (resourceValue = resourceValue.substring(1, resourceValue.length() - 1)).toUpperCase().startsWith(SystemProperties.get("hcjf.query.select.reserved.word")) ? this.compile(groups, richTexts, index, placesIndex) : this.compileSingleQuery(resourceValue);
            result = new QueryDynamicResource(dynamicResourceAlias.trim(), subQuery, path);
        }
        return result;
    }

    private final void completeEvaluatorCollection(Query query, String startElement, List<String> groups, List<String> richTexts, EvaluatorCollection parentCollection, Integer definitionIndex, AtomicInteger placesIndex) {
        Pattern wherePatter = SystemProperties.getPattern("hcjf.query.evaluator.collection.regular.expression", 2);
        String[] evaluatorDefinitions = startElement != null ? wherePatter.split(startElement) : wherePatter.split(groups.get(definitionIndex));
        EvaluatorCollection collection = null;
        ArrayList<String> pendingDefinitions = new ArrayList<String>();
        for (String definition : evaluatorDefinitions) {
            if ((definition = definition.trim()).equalsIgnoreCase(SystemProperties.get("hcjf.query.and.reserved.word"))) {
                if (collection == null) {
                    if (parentCollection instanceof Query || parentCollection instanceof Join || parentCollection instanceof And) {
                        collection = parentCollection;
                        continue;
                    }
                    collection = parentCollection.and();
                    continue;
                }
                if (!(collection instanceof Or)) continue;
                if (parentCollection instanceof Query || parentCollection instanceof Join || parentCollection instanceof And) {
                    collection = parentCollection;
                    continue;
                }
                collection = parentCollection.and();
                continue;
            }
            if (definition.equalsIgnoreCase(SystemProperties.get("hcjf.query.or.reserved.word"))) {
                if (collection == null) {
                    if (parentCollection instanceof Or) {
                        collection = parentCollection;
                        continue;
                    }
                    collection = parentCollection.or();
                    continue;
                }
                if (!(collection instanceof Query) && !(collection instanceof Join) && !(collection instanceof And)) continue;
                if (parentCollection instanceof Or) {
                    collection = parentCollection;
                    continue;
                }
                collection = parentCollection.or();
                continue;
            }
            pendingDefinitions.add(definition);
            if (collection != null) {
                for (String pendingDefinition : pendingDefinitions) {
                    this.processDefinition(query, pendingDefinition, collection, groups, richTexts, placesIndex);
                }
                pendingDefinitions.clear();
                continue;
            }
            if (pendingDefinitions.size() <= 1) continue;
            throw new IllegalArgumentException("");
        }
        for (String pendingDefinition : pendingDefinitions) {
            if (collection != null) {
                this.processDefinition(query, pendingDefinition, collection, groups, richTexts, placesIndex);
                continue;
            }
            this.processDefinition(query, pendingDefinition, parentCollection, groups, richTexts, placesIndex);
        }
    }

    private void processDefinition(Query query, String definition, EvaluatorCollection collection, List<String> groups, List<String> richTexts, AtomicInteger placesIndex) {
        String[] evaluatorValues = definition.split(SystemProperties.get("hcjf.query.operation.regular.expression"));
        if (evaluatorValues.length == 1 && definition.startsWith("\u00bf")) {
            Integer index = Strings.getGroupIndexAsNumber(definition, "\u00bf");
            this.completeEvaluatorCollection(query, null, groups, richTexts, collection, index, placesIndex);
        } else {
            BaseEvaluator evaluator;
            boolean operatorDone = false;
            Object firstArgument = "";
            Object secondArgument = "";
            Object operator = "";
            for (String evaluatorValue : evaluatorValues) {
                if ((evaluatorValue = evaluatorValue.trim()).equalsIgnoreCase(SystemProperties.get("hcjf.query.not.reserved.word"))) {
                    operator = (String)operator + evaluatorValue + " ";
                    continue;
                }
                if (evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.not.2.reserved.word"))) {
                    operator = (String)operator + evaluatorValue;
                    continue;
                }
                if (evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.2.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.equals.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.or.equals.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.in.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.like.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.or.equals.reserved.word"))) {
                    operator = (String)operator + evaluatorValue;
                    operatorDone = true;
                    continue;
                }
                if (operatorDone) {
                    secondArgument = (String)secondArgument + evaluatorValue + " ";
                    continue;
                }
                firstArgument = (String)firstArgument + evaluatorValue + " ";
            }
            ArrayList<QueryField> presentFields = new ArrayList<QueryField>();
            if (operator == null || ((String)operator).trim().isEmpty()) {
                Object leftValue = this.processStringValue(query, groups, richTexts, ((String)firstArgument).trim(), placesIndex, QueryParameter.class, presentFields);
                evaluator = new BooleanEvaluator(leftValue);
            } else {
                Object rightValue;
                Object leftValue = this.processStringValue(query, groups, richTexts, ((String)firstArgument).trim(), placesIndex, QueryParameter.class, presentFields);
                if (leftValue instanceof String) {
                    leftValue = Strings.reverseGrouping((String)leftValue, groups);
                }
                if ((rightValue = this.processStringValue(query, groups, richTexts, ((String)secondArgument).trim(), placesIndex, QueryParameter.class, presentFields)) instanceof String) {
                    rightValue = Strings.reverseGrouping((String)rightValue, groups);
                }
                if (((String)(operator = ((String)operator).trim())).equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.reserved.word")) || ((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.2.reserved.word"))) {
                    evaluator = new Distinct(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.equals.reserved.word"))) {
                    evaluator = new Equals(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.reserved.word"))) {
                    evaluator = new GreaterThan(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.or.equals.reserved.word"))) {
                    evaluator = new GreaterThanOrEqual(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.in.reserved.word"))) {
                    evaluator = new In(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.like.reserved.word"))) {
                    evaluator = new Like(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.not.in.reserved.word"))) {
                    evaluator = new NotIn(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.reserved.word"))) {
                    evaluator = new SmallerThan(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.or.equals.reserved.word"))) {
                    evaluator = new SmallerThanOrEqual(leftValue, rightValue);
                } else {
                    throw new HCJFRuntimeException("Unsupported operator '%s', near '%s'", operator, definition);
                }
            }
            if (evaluator instanceof BaseEvaluator) {
                ((BaseEvaluator)evaluator).setEvaluatorFields(presentFields);
            }
            collection.addEvaluator(evaluator);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object processStringValue(Query query, List<String> groups, List<String> richTexts, String stringValue, AtomicInteger placesIndex, Class parameterClass, List<QueryField> presentFields) {
        Object result = null;
        String trimmedStringValue = stringValue.trim();
        String alias = null;
        String[] trimmedStringValueParts = trimmedStringValue.split(SystemProperties.get("hcjf.query.as.regular.expression"));
        if (trimmedStringValueParts.length == 3) {
            trimmedStringValue = trimmedStringValueParts[0].trim();
            alias = trimmedStringValueParts[2].trim();
        }
        Boolean literal = false;
        if (trimmedStringValue.equals(SystemProperties.get("hcjf.query.replaceable.value.reserved.word"))) {
            result = new BaseEvaluator.ReplaceableValue(placesIndex.getAndAdd(1));
        } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.null.reserved.word"))) {
            result = null;
            literal = true;
        } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.true.reserved.word"))) {
            result = true;
            literal = true;
        } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.false.reserved.word"))) {
            result = false;
            literal = true;
        } else if (trimmedStringValue.startsWith(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"))) {
            if (!trimmedStringValue.endsWith(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"))) throw new HCJFRuntimeException("Expecting string en delimiter, near %s", trimmedStringValue);
            trimmedStringValue = trimmedStringValue.substring(1, trimmedStringValue.length() - 1);
            trimmedStringValue = richTexts.get(Strings.getGroupIndexAsNumber(trimmedStringValue, "\u00a1"));
            trimmedStringValue = trimmedStringValue.replace("\\'", "'");
            try {
                result = SystemProperties.getDateFormat("hcjf.query.date.format").parse(trimmedStringValue);
            }
            catch (Exception ex) {
                while (trimmedStringValue.contains("\u00bf")) {
                    trimmedStringValue = Strings.reverseGrouping(trimmedStringValue, groups);
                }
                result = trimmedStringValue;
            }
            literal = true;
        } else if (trimmedStringValue.matches("\u00bf[0-9]*\u00b7{1,}")) {
            Integer index = Strings.getGroupIndexAsNumber(trimmedStringValue, "\u00bf");
            String group = groups.get(index);
            if (group.toUpperCase().startsWith(SystemProperties.get("hcjf.query.select.reserved.word"))) {
                BaseEvaluator.QueryValue queryValue = new BaseEvaluator.QueryValue(this.compile(groups, richTexts, index, placesIndex), parameterClass.equals(QueryReturnParameter.class));
                result = alias != null ? new QueryReturnUnprocessedValue(query, trimmedStringValue, alias, queryValue) : queryValue;
            } else if (group.toUpperCase().contains(Strings.wrap(SystemProperties.get("hcjf.query.and.reserved.word"), " ")) || group.toUpperCase().contains(Strings.wrap(SystemProperties.get("hcjf.query.or.reserved.word"), " "))) {
                if (!parameterClass.equals(QueryReturnParameter.class)) throw new HCJFRuntimeException("The conditional block is only for return values", new Object[0]);
                String conditionalBlock = Strings.reverseGrouping(trimmedStringValue, groups);
                conditionalBlock = Strings.reverseRichTextGrouping(conditionalBlock, richTexts);
                result = alias != null ? new QueryReturnConditional(query, conditionalBlock, conditionalBlock, alias) : new QueryConditional.ConditionalValue(conditionalBlock);
            } else if (!group.matches(SystemProperties.get("hcjf.uuid.regex")) && group.matches(SystemProperties.get("hcjf.math.connector.regular.expression")) && group.matches(SystemProperties.get("hcjf.math.regular.expression"))) {
                result = this.processStringValue(query, groups, richTexts, group, placesIndex, parameterClass, presentFields);
            } else {
                ArrayList<Object> collection = new ArrayList<Object>();
                for (String subStringValue : group.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                    collection.add(this.processStringValue(query, groups, richTexts, subStringValue.trim(), placesIndex, parameterClass, presentFields));
                }
                result = collection;
            }
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.uuid.regex"))) {
            result = UUID.fromString(trimmedStringValue);
            literal = true;
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.integer.number.regex"))) {
            try {
                result = Long.parseLong(trimmedStringValue);
            }
            catch (Exception ex) {
                result = trimmedStringValue;
            }
            literal = true;
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.decimal.number.regex"))) {
            try {
                result = SystemProperties.getDecimalFormat("hcjf.query.decimal.format").parse(trimmedStringValue);
            }
            catch (ParseException e) {
                result = trimmedStringValue;
            }
            literal = true;
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.scientific.number.regex"))) {
            try {
                result = SystemProperties.getDecimalFormat("hcjf.query.scientific.notation.format").parse(trimmedStringValue);
            }
            catch (ParseException e) {
                result = trimmedStringValue;
            }
            literal = true;
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.math.connector.regular.expression")) && trimmedStringValue.matches(SystemProperties.get("hcjf.math.regular.expression"))) {
            String[] mathExpressionParts = trimmedStringValue.split(SystemProperties.get("hcjf.math.splitter.regular.expression"));
            ArrayList<Object> parameters = new ArrayList<Object>();
            boolean desc = false;
            for (int i = 0; i < mathExpressionParts.length; ++i) {
                String currentValue = mathExpressionParts[i];
                if (i == mathExpressionParts.length - 1) {
                    String[] parts;
                    if (parameterClass.equals(QueryReturnParameter.class)) {
                        parts = currentValue.split(SystemProperties.get("hcjf.query.as.regular.expression"));
                        if (parts.length == 2) {
                            currentValue = parts[0].trim();
                            alias = parts[1].trim();
                        }
                    } else if (parameterClass.equals(QueryOrderParameter.class) && (parts = currentValue.split(SystemProperties.get("hcjf.query.desc.regular.expression"))).length == 3) {
                        currentValue = parts[0].trim();
                        if (parts[2].trim().equalsIgnoreCase(SystemProperties.get("hcjf.query.desc.reserved.word"))) {
                            desc = true;
                        }
                    }
                }
                if (currentValue.matches(SystemProperties.get("hcjf.math.connector.regular.expression"))) {
                    parameters.add(currentValue.trim());
                    continue;
                }
                parameters.add(this.processStringValue(query, groups, richTexts, currentValue, placesIndex, QueryParameter.class, presentFields));
            }
            if (parameterClass.equals(QueryParameter.class)) {
                result = new QueryFunction(query, Strings.reverseGrouping(trimmedStringValue, groups), SystemProperties.get("hcjf.query.function.math.eval.expression.name"), parameters);
            } else if (parameterClass.equals(QueryReturnParameter.class)) {
                result = new QueryReturnFunction(query, Strings.reverseGrouping(trimmedStringValue, groups), SystemProperties.get("hcjf.query.function.math.eval.expression.name"), parameters, alias);
            } else if (parameterClass.equals(QueryOrderParameter.class)) {
                result = new QueryOrderFunction(query, Strings.reverseGrouping(trimmedStringValue, groups), SystemProperties.get("hcjf.query.function.math.eval.expression.name"), parameters, desc);
            }
        } else {
            String functionName = null;
            String originalValue = null;
            String replaceValue = null;
            String group = null;
            ArrayList<Object> functionParameters = null;
            Boolean function = false;
            Boolean unprocessedValue = false;
            if (trimmedStringValue.contains("\u00bf")) {
                replaceValue = Strings.getNextGroupIndex(trimmedStringValue, "\u00bf");
                group = groups.get(Strings.getGroupIndexAsNumber(replaceValue, "\u00bf"));
                functionName = trimmedStringValue.substring(0, trimmedStringValue.indexOf("\u00bf"));
                if (functionName == null || functionName.isBlank()) {
                    originalValue = Strings.reverseGrouping(trimmedStringValue, groups);
                    unprocessedValue = true;
                } else {
                    originalValue = Strings.reverseGrouping(trimmedStringValue, groups);
                    functionParameters = new ArrayList<Object>();
                    for (String param : group.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                        if (param.isBlank()) continue;
                        Object processedParam = this.processStringValue(query, groups, richTexts, param, placesIndex, parameterClass, presentFields);
                        if (processedParam instanceof QueryConditional.ConditionalValue) {
                            String conditional = ((QueryConditional.ConditionalValue)processedParam).getValue();
                            functionParameters.add(new QueryReturnConditional(query, conditional, conditional, null));
                            continue;
                        }
                        functionParameters.add(processedParam);
                    }
                    originalValue = Strings.reverseRichTextGrouping(originalValue, richTexts);
                    function = true;
                }
            } else {
                originalValue = trimmedStringValue;
            }
            if (parameterClass.equals(QueryParameter.class)) {
                result = function.booleanValue() ? new QueryFunction(query, originalValue, functionName, functionParameters) : new QueryField(query, originalValue);
            } else if (parameterClass.equals(QueryReturnParameter.class)) {
                List<String> subGroups = Strings.replaceableGroup(originalValue);
                originalValue = subGroups.get(subGroups.size() - 1);
                originalValue = Strings.reverseGrouping(originalValue, subGroups);
                if (function.booleanValue()) {
                    result = new QueryReturnFunction(query, originalValue, functionName, functionParameters, alias);
                } else if (unprocessedValue.booleanValue()) {
                    if (alias == null) {
                        throw new HCJFRuntimeException("Unable to create a unprocessed value without alias", new Object[0]);
                    }
                    Object newValue = this.processStringValue(query, groups, richTexts, replaceValue, placesIndex, parameterClass, presentFields);
                    if (newValue instanceof QueryReturnParameter) {
                        result = newValue;
                    } else if (newValue instanceof BaseEvaluator.UnprocessedValue) {
                        result = new QueryReturnUnprocessedValue(query, originalValue, alias, (BaseEvaluator.UnprocessedValue)newValue);
                    } else if (newValue instanceof QueryConditional.ConditionalValue) {
                        String conditional = ((QueryConditional.ConditionalValue)newValue).getValue();
                        result = new QueryReturnConditional(query, conditional, conditional, alias);
                    } else {
                        result = new QueryReturnField(query, (String)newValue, alias);
                    }
                } else {
                    result = new QueryReturnField(query, originalValue, alias);
                }
            } else if (parameterClass.equals(QueryOrderParameter.class)) {
                boolean desc = false;
                String[] parts = originalValue.split(SystemProperties.get("hcjf.query.desc.regular.expression"));
                if (parts.length == 2) {
                    originalValue = parts[0].trim();
                    if (parts[1].trim().equalsIgnoreCase(SystemProperties.get("hcjf.query.desc.reserved.word"))) {
                        desc = true;
                    }
                }
                result = function != false ? new QueryOrderFunction(query, originalValue, functionName, functionParameters, desc) : new QueryOrderField(query, originalValue, desc);
            }
        }
        if (alias != null && literal.booleanValue()) {
            result = new QueryReturnLiteral(query, trimmedStringValue, trimmedStringValue, result, alias);
        }
        if (!(result instanceof QueryField)) return result;
        presentFields.add((QueryField)result);
        return result;
    }
}

