/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.evaluators;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.utils.Introspection;

public abstract class BaseEvaluator
implements Evaluator {
    private List<QueryField> evaluatorFields;
    private boolean trueForced;

    public boolean isTrueForced() {
        return this.trueForced;
    }

    public void setTrueForced(boolean trueForced) {
        this.trueForced = trueForced;
    }

    public final List<QueryField> getEvaluatorFields() {
        return this.evaluatorFields;
    }

    public final void setEvaluatorFields(List<QueryField> evaluatorFields) {
        this.evaluatorFields = evaluatorFields;
    }

    protected final Object getProcessedValue(Object currentResultSetElement, Object rawValue, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        Object result = rawValue;
        if (result != null) {
            if (result instanceof UnprocessedValue) {
                if (result instanceof QueryValue) {
                    QueryValue queryValue = (QueryValue)result;
                    Map<String, Object> originalEnvironment = queryValue.getQuery().getEnvironment();
                    HashMap<Object, Object> newEnvironment = originalEnvironment != null ? new HashMap<String, Object>(originalEnvironment) : new HashMap();
                    newEnvironment.putAll(Introspection.toMap(currentResultSetElement));
                    queryValue.getQuery().setEnvironment(newEnvironment);
                    result = queryValue.process(dataSource, consumer);
                    queryValue.getQuery().setEnvironment(originalEnvironment);
                } else {
                    result = ((UnprocessedValue)result).process(dataSource, consumer);
                }
            } else if (result instanceof QueryParameter) {
                result = ((QueryParameter)result).isUnderlying() ? Boolean.valueOf(true) : consumer.get(currentResultSetElement, (QueryParameter)result, dataSource);
            } else if (result instanceof Collection) {
                ArrayList<Object> collectionResult = new ArrayList<Object>();
                for (Object internalValue : (Collection)result) {
                    collectionResult.add(this.getProcessedValue(currentResultSetElement, internalValue, dataSource, consumer));
                }
                result = collectionResult;
            } else if (result.getClass().isArray()) {
                ArrayList<Object> collectionResult = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(result); ++i) {
                    collectionResult.add(this.getProcessedValue(currentResultSetElement, Array.get(result, i), dataSource, consumer));
                }
                result = collectionResult;
            }
        }
        return result;
    }

    public static class QueryValue
    implements UnprocessedValue {
        private final Query query;
        private final Boolean rawValue;
        private Boolean cachedResult;
        private Object cache;

        public QueryValue(Query query, Boolean rawValue) {
            this.query = query;
            this.rawValue = rawValue;
            this.cachedResult = false;
            this.cache = null;
        }

        public Query getQuery() {
            return this.query;
        }

        @Override
        public Object process(Queryable.DataSource dataSource, Queryable.Consumer consumer) {
            Object result;
            if (this.rawValue.booleanValue()) {
                result = this.query.evaluate(dataSource, consumer);
            } else if (!this.cachedResult.booleanValue()) {
                Collection<JoinableMap> collection;
                Collection<JoinableMap> subQueryResult = this.query.evaluate(new Queryable.ReadableDataSource(), consumer);
                if (this.query.getReturnParameters().size() == 1) {
                    QueryReturnParameter queryReturnParameter = this.query.getReturnParameters().get(0);
                    ArrayList<JoinableMap> listResult = new ArrayList<JoinableMap>();
                    for (JoinableMap element : subQueryResult) {
                        Object value = Introspection.resolve((Object)element, queryReturnParameter.getAlias());
                        if (value == null) continue;
                        listResult.add((JoinableMap)value);
                    }
                    collection = listResult;
                } else {
                    collection = subQueryResult;
                }
                result = collection.size() == 0 ? null : (collection.size() == 1 ? collection.iterator().next() : collection);
                this.cache = result;
                this.cachedResult = true;
            } else {
                result = this.cache;
            }
            return result;
        }
    }

    public static class ReplaceableValue
    implements UnprocessedValue {
        private final Integer place;

        public ReplaceableValue(Integer place) {
            this.place = place;
        }

        @Override
        public Object process(Queryable.DataSource dataSource, Queryable.Consumer consumer) {
            return consumer.getParameter(this.place);
        }

        public final Integer getPlace() {
            return this.place;
        }
    }

    public static interface UnprocessedValue {
        public Object process(Queryable.DataSource var1, Queryable.Consumer var2);
    }
}

