/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hcjf.layers.query.functions.BaseQueryAggregateFunctionLayer;
import org.hcjf.layers.query.functions.NumberSetFunction;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.Maths;

public class ForecastFunctionLayer
extends BaseQueryAggregateFunctionLayer
implements NumberSetFunction {
    private static final String IMPL_NAME = "forecast";

    public ForecastFunctionLayer() {
        super(IMPL_NAME);
    }

    @Override
    public Collection evaluate(String alias, Collection resultSet, Object ... parameters) {
        String independentVariablePath = (String)this.getParameter(0, parameters);
        String dependentVariablePath = (String)this.getParameter(1, parameters);
        Boolean polynomialRegression = true;
        Integer degree = 3;
        Double errorThreshold = 0.001;
        if (parameters.length >= 3) {
            polynomialRegression = (Boolean)this.getParameter(2, parameters);
        }
        if (polynomialRegression.booleanValue()) {
            if (parameters.length >= 4) {
                degree = ((Number)this.getParameter(3, parameters)).intValue();
            }
            if (parameters.length == 5) {
                errorThreshold = ((Number)this.getParameter(4, parameters)).doubleValue();
            }
        }
        ArrayList objectsWithUnknowns = new ArrayList();
        ArrayList<Number> independentValues = new ArrayList<Number>();
        ArrayList<Number> dependentValues = new ArrayList<Number>();
        ArrayList<Number> unknowns = new ArrayList<Number>();
        for (Object obj : resultSet) {
            Number x = (Number)Introspection.resolve(obj, independentVariablePath);
            Number y = (Number)Introspection.resolve(obj, dependentVariablePath);
            if (x == null) continue;
            if (y == null) {
                objectsWithUnknowns.add(obj);
                unknowns.add(x);
                continue;
            }
            independentValues.add(x);
            dependentValues.add(y);
        }
        List<Number> newDependentValues = polynomialRegression != false ? Maths.polynomialRegression(independentValues, dependentValues, unknowns, degree, errorThreshold) : Maths.linearRegression(independentValues, dependentValues, unknowns);
        for (int i = 0; i < newDependentValues.size(); ++i) {
            Introspection.put(objectsWithUnknowns.get(i), (Object)newDependentValues.get(i), dependentVariablePath);
        }
        return resultSet;
    }
}

