/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.JsonUtils;
import org.hcjf.utils.Matrix;

public class ObjectQueryFunction
extends BaseQueryFunctionLayer
implements QueryFunctionLayerInterface {
    private static final String IS_NOT_NULL = "isNotNull";
    private static final String IS_NULL = "isNull";
    private static final String IS_COLLECTION = "isCollection";
    private static final String IS_MAP = "isMap";
    private static final String IS_DATE = "isDate";
    private static final String IS_STRING = "isString";
    private static final String IS_NUMBER = "isNumber";
    private static final String INSTANCE_OF = "instanceOf";
    private static final String IF = "if";
    private static final String CASE = "case";
    private static final String EQUALS = "equals";
    private static final String NEW = "new";
    private static final String NEW_UUID = "newUUID";
    private static final String UUID_TO_BASE64 = "uuidToBase64";
    private static final String BASE64_TO_UUID = "base64ToUuid";
    private static final String NEW_MAP = "newMap";
    private static final String NEW_ARRAY = "newArray";
    private static final String JSON_TO_OBJECT = "jsonToObject";

    public ObjectQueryFunction() {
        super(SystemProperties.get("hcjf.query.function.object.name"));
        this.addFunctionName(IS_NOT_NULL);
        this.addFunctionName(IS_NULL);
        this.addFunctionName(IS_COLLECTION);
        this.addFunctionName(IS_MAP);
        this.addFunctionName(IS_DATE);
        this.addFunctionName(IS_STRING);
        this.addFunctionName(IS_NUMBER);
        this.addFunctionName(INSTANCE_OF);
        this.addFunctionName(IF);
        this.addFunctionName(CASE);
        this.addFunctionName(EQUALS);
        this.addFunctionName(NEW);
        this.addFunctionName(NEW_UUID);
        this.addFunctionName(UUID_TO_BASE64);
        this.addFunctionName(BASE64_TO_UUID);
        this.addFunctionName(NEW_MAP);
        this.addFunctionName(NEW_ARRAY);
        this.addFunctionName(JSON_TO_OBJECT);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result = null;
        block20 : switch (functionName) {
            case "isNotNull": {
                boolean booleanValue = false;
                for (Object parameter : parameters) {
                    boolean bl = booleanValue = parameter != null;
                    if (!booleanValue) break;
                }
                result = booleanValue;
                break;
            }
            case "isNull": {
                boolean booleanValue = false;
                for (Object parameter : parameters) {
                    boolean bl = booleanValue = parameter == null;
                    if (booleanValue) break;
                }
                result = booleanValue;
                break;
            }
            case "if": {
                Boolean condition = (Boolean)this.getParameter(0, parameters);
                if (condition != null && condition.booleanValue()) {
                    result = this.getParameter(1, parameters);
                    break;
                }
                if (parameters.length != 3) break;
                result = this.getParameter(2, parameters);
                break;
            }
            case "case": {
                Object mainValue = this.getParameter(0, parameters);
                for (int i = 1; i < parameters.length; i += 2) {
                    if (i + 1 < parameters.length) {
                        if (!mainValue.equals(parameters[i])) continue;
                        result = parameters[i + 1];
                        break block20;
                    }
                    result = parameters[i];
                }
                break;
            }
            case "isCollection": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Collection;
                break;
            }
            case "isMap": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Map;
                break;
            }
            case "isDate": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Date;
                break;
            }
            case "isString": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof String;
                break;
            }
            case "isNumber": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Number;
                break;
            }
            case "instanceOf": {
                Object parameter = null;
                if (parameters.length == 1) {
                    parameter = parameters[0];
                }
                if (parameter == null) {
                    result = "NULL";
                    break;
                }
                if (parameter instanceof Collection) {
                    result = "COLLECTION";
                    break;
                }
                if (parameter instanceof Map) {
                    result = "MAP";
                    break;
                }
                if (parameter instanceof Date) {
                    result = "DATE";
                    break;
                }
                if (parameter instanceof String) {
                    result = "STRING";
                    break;
                }
                if (parameter instanceof Number) {
                    result = "NUMBER";
                    break;
                }
                if (parameter instanceof UUID) {
                    result = "UUID";
                    break;
                }
                if (parameter instanceof Boolean) {
                    result = "BOOLEAN";
                    break;
                }
                if (parameter instanceof Matrix) {
                    result = "MATRIX";
                    break;
                }
                result = "OBJECT";
                break;
            }
            case "equals": {
                Object parameter1 = this.getParameter(0, parameters);
                Object parameter2 = this.getParameter(1, parameters);
                if (parameter1 instanceof Number && parameter2 instanceof Number) {
                    BigDecimal bigDecimal1 = BigDecimal.valueOf(((Number)parameter1).doubleValue());
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)parameter2).doubleValue());
                    result = bigDecimal1.equals(bigDecimal2);
                    break;
                }
                result = Objects.equals(parameter1, parameter2);
                break;
            }
            case "new": {
                if (parameters.length == 1) {
                    result = this.getParameter(0, parameters);
                    break;
                }
                result = null;
                break;
            }
            case "newUUID": {
                result = UUID.randomUUID();
                break;
            }
            case "uuidToBase64": {
                int i;
                UUID uuid = (UUID)this.getParameter(0, parameters);
                long msb = uuid.getMostSignificantBits();
                long lsb = uuid.getLeastSignificantBits();
                byte[] buffer = new byte[16];
                for (i = 0; i < 8; ++i) {
                    buffer[7 - i] = (byte)(msb >>> 8 * (7 - i));
                }
                for (i = 8; i < 16; ++i) {
                    buffer[23 - i] = (byte)(lsb >>> 8 * (7 - i));
                }
                result = Base64.getEncoder().encodeToString(buffer);
                break;
            }
            case "base64ToUuid": {
                int i;
                String base64 = (String)this.getParameter(0, parameters);
                byte[] decoded = Base64.getDecoder().decode(base64);
                long msb = 0L;
                long lsb = 0L;
                for (i = 7; i >= 0; --i) {
                    msb = msb << 8 | (long)(decoded[i] & 0xFF);
                }
                for (i = 15; i >= 8; --i) {
                    lsb = lsb << 8 | (long)(decoded[i] & 0xFF);
                }
                result = new UUID(msb, lsb);
                break;
            }
            case "newMap": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < parameters.length; i += 2) {
                    String key = parameters[i].toString();
                    Object value = null;
                    if (parameters.length > i + 1) {
                        value = parameters[i + 1];
                    }
                    map.put(key, value);
                }
                result = map;
                break;
            }
            case "newArray": {
                ArrayList<Object> collection = new ArrayList<Object>();
                for (Object parameter : parameters) {
                    if (parameter instanceof Collection) {
                        collection.addAll((Collection)parameter);
                        continue;
                    }
                    if (parameter.getClass().isArray()) {
                        collection.addAll(Arrays.asList(parameter));
                        continue;
                    }
                    collection.add(parameter);
                }
                result = collection;
                break;
            }
            case "jsonToObject": {
                String stringValue = (String)this.getParameter(0, parameters);
                result = JsonUtils.createObject(stringValue);
                break;
            }
        }
        return result;
    }

    private static final class InstanceOfValues {
        private static final String NULL = "NULL";
        private static final String COLLECTION = "COLLECTION";
        private static final String MAP = "MAP";
        private static final String DATE = "DATE";
        private static final String STRING = "STRING";
        private static final String NUMBER = "NUMBER";
        private static final String UUID = "UUID";
        private static final String BOOLEAN = "BOOLEAN";
        private static final String OBJECT = "OBJECT";
        private static final String MATRIX = "MATRIX";

        private InstanceOfValues() {
        }
    }
}

