/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.util.Collection;
import java.util.List;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.ParameterizedQuery;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.properties.SystemProperties;

public class ReferenceFunctionLayer
extends BaseQueryFunctionLayer
implements QueryFunctionLayerInterface {
    private static final String QUERY = "SELECT * FROM %s WHERE %s IN ?";

    public ReferenceFunctionLayer() {
        super(SystemProperties.get("hcjf.query.function.reference.name"));
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result;
        Object param;
        String resourceName = (String)this.getParameter(0, parameters);
        String referenceField = "id";
        if (parameters.length >= 3) {
            referenceField = (String)this.getParameter(1, parameters);
            param = this.getParameter(2, parameters);
        } else {
            param = this.getParameter(1, parameters);
        }
        ParameterizedQuery parameterizedQuery = Query.compile(String.format(QUERY, resourceName, referenceField)).getParameterizedQuery();
        if (param != null) {
            if (param instanceof Collection) {
                parameterizedQuery.add(param);
                result = Query.evaluate(parameterizedQuery);
            } else {
                parameterizedQuery.add(List.of(param));
                Collection<JoinableMap> collection = Query.evaluate(parameterizedQuery);
                result = collection.size() == 1 ? collection.stream().findFirst().get() : null;
            }
        } else {
            result = null;
        }
        return result;
    }
}

